/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.orion;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.ui.link.BLinkTemplate;
import com.tridiumx.entsecHx.access.fieldeditors.BHxAccessZoneGroupingFE;
import com.tridiumx.entsecHx.access.orion.BHxAccessZoneEntryReaderJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxAccessZoneExitReaderJoinFE;
import com.tridiumx.entsecHx.access.orion.BHxSupervisorJoinFE;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.orionToolsHx.BHxJoinFE;
import com.tridiumx.entsecHx.orionToolsHx.BHxOrionSummary;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:AccessZoneRec"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAccessZoneRecView
extends BHxAppView {
    public static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BHxAccessZoneRecView.class).getModuleName());
    public static final BHxAccessZoneRecView INSTANCE = new BHxAccessZoneRecView();
    public static final Type TYPE = Sys.loadType(BHxAccessZoneRecView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAccessZoneRecView() {
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        BAccessZoneRec rec = (BAccessZoneRec)op.get();
        Array a = new Array((Object[])super.getButtonCommands(op));
        return (SmartCommand[])a.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BObject save(HxOp op) throws Exception {
        BObject saved = super.save(op);
        BAccessZoneRec rec = (BAccessZoneRec)op.get();
        if (rec.getStationName().equals("")) {
            OrionSession session = null;
            try {
                session = rec.getOrionDatabase().createSession(null);
                rec = (BAccessZoneRec)session.read((BIOrionObject)rec);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        if (rec.getStationName().equals(Sys.getStation().getStationName())) {
            BAccessZone zone = (BAccessZone)this.getMappedComponent(op);
            if (zone != null) {
                zone.doRecount();
            }
        } else {
            try {
                if (rec.getStationName().length() > 0) {
                    RemoteUtil.invokeRemote((String)rec.getStationName(), (BOrd)rec.getMappedOrd(), (Action)BAccessZone.recount, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved;
    }

    @Override
    public BComponent getMappedComponent(HxOp op) {
        BComponent c = super.getMappedComponent(op);
        if (c != null) {
            c.lease(4);
        }
        return c;
    }

    @Override
    public BComponent getNewInstance(BTypeSpec typeSpec, HxOp op) {
        BAccessZone accessZone = (BAccessZone)op.getRequest().getSession().getAttribute("accessZoneInstance");
        if (accessZone != null) {
            return accessZone;
        }
        return super.getNewInstance(typeSpec, op);
    }

    @Override
    public BComponent getNewlyMappedParent(HxOp op) {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        return service.getAccessZones();
    }

    @Override
    public Tab[] getFieldEditors(HxOp op) throws Exception {
        Array a = new Array(Tab.class);
        BAccessZoneRec rec = (BAccessZoneRec)op.get();
        BComponent mappedComponent = this.getMappedComponent(op);
        boolean localStationIsSupervisor = RemoteUtil.isSupervisor();
        boolean available = mappedComponent != null;
        boolean local = rec.getStationName().equals(Sys.getStation().getStationName()) || mappedComponent != null && (!mappedComponent.isMounted() || !(mappedComponent.getSession() instanceof BFoxSession));
        BHxAccessZoneEntryReaderJoinFE entryReaderFE = BHxAccessZoneEntryReaderJoinFE.INSTANCE;
        OrdTarget target = new OrdTarget((OrdTarget)op, (BObject)BEntryReaderZoneJoin.ORION_TYPE.getOrionTypeId());
        HxOp entryReadersOp = op.make("entryReaders", target);
        entryReadersOp.mergeFacets(BHxSmartTableView.finishLater);
        String displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BEntryReaderZoneJoin.TYPE, BAccReaderRec.TYPE, op);
        Tab entryReaderTab = new Tab((BHxView)entryReaderFE, displayName, entryReadersOp);
        BHxAccessZoneExitReaderJoinFE exitReaderFE = BHxAccessZoneExitReaderJoinFE.INSTANCE;
        target = new OrdTarget((OrdTarget)op, (BObject)BExitReaderZoneJoin.ORION_TYPE.getOrionTypeId());
        HxOp exitReadersOp = op.make("exitReaders", target);
        exitReadersOp.mergeFacets(BHxSmartTableView.finishLater);
        displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BExitReaderZoneJoin.TYPE, BAccReaderRec.TYPE, op);
        Tab exitReaderTab = new Tab((BHxView)exitReaderFE, displayName, exitReadersOp);
        if (local) {
            BHxJoinFE occupantsFE = BHxJoinFE.INSTANCE;
            target = new OrdTarget((OrdTarget)op, (BObject)BPersonZoneJoin.ORION_TYPE.getOrionTypeId());
            HxOp occupantsOp = op.make("occupants", target);
            occupantsOp.mergeFacets(BHxSmartTableView.finishLater);
            displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BPersonZoneJoin.TYPE, BPerson.TYPE, op);
            Tab occupantTab = new Tab((BHxView)occupantsFE, displayName, occupantsOp);
            a.add((Object)occupantTab);
            if (rec.getAccessZoneTypeSpec().equals((Object)BAccessZone.TYPE.getTypeSpec())) {
                BHxSupervisorJoinFE supervisorFE = BHxSupervisorJoinFE.INSTANCE;
                target = new OrdTarget((OrdTarget)op, (BObject)BSupervisorZoneJoin.ORION_TYPE.getOrionTypeId());
                HxOp supervisorsOp = op.make("supervisors", target);
                supervisorsOp.mergeFacets(BHxSmartTableView.finishLater);
                displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BSupervisorZoneJoin.TYPE, BPerson.TYPE, op);
                Tab supervisorTab = new Tab((BHxView)supervisorFE, displayName, supervisorsOp);
                a.add((Object)supervisorTab);
            }
            a.add((Object)entryReaderTab);
            a.add((Object)exitReaderTab);
        } else if (available) {
            BIOrionObject orionObject = (BIOrionObject)op.get();
            BFoxSession session = (BFoxSession)mappedComponent.getSession();
            BEnterpriseSecurityService remoteService = (BEnterpriseSecurityService)session.getService(BEnterpriseSecurityService.TYPE);
            remoteService.lease();
            BOrionObject remoteOrionObject = remoteService.remoteOrionRead((BOrionObject)orionObject);
            remoteOrionObject.setOrionDatabase(remoteService.getOrionDatabase());
            target = new OrdTarget((OrdTarget)op, (BObject)remoteOrionObject);
            HxOp remoteOp = op.make("remoteOrionObject", target);
            BHxJoinFE occupantsFE = BHxJoinFE.INSTANCE;
            target = new OrdTarget((OrdTarget)remoteOp, (BObject)BPersonZoneJoin.ORION_TYPE.getOrionTypeId());
            HxOp occupantsOp = remoteOp.make("occupants", target);
            occupantsOp.mergeFacets(BHxSmartTableView.finishLater);
            displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BPersonZoneJoin.TYPE, BPerson.TYPE, op);
            Tab occupantTab = new Tab((BHxView)occupantsFE, displayName, occupantsOp);
            BHxSupervisorJoinFE supervisorFE = BHxSupervisorJoinFE.INSTANCE;
            target = new OrdTarget((OrdTarget)remoteOp, (BObject)BSupervisorZoneJoin.ORION_TYPE.getOrionTypeId());
            HxOp supervisorsOp = remoteOp.make("supervisors", target);
            supervisorsOp.mergeFacets(BHxSmartTableView.finishLater);
            displayName = BHxOrionSummary.getRelationshipDisplayName(BAccessZoneRec.TYPE, BSupervisorZoneJoin.TYPE, BPerson.TYPE, op);
            Tab supervisorTab = new Tab((BHxView)supervisorFE, displayName, supervisorsOp);
            a.add((Object)occupantTab);
            a.add((Object)supervisorTab);
            if (available && !localStationIsSupervisor) {
                a.add((Object)entryReaderTab);
                a.add((Object)exitReaderTab);
            }
        }
        if (local && available && rec.getAccessZoneTypeSpec().equals((Object)BAccessZone.TYPE.getTypeSpec())) {
            HxOp localOp = op.make("station", (BObject)Sys.getStation(), null);
            HxOp mappedOp = localOp.make("mapped", (BObject)mappedComponent, null);
            BLinkTemplate linkTemplate = new BLinkTemplate(BNiagaraStation.TYPE, (Slot)BNiagaraStation.status, (Slot)BAccessZone.groupStatus);
            Tab groupingTab = new Tab((BHxView)BHxAccessZoneGroupingFE.INSTANCE, lex.getText("grouping"), mappedOp.make("grouping", (BObject)linkTemplate, null), mappedOp);
            a.add((Object)groupingTab);
        }
        return (Tab[])a.trim();
    }
}

