/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class ManageAccessPointCommand
extends ManageDevicesCommand {
    public ManageAccessPointCommand(BHxView view) {
        super(view);
    }

    @Override
    public String getName(HxOp op) {
        if (!this.inNetwork(BAccessNetwork.TYPE, op)) {
            return "nrio16.manageExtensionsCommand";
        }
        return super.getName(op);
    }

    @Override
    public String getDevicesTypeName(HxOp op) {
        if (!this.inNetwork(BAccessNetwork.TYPE, op)) {
            return Lexicon.make(((Object)((Object)this)).getClass()).getText("nrio16.manageExtensionsCommand.extensions");
        }
        return super.getDevicesTypeName(op);
    }

    @Override
    public String getDeviceTypeName(HxOp op) {
        if (!this.inNetwork(BAccessNetwork.TYPE, op)) {
            return Lexicon.make(((Object)((Object)this)).getClass()).getText("nrio16.manageExtensionsCommand.extension");
        }
        return super.getDeviceTypeName(op);
    }

    @Override
    public void added(BValue added, HxOp op) throws Exception {
        if (added instanceof BAlarmSourceExt) {
            this.setAlarmExtAlgorithms((BAlarmSourceExt)added, op);
        }
        super.added(added, op);
    }

    private void setAlarmExtAlgorithms(BAlarmSourceExt alarmSourceExt, HxOp op) {
        if (alarmSourceExt instanceof BAccessAlarmSourceExt) {
            return;
        }
        if (alarmSourceExt.getParentPoint().getType().is(BBooleanPoint.TYPE)) {
            if (alarmSourceExt.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
                alarmSourceExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
            }
        } else if (alarmSourceExt.getParentPoint().getType().is(BNumericPoint.TYPE) && alarmSourceExt.getOffnormalAlgorithm().getType().equals(BOffnormalAlgorithm.TYPE)) {
            alarmSourceExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BOutOfRangeAlgorithm());
        }
    }

    @Override
    public String[] getDevices(BTypeSpec parentTypeSpec, HxOp op) {
        if (this.inNetwork(BAccessNetwork.TYPE, op)) {
            return new String[]{"accessDriver:AccessAlarmRelay", "accessDriver:AccessAlarmSourceExt"};
        }
        if (op.get().getType().is(BNumericPoint.TYPE)) {
            return new String[]{"alarm:AlarmSourceExt", "history:NumericIntervalHistoryExt", "history:NumericCovHistoryExt"};
        }
        if (op.get().getType().is(BBooleanPoint.TYPE)) {
            return new String[]{"alarm:AlarmSourceExt", "history:BooleanIntervalHistoryExt", "history:BooleanCovHistoryExt"};
        }
        return new String[]{"alarm:AlarmSourceExt"};
    }

    private boolean inNetwork(Type networkType, HxOp op) {
        BComplex p = op.get().asComplex();
        while (!p.getType().is(networkType)) {
            if ((p = p.getParent()) != null) continue;
            return false;
        }
        return true;
    }
}

