/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsec.securityUtil.ui.link.BLinkTemplate;
import com.tridiumx.entsecHx.access.managers.BHxManageAlarmExtGrouping;
import com.tridiumx.entsecHx.access.managers.BHxManageHistoryExtGrouping;
import com.tridiumx.entsecHx.access.managers.ManageAccessPointCommand;
import com.tridiumx.entsecHx.access.managers.NumericManualOverride;
import com.tridiumx.entsecHx.nrio.commands.ModuleHyperlinkCommand;
import com.tridiumx.entsecHx.nrio.device.BHxNrioNumericKnobFE;
import com.tridiumx.entsecHx.nrio.device.commands.ResetTotalCommand;
import com.tridiumx.entsecHx.nrio.device.commands.SetTotalCommand;
import com.tridiumx.entsecHx.nrio.util.INrioPointCategories;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxKnobFE;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxLinkFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDeviceGrouping;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"control:NumericPoint", "control:NumericWritable"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxNumericPointView
extends BHxManageDevicesView
implements INrioPointCategories {
    public static final BHxNumericPointView INSTANCE = new BHxNumericPointView();
    public static final Type TYPE = Sys.loadType(BHxNumericPointView.class);
    SmartCommand manageAccessPoint = new ManageAccessPointCommand((BHxView)this);
    SmartCommand pointManagerLevel;
    SmartCommand manualOverride;
    SmartCommand setTotalCommand;
    SmartCommand resetTotalCommand;
    SmartCommand moduleHyperlinkCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxNumericPointView() {
        this.registerEvent((Event)this.manageAccessPoint);
        this.pointManagerLevel = new UpLevelCommand.GenericLevelCommand((BHxView)this, BPointDeviceExt.TYPE);
        this.registerEvent((Event)this.pointManagerLevel);
        this.manualOverride = new NumericManualOverride((BHxView)this);
        this.registerEvent((Event)this.manualOverride);
        this.setTotalCommand = new SetTotalCommand((BHxView)this);
        this.registerEvent((Event)this.setTotalCommand);
        this.resetTotalCommand = new ResetTotalCommand((BHxView)this);
        this.registerEvent((Event)this.resetTotalCommand);
        this.moduleHyperlinkCommand = new ModuleHyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.moduleHyperlinkCommand);
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab tab = super.getPropertyTab(op);
        if (this.inNetwork(BNrioNetwork.TYPE, op) && !this.inNetwork(BAccessNetwork.TYPE, op)) {
            tab.title = this.getNrioPointTabTitle(op);
        }
        return tab;
    }

    @Override
    public String[] getProperties(HxOp op) {
        if (!this.inNetwork(BAccessNetwork.TYPE, op)) {
            return new String[0];
        }
        return super.getProperties(op);
    }

    private String getNrioPointTabTitle(HxOp op) {
        BControlPoint point = (BControlPoint)op.getComponent();
        BNrio16ProxyExt ext = (BNrio16ProxyExt)point.getProxyExt();
        Type type = ext.getType();
        String title = null;
        if (type.is(BNrioVoltageInputProxyExt.TYPE)) {
            title = "voltageInput";
        } else if (type.is(BNrioResistiveInputProxyExt.TYPE)) {
            BUnit units;
            UnitDatabase.Quantity quantity;
            UnitDatabase db = UnitDatabase.getDefault();
            BFacets pointFacets = ext.getPointFacets();
            title = pointFacets.get("units") != null ? ((quantity = db.getQuantity(units = (BUnit)pointFacets.get("units"))).getName().equals("electric resistance") ? "resistiveInput" : "temperatureInput") : "unknownType";
        } else if (type.is(BNrioCounterInputProxyExt.TYPE)) {
            title = "highSpeedCounter";
        } else if (type.is(BNrioVoltageOutputProxyExt.TYPE)) {
            title = "voltageOutput";
        }
        return TextUtil.toFriendly((String)title);
    }

    @Override
    public BHxManageDeviceGrouping getGroupingView(BTypeSpec typeSpec, HxOp op) throws Exception {
        if (typeSpec.getResolvedType().is(BAlarmSourceExt.TYPE)) {
            return BHxManageAlarmExtGrouping.INSTANCE;
        }
        if (typeSpec.getResolvedType().is(BHistoryExt.TYPE)) {
            return BHxManageHistoryExtGrouping.INSTANCE;
        }
        return super.getGroupingView(typeSpec, op);
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        BComponent point = op.getComponent();
        if (op.getRequest().getSession().getAttribute("facets" + point.getHandleOrd()) == null) {
            op.getRequest().getSession().setAttribute("facets" + point.getHandleOrd(), (Object)((BControlPoint)point).getFacets());
        }
        Array tabs = new Array(Tab.class);
        tabs.addAll((Object[])super.getTabs(op));
        if (!this.inNetwork(BAccessNetwork.TYPE, op)) {
            Tab knobsTabNp = new Tab((BHxView)(this.inNetwork(BNrioNetwork.TYPE, op) ? BHxNrioNumericKnobFE.INSTANCE : BHxKnobFE.INSTANCE), this.getLexicon().getText("knobsTabTitle"), op.make("knobs", (BObject)new BLinkTemplate(BNumericWritable.TYPE, (Slot)BNumericPoint.out, (Slot)BNumericWritable.in16), null), op);
            Tab knobsTabNw = new Tab((BHxView)(this.inNetwork(BNrioNetwork.TYPE, op) ? BHxNrioNumericKnobFE.INSTANCE : BHxKnobFE.INSTANCE), this.getLexicon().getText("knobsTabTitle"), op.make("knobs", (BObject)new BLinkTemplate(BNumericWritable.TYPE, (Slot)BNumericWritable.out, (Slot)BNumericWritable.in16), null), op);
            tabs.add((Object)(point.getType().is(BNumericWritable.TYPE) ? knobsTabNw : knobsTabNp));
            Tab linksTab = new Tab((BHxView)BHxLinkFE.INSTANCE, this.getLexicon().getText("linksTabTitle"), op.make("links", (BObject)new BLinkTemplate(BNumericPoint.TYPE, (Slot)BNumericPoint.out, (Slot)BNumericWritable.in16), null), op);
            if (point.getType().is(BNumericWritable.TYPE)) {
                tabs.add((Object)linksTab);
            }
        }
        return (Tab[])tabs.trim();
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        super.write(op);
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (this.inNetwork(BAccessNetwork.TYPE, op)) {
            return new SmartCommand[]{this.save, this.manageAccessPoint, this.upLevel};
        }
        if (op.getComponent().getType().is(BNumericWritable.TYPE)) {
            if (this.inNetwork(BNrioNetwork.TYPE, op)) {
                return new SmartCommand[]{this.save, this.manageAccessPoint, this.pointManagerLevel, this.manualOverride, this.moduleHyperlinkCommand};
            }
            return new SmartCommand[]{this.save, this.manageAccessPoint, this.manualOverride};
        }
        if (this.inNetwork(BNrioNetwork.TYPE, op)) {
            BControlPoint point = (BControlPoint)op.getComponent();
            if (point.getProxyExt().getType().is(BNrioCounterInputProxyExt.TYPE)) {
                return new SmartCommand[]{this.save, this.manageAccessPoint, this.pointManagerLevel, this.setTotalCommand, this.resetTotalCommand, this.moduleHyperlinkCommand};
            }
            return new SmartCommand[]{this.save, this.manageAccessPoint, this.pointManagerLevel, this.moduleHyperlinkCommand};
        }
        return new SmartCommand[]{this.save, this.manageAccessPoint};
    }

    @Override
    public String[] getDevices(HxOp op) {
        if (this.inNetwork(BAccessNetwork.TYPE, op)) {
            return new String[]{"accessDriver:AccessAlarmRelay", "accessDriver:AccessAlarmSourceExt"};
        }
        return new String[]{"alarm:AlarmSourceExt", "history:HistoryExt"};
    }

    private boolean inNetwork(Type networkType, HxOp op) {
        BComplex p = op.get().asComplex();
        while (!p.getType().is(networkType)) {
            if ((p = p.getParent()) != null) continue;
            return false;
        }
        return true;
    }
}

