/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.managers;

import com.tridium.nrio.BNrioDevice;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BBurglarPanel;
import com.tridiumx.entsecHx.access.managers.BHxReaderPointsHyperlinks;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDeviceHyperlinks;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.license.LicenseManager;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessInputOutputModule", "accessDriver:Base2ReaderModule", "accessDriver:Remote2ReaderModule"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAccessDeviceView
extends BHxManageDevicesView {
    public static final BHxAccessDeviceView INSTANCE = new BHxAccessDeviceView();
    public static final Type TYPE = Sys.loadType(BHxAccessDeviceView.class);
    SmartCommand accessDeviceManageDevicesCommand = new AccessDeviceManageDevicesCommand((BHxView)this);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAccessDeviceView() {
        this.registerEvent((Event)this.accessDeviceManageDevicesCommand);
    }

    @Override
    public BComponent getContainer(OrdTarget target) {
        BNrioDevice c = (BNrioDevice)super.getContainer(target);
        return (BComponent)c.get("points");
    }

    @Override
    public BHxManageDeviceHyperlinks getHyperlinkView(BTypeSpec typeSpec, HxOp op) throws Exception {
        if (typeSpec.getResolvedType().is(BBooleanPoint.TYPE)) {
            return BHxReaderPointsHyperlinks.INSTANCE;
        }
        return super.getHyperlinkView(typeSpec, op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i) instanceof ManageDevicesCommand)) continue;
            a.set(i, (Object)this.accessDeviceManageDevicesCommand);
        }
        return (SmartCommand[])a.trim();
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Object[] tabs = super.getTabs(op);
        Array tabsToRemove = new Array(Tab.class);
        for (int i = 0; i < tabs.length; ++i) {
            Tab tab = tabs[i];
            if (tab.title.equals("Boolean Points")) {
                tab.title = "Additional Points";
                continue;
            }
            if (tab.title.equals("Elevators") && !this.elevatorsLicensed()) {
                tabsToRemove.add((Object)tab);
                continue;
            }
            if (!tab.title.equals("Burglar Panels") || this.intrusionLicensed()) continue;
            tabsToRemove.add((Object)tab);
        }
        Array tabArray = new Array(tabs);
        ListIterator iterator = tabsToRemove.iterator();
        while (iterator.hasNext()) {
            tabArray.remove(iterator.next());
        }
        return (Tab[])tabArray.trim();
    }

    private boolean elevatorsLicensed() {
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            if (service.getUnlicensedVisibility()) {
                return true;
            }
            LicenseManager manager = Sys.getLicenseManager();
            manager.checkFeature("tridium", "accessControl");
            return manager.getFeature("tridium", "accessControl").get("elevator.limit") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean intrusionLicensed() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "intrusion");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        super.write(op);
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    public class AccessDeviceManageDevicesCommand
    extends ManageDevicesCommand {
        public AccessDeviceManageDevicesCommand(BHxView view) {
            super(view);
        }

        @Override
        public void checkAdd(BValue value, HxOp op) {
            if (value.getType().is(BBurglarPanel.TYPE)) {
                try {
                    Sys.getLicenseManager().checkFeature("tridium", "intrusion");
                }
                catch (Exception ex) {
                    Logger.getLogger("entsecHx").severe("Feature \"intrusion\" is not licensed");
                    throw new IllegalStateException("Feature \"intrusion\" is not licensed");
                }
            }
        }

        @Override
        public String getPasteWarningFromCut(BComplex complex, HxOp op) {
            BAccessReader reader;
            if (complex instanceof BAccessReader && (reader = (BAccessReader)complex).isValidationReader()) {
                return this.lexModule.getText("confirmValidationToGeneral", (Context)op, new Object[]{complex.asComponent().toDisplayPathString((Context)op)});
            }
            return null;
        }
    }
}

