/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.maintenance;

import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.ExportCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PersonnelExportCommand
extends SmartCommand {
    public static final String PBKDF_2_WITH_HMAC_SHA_1 = "PBKDF2WithHmacSHA1";
    public static final int ITERATIONS = 65536;
    public static final int KEY_SIZE = 32;
    private static BFacets portraitRangeFacets = BFacets.make((String)"lexicon", (String)Sys.getModuleForClass(PersonnelExportCommand.class).getModuleName());
    private static BEnumRange portraitRange = BEnumRange.make(null, (int[])new int[]{0, 1, 2}, (String[])new String[]{"noPortraits", "fileNamesOnly", "files"}, (int)3, (BFacets)portraitRangeFacets);
    private static final String HEADER = "LastName,FirstName,MiddleInitial,PinNumber,Tenant,PersonType,Supervisor,Department,EmployeeId,TraceCard";
    private PersonnelExportCommandDialog dialog = new PersonnelExportCommandDialog(Lexicon.make((String)"entsecHx").getText("personnelExport.title"), (Command)this);
    private int symmetricKeyIterationCount = 65536;
    private int keySize = 256;
    private static final String UTF_8 = "UTF-8";
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";

    public PersonnelExportCommand(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "jaceMaintenance.export";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HxOp op) throws Exception {
        block13: {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BOrd ord = op.getOrd();
            String fileName = op.getFormValue("fileName").trim();
            String userPassKey = op.getFormValue("userPassKey").trim();
            if (fileName.length() == 0) {
                throw new IllegalStateException(this.lexModule.getText("additionalPersonnelEntry.invalidFileName.message", (Context)op));
            }
            if (userPassKey.length() == 0) {
                throw new IllegalStateException(this.lexModule.getText("additionalPersonnelEntry.invalidUserPassKeyError.message", (Context)op));
            }
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            OrionSession session = null;
            try {
                session = service.createSession((Context)op);
                int portraitOrdinal = 0;
                if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                    BEnum portraitOptions = (BEnum)this.getPortraitTab(op).save();
                    portraitOrdinal = portraitOptions.getOrdinal();
                }
                if (portraitOrdinal == 0 || portraitOrdinal == 1) {
                    boolean includePortraitNames = portraitOrdinal == 1;
                    BExportFileWrapper wrapper = ExportCommand.makeExportFileWrapper((String)(fileName + ".csv"));
                    OutputStream outputStream = wrapper.getOutputStream();
                    this.writeCsv(fileName, userPassKey, includePortraitNames, outputStream, session, op);
                    wrapper.closeOutput();
                    ExportCommand.redirectToWrapper((BExportFileWrapper)wrapper, (boolean)false, (HxOp)op);
                    break block13;
                }
                boolean includePortraitNames = true;
                BExportFileWrapper wrapper = ExportCommand.makeExportFileWrapper((String)(fileName + ".zip"));
                ZipOutputStream zipOutDownload = new ZipOutputStream(wrapper.getOutputStream());
                zipOutDownload.setMethod(8);
                zipOutDownload.setLevel(9);
                BPersonPortrait.leaveFiles = true;
                try {
                    zipOutDownload.putNextEntry(new ZipEntry(fileName + ".csv"));
                    BUuid[] portraits = this.writeCsv(fileName, userPassKey, includePortraitNames, zipOutDownload, session, op);
                    zipOutDownload.closeEntry();
                    for (int i = 0; i < portraits.length; ++i) {
                        BUuid uuid = portraits[i];
                        BPersonPortrait personPortrait = (BPersonPortrait)session.read(BPersonPortrait.ORION_TYPE, (BSimple)uuid);
                        zipOutDownload.putNextEntry(new ZipEntry("portraits/" + personPortrait.getFileName()));
                        zipOutDownload.write(personPortrait.getImage().copyBytes());
                        zipOutDownload.closeEntry();
                    }
                    zipOutDownload.finish();
                    zipOutDownload.close();
                    wrapper.getOutputStream().flush();
                    wrapper.closeOutput();
                    ExportCommand.redirectToWrapper((BExportFileWrapper)wrapper, (boolean)false, (HxOp)op);
                }
                finally {
                    BPersonPortrait.leaveFiles = false;
                    BPersonPortrait.ensureNextDelete = true;
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BUuid[] writeCsv(String fileName, String userPassKey, boolean portraitInfo, OutputStream outputStream, OrionSession session, HxOp op) throws Exception {
        PrintWriter out = new PrintWriter(outputStream);
        try {
            BUuid[] bUuidArray = this.writeCsv(userPassKey, portraitInfo, out, session, op);
            return bUuidArray;
        }
        finally {
            out.flush();
        }
    }

    private BUuid[] writeCsv(String userPassKey, boolean portraitInfo, PrintWriter out, OrionSession session, HxOp op) {
        out.print(HEADER);
        BPerson[] persons = this.getPersons(session);
        persons = (BPerson[])Arrays.stream(EntsecTenantUtil.filter((BIOrionObject[])persons, (Context)op)).filter(child -> child instanceof BPerson).map(person -> (BPerson)person).toArray(BPerson[]::new);
        op.getRequest().getSession().setAttribute("showAssignedThreatLevelColumn", null);
        int maxBadges = this.getMaxBadges(persons, session);
        for (int i = 0; i < maxBadges; ++i) {
            out.print(",WiegandFormat" + i + ",Credential" + i + ",FacilityCode" + i + ",BadgeStatus" + i + ",BadgeDescription" + i + ",IssueDate" + i + ",ExpirationDate" + i);
        }
        int maxAccessRights = this.getMaxNumAccessRights(persons, session, op);
        boolean showAssignedThreatLevelColumn = op.getRequest().getSession().getAttribute("showAssignedThreatLevelColumn") != null;
        for (int i = 0; i < maxAccessRights; ++i) {
            out.print(",AccessRight" + i + ",StartDate" + i + ",EndDate" + i);
            if (!showAssignedThreatLevelColumn) continue;
            out.print(",AssignedThreatLevel" + i);
        }
        BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates((OrionSession)session);
        for (int i = 0; i < infoTemplates.length; ++i) {
            out.print(",info" + infoTemplates[i].getInfoTemplateId());
        }
        if (portraitInfo) {
            out.print(",Portrait");
        }
        return this.processPersons(persons, userPassKey, maxAccessRights, infoTemplates, portraitInfo, maxBadges, showAssignedThreatLevelColumn, out, session, op);
    }

    private int getMaxBadges(BPerson[] persons, OrionSession session) {
        int maxBadges = 0;
        for (int i = 0; i < persons.length; ++i) {
            BBadge[] badges = this.getBadges(session, persons[i]);
            if (badges.length <= maxBadges) continue;
            maxBadges = badges.length;
        }
        return maxBadges;
    }

    private int getMaxNumAccessRights(BPerson[] persons, OrionSession session, HxOp op) {
        boolean showAssignedThreatLevelColumn = false;
        int maxAccessRights = 0;
        for (int i = 0; i < persons.length; ++i) {
            BPersonAccJoin[] personAccessRightJoins = PersonnelExportCommand.getPersonAccessRightJoins(persons[i], session);
            for (int j = 0; j < personAccessRightJoins.length; ++j) {
                if (personAccessRightJoins[j].getAssignedThreatLevel().getOrdinal() <= -1) continue;
                showAssignedThreatLevelColumn = true;
            }
            if (personAccessRightJoins.length <= maxAccessRights) continue;
            maxAccessRights = personAccessRightJoins.length;
        }
        if (showAssignedThreatLevelColumn) {
            op.getRequest().getSession().setAttribute("showAssignedThreatLevelColumn", (Object)"true");
        }
        return maxAccessRights;
    }

    private static BPersonAccJoin[] getPersonAccessRightJoins(BPerson person, OrionSession session) {
        return (BPersonAccJoin[])EntsecTenantUtil.select((OrionType)BPersonAccJoin.ORION_TYPE, (PropertyValue)new PropertyValue(BPersonAccJoin.person, (BValue)BRef.make((BIOrionObject)person)), (OrionSession)session).toArray();
    }

    private BUuid[] processPersons(BPerson[] persons, String userPassKey, int maxAccessRights, BInfoTemplate[] infoTemplates, boolean portraitInfo, int maxBadges, boolean showAssignedThreatLevelColumn, PrintWriter out, OrionSession session, HxOp op) {
        Array portraits = new Array(BUuid.class);
        SecretKey secretKey = null;
        byte[] randomByteArray = null;
        try {
            randomByteArray = this.generateSalt();
            secretKey = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(new PBEKeySpec(userPassKey.toCharArray(), new String(randomByteArray).getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
        }
        catch (Exception e) {
            Logger.getLogger("entsecHx").log(Level.SEVERE, "Failed to generate secret key", e);
        }
        AesSysKeyEncoder aesSysKeyEncoder = new AesSysKeyEncoder(secretKey);
        for (int i = 0; i < persons.length; ++i) {
            try {
                out.print('\n');
                out.print(this.removeCommas(persons[i].getLastName()));
                out.print("," + this.removeCommas(persons[i].getFirstName()));
                out.print("," + this.removeCommas(persons[i].getMiddleInitial()));
                if (persons[i].getPinNumber().getPasswordEncoder().isReversible() && persons[i].isPinNumberInteger()) {
                    out.print("," + ByteArrayUtil.toHexString((byte[])randomByteArray) + ":" + persons[i].encryptPinNumber(aesSysKeyEncoder));
                } else {
                    out.print(",");
                }
                BTenant tenant = persons[i].resolveTenant(session);
                if (tenant != null) {
                    out.print("," + this.removeCommas(tenant.getTenantName()));
                } else {
                    out.print(",");
                }
                out.print("," + this.removeCommas(persons[i].getPersonType()));
                out.print("," + persons[i].getSupervisor());
                out.print("," + this.removeCommas(persons[i].getDepartment()));
                out.print("," + this.removeCommas(persons[i].getEmployeeId()));
                out.print("," + persons[i].getTraceCard());
                BBadge[] badges = this.getBadges(session, persons[i]);
                badges = (BBadge[])Arrays.stream(EntsecTenantUtil.filter((BIOrionObject[])badges, (Context)op)).filter(child -> child instanceof BBadge).map(badge -> (BBadge)badge).toArray(BBadge[]::new);
                for (int j = 0; j < maxBadges; ++j) {
                    if (j < badges.length) {
                        out.print("," + badges[j].resolveWiegandFormat(session).getWiegandFormatName());
                        out.print("," + badges[j].getCredential());
                        out.print("," + badges[j].getFacilityCode());
                        out.print("," + badges[j].getStatus().getTag());
                        out.print("," + badges[j].getBDescription());
                        if (!badges[j].getIssueDate().equals((Object)BAbsTime.DEFAULT)) {
                            out.print("," + badges[j].getIssueDate().encodeToString());
                        } else {
                            out.print(",");
                        }
                        if (!badges[j].getExpirationDate().equals((Object)BAbsTime.DEFAULT)) {
                            out.print("," + badges[j].getExpirationDate().encodeToString());
                            continue;
                        }
                        out.print(",");
                        continue;
                    }
                    out.print(",");
                    out.print(",");
                    out.print(",");
                    out.print(",");
                    out.print(",");
                    out.print(",");
                    out.print(",");
                }
                String emptyAccessRight = ",,,";
                if (showAssignedThreatLevelColumn) {
                    emptyAccessRight = ",,,,";
                }
                BPersonAccJoin[] joins = PersonnelExportCommand.getPersonAccessRightJoins(persons[i], session);
                for (int j = 0; j < maxAccessRights; ++j) {
                    if (j < joins.length) {
                        BAccessRight accessRight = joins[j].resolveAccessRight(session);
                        if (EntsecTenantUtil.isMissingTenant((BComponent)accessRight, (Context)op)) {
                            out.print(emptyAccessRight);
                            continue;
                        }
                        String accessRightName = accessRight.getAccessRightName();
                        String startDateString = "";
                        String endDateString = "";
                        BAbsTime startDate = joins[j].getStartDate();
                        BAbsTime endDate = joins[j].getEndDate();
                        if (!startDate.equals((Object)BAbsTime.DEFAULT)) {
                            startDateString = startDate.encodeToString();
                        }
                        if (!endDate.equals((Object)BAbsTime.DEFAULT)) {
                            endDateString = endDate.encodeToString();
                        }
                        out.print("," + this.removeCommas(accessRightName) + "," + startDateString + "," + endDateString);
                        if (!showAssignedThreatLevelColumn) continue;
                        BThreatLevelEntry entry = joins[j].getAssignedThreatLevel();
                        if (entry.getOrdinal() > -1) {
                            out.print("," + entry.getOrdinal());
                            continue;
                        }
                        out.print(",");
                        continue;
                    }
                    out.print(emptyAccessRight);
                }
                BPersonInfo personInfo = persons[i].getPersonInfo(session);
                for (int j = 0; j < infoTemplates.length; ++j) {
                    BInfoTemplate infoTemplate = infoTemplates[j];
                    String value = infoTemplate.getDefaultValue();
                    int id = infoTemplate.getInfoTemplateId();
                    if (personInfo != null) {
                        value = personInfo.getValue(infoTemplate);
                    }
                    out.print("," + this.removeCommas(value));
                }
                if (!portraitInfo) continue;
                out.print(",");
                BPersonPortrait personPortrait = persons[i].getPersonPortrait(session);
                if (personPortrait == null) continue;
                BUuid uuid = personPortrait.getImageId();
                portraits.add((Object)uuid);
                out.print(this.removeCommas(personPortrait.getFileName()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (BUuid[])portraits.trim();
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private BPerson[] getPersons(OrionSession session) {
        return (BPerson[])EntsecTenantUtil.select((OrionType)BPerson.ORION_TYPE, (OrionSession)session).toArray();
    }

    private BBadge[] getBadges(OrionSession session, BPerson person) {
        return (BBadge[])EntsecTenantUtil.select((OrionType)BBadge.ORION_TYPE, (PropertyValue)new PropertyValue(BBadge.owner, (BValue)BRef.make((BIOrionObject)person)), (OrionSession)session).toArray();
    }

    private String removeCommas(String str) {
        if (str == null) {
            return str;
        }
        return TextUtil.replace((String)str, (String)",", (String)"<comma>");
    }

    private Tab getPortraitTab(HxOp op) {
        HxOp tabOp = op.make("portraitOptions", (BObject)BDynamicEnum.make((int)0, (BEnumRange)portraitRange), null);
        tabOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
        return new Tab((BHxView)BHxEnumFE.INSTANCE, Lexicon.make((String)"entsecHx", (Context)op).getText("portraitOptions"), tabOp, op);
    }

    private byte[] generateSalt() throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return bytes;
    }

    class PersonnelExportCommandDialog
    extends Dialog {
        public PersonnelExportCommandDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((String)Lexicon.make((String)"entsecHx", (Context)op).getText("personnelExport.fileName"), (HtmlWriter)out, (HxOp)op);
            out.w((Object)"<input type='text'");
            out.w((Object)"value='personnelBackup_");
            out.w((Object)Sys.getStation().getStationName()).w((Object)"_");
            out.w((Object)BAbsTime.now().toDateString((Context)op));
            out.w((Object)"' name='fileName' style='width: 300px'/>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            if (BEnterpriseSecurityService.isPhotoIDAvailable((Context)op)) {
                Tab portraitTab = PersonnelExportCommand.this.getPortraitTab(op);
                HxTabUtil.startRow((String)portraitTab.title, (HtmlWriter)out, (HxOp)op);
                portraitTab.write();
                HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            }
            HxTabUtil.startRow((String)"User Pass Key", (HtmlWriter)out, (HxOp)op);
            out.w((Object)"<input type='password'");
            out.w((Object)"' name='userPassKey' style='width: 300px'/>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }
    }
}

