/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.maintenance;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.access.maintenance.BAdditionalPersonnelComponent;
import com.tridiumx.entsecHx.access.maintenance.BBatchPersonnelEntryJob;
import com.tridiumx.entsecHx.access.maintenance.BHxMaintenanceView;
import com.tridiumx.entsecHx.access.maintenance.PersonnelExportCommand;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxFileImportFE;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:AdditionalPersonnelEntry"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxAdditionalPersonnelEntry
extends BHxAbstractJobView {
    public static final BHxAdditionalPersonnelEntry INSTANCE = new BHxAdditionalPersonnelEntry();
    public static final Type TYPE = Sys.loadType(BHxAdditionalPersonnelEntry.class);
    protected PersonnelExportCommand personnelExport = new PersonnelExportCommand((BHxView)this);
    static final Lexicon lex = Lexicon.make(BHxMaintenanceView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAdditionalPersonnelEntry() {
        this.registerEvent((Event)this.personnelExport);
    }

    @Override
    public void write(HxOp op) throws Exception {
        if (RemoteUtil.isSubordinate()) {
            op.setReadonly(true);
        }
        super.write(op);
    }

    @Override
    public boolean needsFileSubmit(HxOp op) {
        return true;
    }

    public String getPageTitle(HxOp op) throws Exception {
        return HxTabUtil.getLexicon(BHxAdditionalPersonnelEntry.class, (Context)op).getText("jaceMaintenance.additionalUserEntry");
    }

    @Override
    public String getJobTitle() {
        return HxTabUtil.getLexicon(BHxAdditionalPersonnelEntry.class, null).getText("jaceMaintenance.additionalUserEntry");
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array((Object[])super.getButtonCommands(op));
        arr.add((Object)this.personnelExport);
        return (SmartCommand[])arr.trim();
    }

    @Override
    public FilePath getFilePath(BComponent c, Property p, HxOp op) {
        String filePath = op.getFormValue("db.tab.File.fileName");
        if (filePath != null && filePath.indexOf(".") > -1) {
            int index = filePath.lastIndexOf(".");
            String suffix = filePath.substring(index);
            return new FilePath("^temp/" + p.getName() + suffix);
        }
        return new FilePath("^temp/" + p.getName());
    }

    public BJob submitJob(HxProgressJobDialog hxprogressjobdialog, HxOp op) {
        log.fine("submit job");
        BComponent c = this.getSavedComponent(op);
        String s = SlotPath.escape((String)BTenant.TYPE.getDisplayName((Context)op));
        BRef tenantRef = (BRef)c.get(s);
        s = SlotPath.escape((String)BWiegandFormat.TYPE.getDisplayName((Context)op));
        BRef wiegandFormatRef = (BRef)c.get(s);
        s = SlotPath.escape((String)lex.getText("file"));
        BOrd bord = (BOrd)c.get(s);
        BIFile bifile = (BIFile)bord.get();
        String userKey = SlotPath.escape((String)lex.getText("userPassKey"));
        BPassword passKey = (BPassword)c.get(userKey);
        if (passKey.validate("")) {
            throw new IllegalStateException(lex.getText("additionalPersonnelEntry.invalidUserPassKeyError.message"));
        }
        BBatchPersonnelEntryJob job = new BBatchPersonnelEntryJob(bifile, AccessController.doPrivileged(() -> ((BPassword)passKey).getValue()), tenantRef, wiegandFormatRef, op);
        BJobService service = (BJobService)Sys.getService((Type)BJobService.TYPE);
        BOrd jobOrd = service.submit((BJob)job, (Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    @Override
    public Tab getTab(HxOp op) {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        BOrionDatabase db = service.getOrionDatabase();
        HxOp dbOp = op.make("db", (BObject)db, null);
        BAdditionalPersonnelComponent c = new BAdditionalPersonnelComponent();
        String s = SlotPath.escape((String)BTenant.TYPE.getDisplayName((Context)op));
        c.add(s, (BValue)BRef.make((BTypeSpec)BTenant.ORION_TYPE.getTypeSpec()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
        s = SlotPath.escape((String)BWiegandFormat.TYPE.getDisplayName((Context)op));
        c.add(s, (BValue)BRef.make((BTypeSpec)BWiegandFormat.ORION_TYPE.getTypeSpec()));
        s = SlotPath.escape((String)lex.getText("userPassKey"));
        c.add(s, (BValue)BPassword.DEFAULT, (Context)BFacets.make((String)"fieldWidth", (BIDataValue)BPassword.DEFAULT.toDataValue()));
        s = SlotPath.escape((String)lex.getText("file"));
        BFacets facets = BFacets.make((String)"fieldEditor", (String)"entsecHx:HxFileImportFE");
        facets = BFacets.make((BFacets)facets, (BFacets)BHxFileImportFE.makeExtFacet(new String[]{"csv", "zip"}));
        c.add(s, (BValue)BOrd.DEFAULT, 0, facets, null);
        return new BHxTabbedView.PropertyTab((BHxTabbedView)this, (BHxView)BHxFieldSheet.INSTANCE, lex.getText("jaceMaintenance.additionalUserEntry.info"), dbOp.make("tab", (BObject)c, null), op);
    }
}

