/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.history;

import com.tridium.hx.ErrorDialog;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.sys.Nre;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BAttendanceRecord;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsecHx.access.history.BHxAttendanceOrionHistoryView;
import com.tridiumx.entsecHx.securityUtilHx.orion.BHxLocalHistoryTableView;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:AttendanceHistoryConsolidator", "entsec:AttendanceHistoryQuery"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAttendanceHistoryTableView
extends BHxLocalHistoryTableView {
    public static final BHxAttendanceHistoryTableView INSTANCE = new BHxAttendanceHistoryTableView();
    public static final Type TYPE = Sys.loadType(BHxAttendanceHistoryTableView.class);
    SmartCommand addManual = new AddManualCommand((BHxView)this);
    SmartCommand hideManual;
    static final BHistoryId attendanceHistoryId = BHistoryId.make((String)"^", (String)"AttendanceRecord");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAttendanceHistoryTableView() {
        this.registerEvent((Event)this.addManual);
        this.hideManual = new HideManualCommand((BHxView)this);
        this.registerEvent((Event)this.hideManual);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        SmartCommand[] commands = super.getButtonCommands(op);
        if (!BHxAttendanceHistoryTableView.getSecurityHistoryConsolidator(op).getPermissions((Context)op).hasAdminWrite()) {
            return commands;
        }
        int len = commands != null ? commands.length : 0;
        SmartCommand[] newCommands = new SmartCommand[len + 2];
        System.arraycopy(commands, 0, newCommands, 2, len);
        newCommands[0] = this.addManual;
        newCommands[1] = this.hideManual;
        return newCommands;
    }

    class HideManualCommand
    extends SmartCommand {
        private ConfirmDialog dlg;

        public HideManualCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(BHxAttendanceHistoryTableView.class);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "hideManualAttendanceRec";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(this.lexModule.getText("hideAttendanceConfirmation", (Context)op), op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BIHistory history = null;
            for (int i = 0; i < selectionList.length; ++i) {
                BAttendanceRecord rec = (BAttendanceRecord)BActivityRecord.decodeSourceRecord((String)selectionList[i]);
                if (!rec.getManualEntry() || rec.getHidden()) continue;
                rec.setHidden(true);
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase db = service.getDatabase();
                try (HistorySpaceConnection conn = db.getConnection(null);){
                    if (history == null) {
                        BHistoryId id = BHxAttendanceOrionHistoryView.attendanceHistoryId.fromShorthand(Sys.getStation().getStationName());
                        history = conn.getHistory(id);
                    }
                    conn.update(history, (BHistoryRecord)rec);
                    continue;
                }
            }
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class AddManualCommand
    extends SmartCommand {
        AddManualDialog dialog;

        public AddManualCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(BHxAttendanceOrionHistoryView.class);
            this.dialog = new AddManualDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "addManualAttendanceRec";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            if (this.dialog.isSubmit(op)) {
                BAttendanceRecord rec = new BAttendanceRecord();
                rec.setManualEntry(true);
                BComponent saved = (BComponent)this.getTab(op).save();
                BAbsTime time = (BAbsTime)saved.get(SlotPath.escape((String)BAttendanceRecord.activityTimestamp.getDefaultDisplayName((Context)op)));
                BBoolean b = (BBoolean)op.getFacet("showMilliseconds");
                boolean showMillis = b != null ? b.getBoolean() : false;
                b = (BBoolean)op.getFacet("showSeconds");
                boolean showSeconds = b != null ? b.getBoolean() : false;
                int millis = showMillis ? time.getMillisecond() : 0;
                int seconds = showSeconds ? time.getSecond() : 0;
                time = BAbsTime.make((int)time.getYear(), (BMonth)time.getMonth(), (int)time.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)seconds, (int)millis, (BTimeZone)time.getTimeZone());
                rec.setActivityTimestamp(time);
                BTimeAttendEnum activity = (BTimeAttendEnum)saved.get(SlotPath.escape((String)BAttendanceRecord.activity.getDefaultDisplayName((Context)op)));
                rec.setActivity(activity);
                BRef ref = (BRef)saved.get(SlotPath.escape((String)BAttendanceRecord.owner.getDefaultDisplayName((Context)op)));
                BAccessControlService aService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                OrionSession session = null;
                try {
                    session = aService.createSession((Context)op);
                    BPerson o = (BPerson)ref.getTarget(session);
                    if (o == null) {
                        new ErrorDialog("Error", (Command)this, (Throwable)new Exception("Cannot Add Attendance, Please Select an Owner...")).open(op);
                        return;
                    }
                    rec.setOwner(o.toDisplayString((Context)op));
                    rec.setTimestamp(BAbsTime.now());
                    rec.setPersonId(o.getPersonId());
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
                aService.getHistoryManager().append((BHistoryRecord)rec);
                BHistoryId id = attendanceHistoryId.fromShorthand(Sys.getStation().getStationName());
                Auditor auditor = Nre.auditor;
                if (auditor != null) {
                    StringBuffer summary = new StringBuffer();
                    summary.append(rec.getOwner()).append(" ").append(rec.getActivity().toString((Context)op));
                    auditor.audit(new AuditEvent("Added", "history:" + id.encodeToString(), "Manual Add " + rec.getActivityTimestamp().toString((Context)BHistoryRecord.TIMESTAMP_FACETS), "", summary.toString(), op.getUser().getUsername()));
                }
                ((BHxSmartTableView)this.getView()).reloadTable(op);
                return;
            }
            this.dialog.open(op);
        }

        public Tab getTab(HxOp op) {
            BComponent c = new BComponent();
            String propName = SlotPath.escape((String)BAttendanceRecord.activityTimestamp.getDefaultDisplayName((Context)op));
            c.add(propName, (BValue)BAbsTime.now());
            propName = SlotPath.escape((String)BAttendanceRecord.activity.getDefaultDisplayName((Context)op));
            c.add(propName, (BValue)BTimeAttendEnum.clockIn);
            BFacets facets = BFacets.make((String)"fieldEditor", (String)"entsecHx:HxSmartRefFE");
            facets = BFacets.make((BFacets)facets, (BFacets)BHxSmartTableView.makeHeightFacets((int)300));
            facets = BFacets.make((BFacets)facets, (String)"allowNull", (BIDataValue)BBoolean.TRUE);
            propName = SlotPath.escape((String)BAttendanceRecord.owner.getDefaultDisplayName((Context)op));
            c.add(propName, (BValue)BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec()), 0, facets, null);
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            BOrionDatabase db = service.getOrionDatabase();
            HxOp dbOp = op.make("db", (BObject)db, null);
            return new Tab((BHxView)BHxFieldSheet.INSTANCE, dbOp.make("tab", (BObject)c, null));
        }

        public boolean process(HxOp op) throws Exception {
            if (super.process(op)) {
                return true;
            }
            return this.getTab(op).process();
        }

        class AddManualDialog
        extends Dialog {
            public AddManualDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                AddManualCommand.this.getTab(op).write();
            }
        }
    }
}

