/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.fieldeditors;

import com.tridium.nrio.conv.BNrioShunt500OhmConversion;
import com.tridium.nrio.conv.BNrioTabularThermistorConversion;
import com.tridium.nrio.conv.BNrioThermistorType3Conversion;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.conv.BLinearConversion;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"driver:ProxyConversion", "nrio:NrioProxyConversionFE"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxProxyConversionFE
extends BHxFieldEditor {
    public static final BHxProxyConversionFE INSTANCE = new BHxProxyConversionFE();
    public static final Type TYPE = Sys.loadType(BHxProxyConversionFE.class);
    private static String DEFAULT_CONVERSION = BDefaultProxyConversion.TYPE.getTypeName();
    private static String REVERSE_POLARITY = BReversePolarityConversion.TYPE.getTypeName();
    private static String LINEAR_CONVERSION = BLinearConversion.TYPE.getTypeName();
    private static String SHUNT_500_OHM_CONVERSION = BNrioShunt500OhmConversion.TYPE.getTypeName();
    private static String TABULAR_THERMISTOR_CONVERSION = BNrioTabularThermistorConversion.TYPE.getTypeName();
    private static String THERMISTOR_TYPE3_CONVERSION = BNrioThermistorType3Conversion.TYPE.getTypeName();
    private static final int SOURCE_FIELD_WIDTH = 8;
    private static final int RESULT_FIELD_WIDTH = 8;
    Command tableEditorCmd = new TableEditorCommand((BHxView)this);
    Command decrementPointCountCmd;
    SmartCommand deleteAllEntriesCmd;
    SmartCommand addEntryCmd;

    public Type getType() {
        return TYPE;
    }

    protected BHxProxyConversionFE() {
        this.registerEvent((Event)this.tableEditorCmd);
        this.decrementPointCountCmd = new DecrementPointCountCommand((BHxView)this);
        this.registerEvent((Event)this.decrementPointCountCmd);
        this.deleteAllEntriesCmd = new DeleteAllCommand((BHxView)this);
        this.registerEvent((Event)this.deleteAllEntriesCmd);
        this.addEntryCmd = new AddEntryCommand((BHxView)this);
        this.registerEvent((Event)this.addEntryCmd);
    }

    public void write(HxOp op) throws Exception {
        Lexicon lex = Lexicon.make(((Object)((Object)this)).getClass());
        BProxyConversion conversion = (BProxyConversion)op.get();
        HtmlWriter out = op.getHtmlWriter();
        if (this.isAccessProxyExtension(op)) {
            boolean reverse = false;
            if (conversion instanceof BReversePolarityConversion) {
                reverse = true;
            }
            out.w((Object)"<select ");
            if (!op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.attr(" name", op.scope("value"));
            out.w((Object)">");
            out.w((Object)"<option value='open'");
            if (!reverse) {
                out.attr("selected", "selected");
            }
            out.w((Object)">").safe((Object)lex.getText("open")).w((Object)"</option>");
            out.w((Object)"<option value='closed'");
            if (reverse) {
                out.attr("selected", "selected");
            }
            out.w((Object)">").safe((Object)lex.getText("closed")).w((Object)"</option>");
            out.w((Object)"</select>");
        } else if (this.isNrio16ProxyExtension(op)) {
            this.writeNrio16ProxyConversions(op);
        }
    }

    public BObject save(HxOp op) throws Exception {
        String conversion = op.getFormValue("value");
        if (this.isAccessProxyExtension(op)) {
            if (conversion.equals("open")) {
                return BDefaultProxyConversion.DEFAULT;
            }
            return BReversePolarityConversion.DEFAULT;
        }
        if (this.isNrio16ProxyExtension(op)) {
            if (conversion.equals(DEFAULT_CONVERSION)) {
                return BDefaultProxyConversion.DEFAULT;
            }
            if (conversion.equals(LINEAR_CONVERSION) || conversion.equals(SHUNT_500_OHM_CONVERSION)) {
                double scale = Double.parseDouble(op.getFormValue("linearScale"));
                double offset = Double.parseDouble(op.getFormValue("linearOffset"));
                BLinearConversion linearConversion = BLinearConversion.make((double)scale, (double)offset);
                if (conversion.equals(SHUNT_500_OHM_CONVERSION)) {
                    return BNrioShunt500OhmConversion.make((BProxyConversion)linearConversion);
                }
                return linearConversion;
            }
            if (conversion.equals(REVERSE_POLARITY)) {
                return BReversePolarityConversion.DEFAULT;
            }
            if (conversion.equals(THERMISTOR_TYPE3_CONVERSION)) {
                return BNrioThermistorType3Conversion.DEFAULT;
            }
            if (conversion.equals(TABULAR_THERMISTOR_CONVERSION)) {
                BNrioTabularThermistorConversion tabularThermistorConversion = (BNrioTabularThermistorConversion)op.getRequest().getSession().getAttribute(this.thermistorConversionAttribute(op));
                if (tabularThermistorConversion == null) {
                    BObject object = op.get();
                    tabularThermistorConversion = object.getType().is(BNrioTabularThermistorConversion.TYPE) ? (BNrioTabularThermistorConversion)op.get() : BNrioTabularThermistorConversion.DEFAULT;
                }
                return tabularThermistorConversion.newCopy(true);
            }
        }
        return BDefaultProxyConversion.DEFAULT;
    }

    private String thermistorConversionAttribute(HxOp op) {
        return SmartCommand.universalScope((String)"thermistorConversion", (HxOp)op);
    }

    private String pointCountAttribute(HxOp op) {
        return SmartCommand.universalScope((String)"pointCount", (HxOp)op);
    }

    private void writeNrio16ProxyConversions(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BProxyConversion conversion = (BProxyConversion)op.get();
        out.w((Object)"<select ");
        if (!op.canWrite()) {
            out.attr("disabled", "disabled");
        }
        out.attr("id", "value");
        out.attr("name", op.scope("value"));
        out.attr("onchange", this.getOnChangeHandler(op));
        out.w((Object)">");
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BProxyConversion.TYPE.getTypeInfo());
        for (int i = 0; i < types.length; ++i) {
            out.w((Object)"<option ");
            out.attr("value", types[i].getTypeName());
            if (conversion.getType().is(types[i].getTypeSpec().getResolvedType())) {
                out.attr("selected", "selected");
            }
            out.w((Object)">");
            out.safe((Object)types[i].getDisplayName((Context)op));
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"&nbsp;");
        boolean linearOrShunt = conversion.getType().is(BLinearConversion.TYPE) || conversion.getType().is(BNrioShunt500OhmConversion.TYPE);
        out.w((Object)"<span ");
        out.attr("id", "config");
        out.attr("display", linearOrShunt ? "style='inline;'" : "style='none;'");
        out.w((Object)">");
        if (linearOrShunt) {
            String scale = "'1.0'";
            String offset = "'0.0'";
            BProxyConversion conv = (BProxyConversion)op.get();
            if (conv.getType().is(BLinearConversion.TYPE)) {
                BLinearConversion linearConversion = (BLinearConversion)conv;
                scale = String.valueOf(linearConversion.getScale());
                offset = String.valueOf(linearConversion.getOffset());
            } else if (conv.getType().is(BNrioShunt500OhmConversion.TYPE)) {
                BNrioShunt500OhmConversion shuntConversion = (BNrioShunt500OhmConversion)conv;
                BLinearConversion linearConversion = (BLinearConversion)shuntConversion.getSubConversion();
                scale = String.valueOf(linearConversion.getScale());
                offset = String.valueOf(linearConversion.getOffset());
            }
            String scopedScale = op.scope("linearScale");
            String scopedOffset = op.scope("linearOffset");
            out.w((Object)"Scale:&nbsp;");
            out.w((Object)"<input type='text' name='").w((Object)scopedScale).w((Object)"' value='").w((Object)scale).w((Object)"' />&nbsp;");
            out.w((Object)"Offset:&nbsp;");
            out.w((Object)"<input type='text' name='").w((Object)scopedOffset).w((Object)"' value='").w((Object)offset).w((Object)"' />");
        } else if (conversion.getType().is(BNrioTabularThermistorConversion.TYPE)) {
            op.getRequest().getSession().removeAttribute(this.pointCountAttribute(op));
            op.getRequest().getSession().removeAttribute(this.thermistorConversionAttribute(op));
            out.w((Object)("<script>" + this.writeTableEditor(op) + "</script>"));
        }
        out.w((Object)"</span>");
    }

    private boolean isAccessProxyExtension(HxOp op) {
        if (!(op.get() instanceof BProxyConversion)) {
            return false;
        }
        BProxyExt ext = (BProxyExt)op.getBaseOrdTarget().getBaseOrdTarget().get();
        return ext.getType().is(BAccessProxyExt.TYPE);
    }

    private boolean isNrio16ProxyExtension(HxOp op) {
        if (!(op.get() instanceof BProxyConversion)) {
            return false;
        }
        BProxyExt ext = (BProxyExt)op.getBaseOrdTarget().getBaseOrdTarget().get();
        return ext.getType().is(BNrio16ProxyExt.TYPE);
    }

    private String getOnChangeHandler(HxOp op) throws Exception {
        StringBuffer onchange = new StringBuffer();
        onchange.append(this.clearConfigSpan(op));
        onchange.append("var selection = document.getElementById('value').value;");
        onchange.append("if(selection == '" + LINEAR_CONVERSION + "' || selection == '" + SHUNT_500_OHM_CONVERSION + "')");
        onchange.append("{");
        onchange.append(this.writeLinearFields(op));
        onchange.append("}");
        onchange.append("else if(selection == '" + TABULAR_THERMISTOR_CONVERSION + "')");
        onchange.append("{");
        onchange.append(this.writeTableEditor(op));
        onchange.append("}");
        onchange.append("else config.style.display='none';");
        return onchange.toString();
    }

    private String clearConfigSpan(HxOp op) {
        StringBuffer clear = new StringBuffer();
        clear.append("var span = document.getElementById('config');");
        clear.append("while(span.hasChildNodes()){span.removeChild(span.firstChild);}");
        return clear.toString();
    }

    private String writeLinearFields(HxOp op) {
        String scale = "'1.0'";
        String offset = "'0.0'";
        BProxyConversion conversion = (BProxyConversion)op.get();
        if (conversion.getType().is(BLinearConversion.TYPE)) {
            BLinearConversion linearConversion = (BLinearConversion)conversion;
            scale = "'" + String.valueOf(linearConversion.getScale()) + "'";
            offset = "'" + String.valueOf(linearConversion.getOffset()) + "'";
        } else if (conversion.getType().is(BNrioShunt500OhmConversion.TYPE)) {
            BNrioShunt500OhmConversion shuntConversion = (BNrioShunt500OhmConversion)conversion;
            BLinearConversion linearConversion = (BLinearConversion)shuntConversion.getSubConversion();
            scale = "'" + String.valueOf(linearConversion.getScale()) + "'";
            offset = "'" + String.valueOf(linearConversion.getOffset()) + "'";
        }
        String scopedScale = "'" + op.scope("linearScale") + "'";
        String scopedOffset = "'" + op.scope("linearOffset") + "'";
        StringBuffer script = new StringBuffer();
        script.append("var config = document.getElementById('config');");
        script.append("config.style.display='inline';");
        script.append("config.appendChild(document.createTextNode('Scale:'));");
        script.append("var scaleTxtField = document.createElement('input');");
        script.append("scaleTxtField.type = 'text';");
        script.append("scaleTxtField.name = " + scopedScale + ";");
        script.append("scaleTxtField.value = " + scale + ";");
        script.append("config.appendChild(scaleTxtField);");
        script.append("config.appendChild(document.createTextNode('Offset:'));");
        script.append("var offsetTxtField = document.createElement('input');");
        script.append("offsetTxtField.type = 'text';");
        script.append("offsetTxtField.name = " + scopedOffset + ";");
        script.append("offsetTxtField.value = " + offset + ";");
        script.append("config.appendChild(offsetTxtField);");
        return script.toString();
    }

    private String writeTableEditor(HxOp op) throws Exception {
        BIcon editIcon = BIcon.std((String)"edit.png");
        String iconOrd = "'ord?" + editIcon.getOrdList().get(0) + "'";
        StringBuffer script = new StringBuffer();
        script.append("var config = document.getElementById('config');");
        script.append("config.style.display='inline';");
        script.append("var tableCommand = document.createElement('img');");
        script.append("tableCommand.src = " + iconOrd + ";");
        script.append("tableCommand.style.cursor = 'pointer';");
        script.append("tableCommand.onclick = function(){" + this.tableEditorCmd.getInvokeCode(op) + "};");
        script.append("config.appendChild(tableCommand);");
        return script.toString();
    }

    private class DecrementPointCountCommand
    extends Command {
        public DecrementPointCountCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            int pointCount = ((BInteger)op.getRequest().getSession().getAttribute(BHxProxyConversionFE.this.pointCountAttribute(op))).getInt();
            op.getRequest().getSession().setAttribute(BHxProxyConversionFE.this.pointCountAttribute(op), (Object)BInteger.make((int)(--pointCount)));
        }
    }

    private class DeleteAllCommand
    extends SmartCommand {
        public DeleteAllCommand(BHxView view) {
            super(view);
            view.registerEvent((Event)this);
        }

        public String getName(HxOp op) {
            return "thermistorTableEditor.deleteAll";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            op.getRequest().getSession().setAttribute(BHxProxyConversionFE.this.pointCountAttribute(op), (Object)BInteger.make((int)0));
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var table = document.getElementById('entryTable');");
            out.w((Object)"while(table.rows.length > 1)");
            out.w((Object)"table.deleteRow(table.rows.length-1);");
        }
    }

    private class AddEntryCommand
    extends SmartCommand {
        public AddEntryCommand(BHxView view) {
            super(view);
            view.registerEvent((Event)this);
        }

        public String getName(HxOp op) {
            return "thermistorTableEditor.addEntry";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            int pointCount = ((BInteger)op.getRequest().getSession().getAttribute(BHxProxyConversionFE.this.pointCountAttribute(op))).getInt();
            HtmlWriter out = op.getHtmlWriter();
            String sourceFieldName = "'" + op.scope("source" + pointCount) + "'";
            out.w((Object)"var sourceTxtField   = document.createElement('input');");
            out.w((Object)"sourceTxtField.type  = 'text';");
            out.w((Object)("sourceTxtField.name  = " + sourceFieldName + ";"));
            out.w((Object)"sourceTxtField.size  = '8';");
            out.w((Object)"sourceTxtField.value = '0.0';");
            String resultFieldName = "'" + op.scope("result" + pointCount) + "'";
            out.w((Object)"var resultTxtField   = document.createElement('input');");
            out.w((Object)"resultTxtField.type  = 'text';");
            out.w((Object)("resultTxtField.name  = " + resultFieldName + ";"));
            out.w((Object)"resultTxtField.size  = '8';");
            out.w((Object)"resultTxtField.value = '0.0';");
            out.w((Object)"var deleteBtn = document.createElement('img');");
            out.w((Object)("deleteBtn.id = 'deleteEntry" + pointCount + "';"));
            out.w((Object)("deleteBtn.src = '" + HxUtil.encodeURLForHref((String)op.toUri(BIcon.std((String)"delete.png").getOrdList().get(0))) + "';"));
            String quote = HxUtil.getInnerQuote((HxOp)op);
            String invokeCode = AddEntryCommand.getInvokeCode((Command)BHxProxyConversionFE.this.decrementPointCountCmd, (String)quote, (HxOp)op);
            out.w((Object)("deleteBtn.onclick = function(){" + this.deleteEntryHandler() + invokeCode + "};"));
            out.w((Object)"deleteBtn.style.cursor = 'pointer';");
            out.w((Object)"var sourceCell = document.createElement('td');");
            out.w((Object)"var resultCell = document.createElement('td');");
            out.w((Object)"var deleteBtnCell = document.createElement('td');");
            out.w((Object)"sourceCell.align = 'center';");
            out.w((Object)"resultCell.align = 'center';");
            out.w((Object)"deleteBtnCell.align = 'center';");
            out.w((Object)"sourceCell.appendChild(sourceTxtField);");
            out.w((Object)"resultCell.appendChild(resultTxtField);");
            out.w((Object)"deleteBtnCell.appendChild(deleteBtn);");
            out.w((Object)"var newRow = document.createElement('tr');");
            out.w((Object)"newRow.appendChild(sourceCell); newRow.appendChild(resultCell);newRow.appendChild(deleteBtnCell);");
            out.w((Object)"var tableBody = document.getElementById('entryTableBody');");
            out.w((Object)"tableBody.appendChild(newRow);");
            op.getRequest().getSession().setAttribute(BHxProxyConversionFE.this.pointCountAttribute(op), (Object)BInteger.make((int)(++pointCount)));
            super.handle(op);
        }

        private String deleteEntryHandler() {
            StringBuffer script = new StringBuffer();
            script.append("var row = this.parentNode.parentNode;");
            script.append("var rowIndex = row.rowIndex;");
            script.append("var table = document.getElementById('entryTable');");
            script.append("table.deleteRow(rowIndex);");
            return script.toString();
        }
    }

    private class TabularDialog
    extends Dialog {
        public TabularDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            this.writeDescription(op);
            this.writeTable(op);
            this.writeCommands(op);
            super.writeContent(op);
        }

        private BNrioTabularThermistorConversion getCurrentThermistorConversion(HxOp op) {
            BNrioTabularThermistorConversion conversion = null;
            conversion = (BNrioTabularThermistorConversion)op.getRequest().getSession().getAttribute(BHxProxyConversionFE.this.thermistorConversionAttribute(op));
            if (conversion == null) {
                BObject object = op.get();
                conversion = object.getType().is(BNrioTabularThermistorConversion.TYPE) ? (BNrioTabularThermistorConversion)op.get() : BNrioTabularThermistorConversion.DEFAULT;
            }
            if (conversion == null) {
                conversion = BNrioTabularThermistorConversion.DEFAULT;
            }
            return conversion;
        }

        private void writeDescription(HxOp op) throws Exception {
            BNrioTabularThermistorConversion conversion = this.getCurrentThermistorConversion(op);
            String description = conversion.getDescription();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<b>").safe(BHxProxyConversionFE.this.getLexicon().getText("thermistorTableEditor.description"), false).w((Object)"</b>&nbsp;&nbsp;");
            out.w((Object)"<input type='text' name='").w((Object)op.scope("description")).w((Object)"' value='").safe(description, false).w((Object)"' />");
        }

        private void writeTable(HxOp op) throws Exception {
            BNrioTabularThermistorConversion conversion = this.getCurrentThermistorConversion(op);
            Array points = conversion.getPoints();
            op.getRequest().getSession().setAttribute(BHxProxyConversionFE.this.pointCountAttribute(op), (Object)BInteger.make((int)points.size()));
            HtmlWriter out = op.getHtmlWriter();
            HxTabUtil.getSpacerDiv((HxOp)op);
            out.w((Object)"<table id='entryTable' align='center'>");
            out.w((Object)"<tbody id='entryTableBody'>");
            out.w((Object)"<tr>");
            out.w((Object)"<th style='font-size:12px; font-family:Arial;'>").safe(BHxProxyConversionFE.this.getLexicon().getText("thermistorTableEditor.xColumn.title"), false).w((Object)"</th>");
            out.w((Object)"<th style='font-size:12px; font-family:Arial;'>").safe(BHxProxyConversionFE.this.getLexicon().getText("thermistorTableEditor.yColumn.title"), false).w((Object)"</th>");
            out.w((Object)"<th>&nbsp;<th>");
            out.w((Object)"</tr>");
            for (int i = 0; i < points.size(); ++i) {
                this.writeXYPoint(i, (BNrioTabularThermistorConversion.XYPoint)points.get(i), op);
            }
            out.w((Object)"</tbody>");
            out.w((Object)"</table>");
        }

        private void writeXYPoint(int index, BNrioTabularThermistorConversion.XYPoint point, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String xValue = String.valueOf(point.x());
            String yValue = String.valueOf(point.y());
            out.w((Object)"<tr>");
            out.w((Object)"<td align='center'>");
            out.w((Object)"<input ");
            out.attr("type", "text");
            out.attr("name", op.scope("source" + index));
            out.attr("size", 8);
            out.attr("value", xValue);
            out.w((Object)" />");
            out.w((Object)"</td>");
            out.w((Object)"<td align='center'>");
            out.w((Object)"<input ");
            out.attr("type", "text");
            out.attr("name", op.scope("result" + index));
            out.attr("size", 8);
            out.attr("value", yValue);
            out.w((Object)" />");
            out.w((Object)"</td>");
            out.w((Object)"<td align='center'>");
            this.writeDeleteCommand(index, op);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
        }

        private void writeDeleteCommand(int index, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<img ");
            out.attr("id", "deleteEntry" + index);
            out.attr("src", (Object)BIcon.std((String)"delete.png").getOrdList().get(0));
            out.attr("style", "cursor:pointer;");
            String quote = HxUtil.getInnerQuote((HxOp)op);
            String invokeCode = SmartCommand.getInvokeCode((Command)BHxProxyConversionFE.this.decrementPointCountCmd, (String)quote, (HxOp)op);
            out.attr("onclick", this.deleteEntryHandler() + invokeCode);
            out.w((Object)" />");
        }

        private String deleteEntryHandler() {
            StringBuffer script = new StringBuffer();
            script.append("var row = this.parentNode.parentNode;");
            script.append("var rowIndex = row.rowIndex;");
            script.append("var table = document.getElementById('entryTable');");
            script.append("table.deleteRow(rowIndex);");
            return script.toString();
        }

        private void writeCommands(HxOp op) throws Exception {
            HxTabUtil.getSpacerDiv((HxOp)op);
            SmartCommand[] commands = new SmartCommand[]{BHxProxyConversionFE.this.addEntryCmd, BHxProxyConversionFE.this.deleteAllEntriesCmd};
            HxTabUtil.writeCommands((SmartCommand[])commands, (boolean)true, (HxOp)op);
        }
    }

    private class TableEditorCommand
    extends Command {
        private TabularDialog dlg;

        public TableEditorCommand(BHxView view) {
            super(view);
            this.dlg = new TabularDialog(Lexicon.make((String)"entsecHx").getText("thermistorTableEditor.dialog.title"), this);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
            } else {
                BNrioTabularThermistorConversion tabularThermistorConversion = BNrioTabularThermistorConversion.make();
                String[] keys = op.getFormKeys();
                Array sourceArray = new Array(String.class);
                Array resultsArray = new Array(String.class);
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i].startsWith("source")) {
                        sourceArray.add((Object)keys[i]);
                        continue;
                    }
                    if (!keys[i].startsWith("result")) continue;
                    resultsArray.add((Object)keys[i]);
                }
                String[] sources = (String[])sourceArray.trim();
                String[] results = (String[])resultsArray.trim();
                Comparator<String> comparator = new Comparator<String>(){

                    @Override
                    public int compare(String str1, String str2) {
                        int index2;
                        int subIndex = str1.startsWith("source") ? "source".length() : "result".length();
                        int index1 = Integer.parseInt(str1.substring(subIndex));
                        return index1 - (index2 = Integer.parseInt(str2.substring(subIndex))) > 0 ? 1 : (index1 - index2 < 0 ? -1 : 0);
                    }
                };
                Arrays.sort(sources, comparator);
                Arrays.sort(results, comparator);
                for (int i = 0; i < sources.length; ++i) {
                    double sourceValue = Double.parseDouble(op.getFormValue(sources[i]));
                    double resultValue = Double.parseDouble(op.getFormValue(results[i]));
                    tabularThermistorConversion.add(sourceValue, resultValue);
                }
                tabularThermistorConversion.setDescription(op.getFormValue("description"));
                op.getRequest().getSession().setAttribute(BHxProxyConversionFE.this.thermistorConversionAttribute(op), (Object)tabularThermistorConversion);
                SaveCommand.setModified((HxOp)op);
            }
            super.handle(op);
        }
    }
}

