/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.fieldeditors;

import com.tridium.nrio.BNrioDevice;
import com.tridiumx.accessDriver.enums.BAccessIoTypeEnum;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import com.tridiumx.entsec.access.BAccessControlService;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessProxyExt"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxAccessProxyExtFE
extends BHxFieldEditor {
    public static final BHxAccessProxyExtFE INSTANCE = new BHxAccessProxyExtFE();
    public static final Type TYPE = Sys.loadType(BHxAccessProxyExtFE.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxAccessProxyExtFE() {
    }

    public void write(HxOp op) throws Exception {
        BAccessProxyExt proxyExt = (BAccessProxyExt)op.get();
        HtmlWriter out = op.getHtmlWriter();
        int instanceNo = -2;
        if (proxyExt.getEnabled()) {
            instanceNo = proxyExt.getInstance();
        }
        BNrioDevice module = (BNrioDevice)proxyExt.getDevice();
        BControlPoint controlPoint = (BControlPoint)proxyExt.getParent();
        BOrd[] iOords = null;
        BAccessIoTypeEnum ioTypeEnum = BAccessIoTypeEnum.supervisedDigitalInput;
        if (controlPoint instanceof BBooleanPoint && !controlPoint.isWritablePoint()) {
            if (proxyExt.getIsSdi()) {
                iOords = module.getUsedSdiArray();
                ioTypeEnum = BAccessIoTypeEnum.supervisedDigitalInput;
            }
            if (!proxyExt.getIsSdi()) {
                iOords = module.getUsedDiArray();
                ioTypeEnum = BAccessIoTypeEnum.digitalInput;
            }
        }
        if (controlPoint instanceof BBooleanWritable) {
            iOords = module.getUsedRelayArray();
            ioTypeEnum = BAccessIoTypeEnum.relayOutput;
        }
        boolean found = false;
        for (int i = 0; iOords != null && i < iOords.length; ++i) {
            String displayName = this.getDisplayName(ioTypeEnum, i + 1, op);
            if (iOords[i] == null) {
                if (!found) {
                    this.validOptionsHeader(op);
                    found = true;
                }
                out.w((Object)"<option value='").w(i + 1).w((Object)"'");
                if (i + 1 == instanceNo && proxyExt.getEnabled()) {
                    out.attr(" selected", "selected");
                }
                out.w((Object)">").safe((Object)displayName).w((Object)"</option>");
                continue;
            }
            if (!iOords[i].equals((Object)controlPoint.getSlotPathOrd())) continue;
            if (!found) {
                this.validOptionsHeader(op);
                found = true;
            }
            out.w((Object)"<option value='").w(i + 1).w((Object)"'");
            if (proxyExt.getEnabled()) {
                out.attr(" selected", "selected");
            }
            out.w((Object)">").safe((Object)displayName).w((Object)"</option>");
        }
        if (found) {
            out.w((Object)"</select>");
        } else {
            this.noOptionHeader(op);
        }
    }

    public void noOptionHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<select ");
        out.w((Object)" disabled='disabled'");
        out.w((Object)">");
        out.w((Object)"<option>").safe((Object)BAccessControlService.lex.getText("noneAvailable")).w((Object)"</option>");
        out.w((Object)"</select>");
    }

    public void validOptionsHeader(HxOp op) throws Exception {
        BAccessProxyExt proxyExt = (BAccessProxyExt)op.get();
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        out.w((Object)"<select ").attr("name", op.scope("value"));
        out.w((Object)" ").attr("id", op.scope("value"));
        if (readonly) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        out.w((Object)"<option value='none'>").safe((Object)BAccessControlService.lex.getText("none")).w((Object)"</option>");
    }

    public BObject save(HxOp op) throws Exception {
        BAccessProxyExt proxyExt = (BAccessProxyExt)op.get();
        String value = op.getFormValue("value");
        if (value == null) {
            return proxyExt;
        }
        if (value.equals("none")) {
            if (proxyExt.getEnabled()) {
                proxyExt.set(BAccessProxyExt.enabled, (BValue)BBoolean.FALSE, (Context)op);
            }
            return proxyExt;
        }
        BInteger iValue = BInteger.make((int)Integer.parseInt(value));
        if (!proxyExt.get(BAccessProxyExt.instance).equals((Object)value)) {
            proxyExt.set(BAccessProxyExt.instance, (BValue)iValue, (Context)op);
        }
        if (!proxyExt.getEnabled()) {
            proxyExt.set(BAccessProxyExt.enabled, (BValue)BBoolean.TRUE, (Context)op);
        }
        return proxyExt;
    }

    private String getDisplayName(BAccessIoTypeEnum ioTypeEnum, int id, HxOp op) {
        return ioTypeEnum.getDisplayTag((Context)op) + " " + id;
    }
}

