/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.bacnet;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.access.bacnet.BHxBacnetDoorControlSetup;
import com.tridiumx.entsecHx.access.bacnet.BHxBacnetIpPortSetup;
import com.tridiumx.entsecHx.access.bacnet.BHxBacnetMstpPortSetup;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetNetwork"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxBacnetSetupView
extends BHxManageDevicesView {
    public static Lexicon entsecLex = Lexicon.make(BEnterpriseSecurityService.class);
    public static Lexicon lex = Lexicon.make(BHxBacnetSetupView.class);
    public static final BHxBacnetSetupView INSTANCE = new BHxBacnetSetupView();
    public static final Type TYPE = Sys.loadType(BHxBacnetSetupView.class);
    private SmartCommand rebuildBacnetTable = new RebuildBacnetTable((BHxView)this);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxBacnetSetupView() {
        this.registerEvent((Event)this.rebuildBacnetTable);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save, this.rebuildBacnetTable};
    }

    public String getPageTitle(HxOp op) {
        return entsecLex.getText("nav.bacnet.setup");
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Slot slot;
        BBacnetNetwork bacnetNetwork = (BBacnetNetwork)op.get();
        BBacnetStack bacnetComm = (BBacnetStack)bacnetNetwork.getBacnetComm();
        BNetworkPort ipPort = bacnetComm.getNetwork().getIpPort();
        Object[] defaultTabs = super.getTabs(op);
        Array tabs = new Array(defaultTabs);
        Tab ipPortTab = new Tab((BHxView)BHxBacnetIpPortSetup.INSTANCE, lex.getText("hxBacnetSetupView.ipPort"), op.make("ipPort", (BObject)ipPort, null), op);
        tabs.add((Object)ipPortTab);
        try {
            Feature mstp = Sys.getLicenseManager().getFeature("tridium", "mstp");
            mstp.check();
            BNetworkPort mstpPort = null;
            BBacnetMstpLinkLayer layer = null;
            BBacnetStack stack = (BBacnetStack)bacnetNetwork.getBacnetComm();
            BNetworkPort[] ports = (BNetworkPort[])stack.getNetwork().getChildren(BNetworkPort.class);
            for (int i = 0; i < ports.length; ++i) {
                if (!(ports[i].getLink() instanceof BBacnetMstpLinkLayer)) continue;
                layer = (BBacnetMstpLinkLayer)ports[i].getLink();
                mstpPort = ports[i];
            }
            if (layer == null) {
                layer = new BBacnetMstpLinkLayer();
                mstpPort = new BNetworkPort();
                mstpPort.setLink((BBacnetLinkLayer)layer);
                stack.getNetwork().add("MstpPort", (BValue)mstpPort);
            }
            Tab mstpTab = new Tab((BHxView)BHxBacnetMstpPortSetup.INSTANCE, lex.getText("hxBacnetSetupView.mstp"), op.make("mstp", (BObject)mstpPort, null), op);
            tabs.add((Object)mstpTab);
        }
        catch (Exception mstp) {
            // empty catch block
        }
        Tab doorControlTab = null;
        BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        if (accessNetwork.getHasBacnetDoorControl()) {
            slot = accessNetwork.getSlot("bacnetDoorControl");
            int flags = accessNetwork.getFlags(slot) & 0xFFFFFFFB;
            accessNetwork.setFlags(slot, flags);
            doorControlTab = new Tab((BHxView)BHxBacnetDoorControlSetup.INSTANCE, lex.getText("hxBacnetSetupView.doorControl"), op.make("doorControl", (BObject)accessNetwork, null), op);
            tabs.add((Object)doorControlTab);
        } else {
            slot = accessNetwork.getSlot("bacnetDoorControl");
            int flags = accessNetwork.getFlags(slot) | 4;
            accessNetwork.setFlags(slot, flags);
        }
        return (Tab[])tabs.trim();
    }

    class RebuildBacnetTable
    extends SmartCommand {
        public RebuildBacnetTable(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "rebuildBacnetTable";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
            if (accessNetwork != null) {
                accessNetwork.rebuildBacnetTable();
            }
            new ErrorDialog.SuccessDialog(this.lexModule.getText("rebuildBacnetTableCompleteTitle", (Context)op), (Command)this, this.lexModule.getText("rebuildBacnetTableComplete", (Context)op), null).open(op);
        }
    }
}

