/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.web.WebUtil;
import com.tridiumx.entsec.nav.BEntsecNavContainer;
import com.tridiumx.entsec.nav.BEntsecNavNode;
import com.tridiumx.entsecHx.NavBar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.table.Table;
import javax.baja.hx.table.TableModel;
import javax.baja.hx.table.TableRenderer;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;

@NiagaraType(agent={@AgentOn(types={"entsec:EntsecNavContainer"}, requiredPermissions="r")})
@NiagaraSingleton
public class BEntsecNavView
extends BHxView {
    public static final BEntsecNavView INSTANCE = new BEntsecNavView();
    public static final Type TYPE = Sys.loadType(BEntsecNavView.class);
    public static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BEntsecNavView.class).getModuleName());
    protected SmartCommand showChildren = new ShowChildren(this);
    public static final String ENTSEC_NAV_SESSION_KEY = "entsecNavTree";

    public Type getType() {
        return TYPE;
    }

    protected BEntsecNavView() {
        this.registerEvent((Event)this.showChildren);
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div>");
        NavTable table = this.getTable(op);
        table.write(op);
        out.w((Object)"</div>");
    }

    public String getPageTitle(HxOp op) {
        BEntsecNavContainer nav = (BEntsecNavContainer)op.get();
        BINavNode parent = nav.getContainer();
        return parent.getNavDisplayName((Context)op);
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        NavTableModel model = (NavTableModel)this.getTable(op).getModel();
        int count = model.getRowCount();
        for (int i = 0; i < count; ++i) {
            BEntsecNavNode node = (BEntsecNavNode)model.getValueAt(0, i, 0, op);
            if (!node.isNavGroup() || !this.getTab(node, op).process()) continue;
            return true;
        }
        return false;
    }

    public NavTable getTable(HxOp op) {
        BEntsecNavContainer nav = (BEntsecNavContainer)op.get();
        BINavNode parent = nav.getContainer();
        int navLevel = 0;
        BINavNode n = parent;
        while (n != null) {
            n = n.getNavParent();
            ++navLevel;
        }
        NavTableModel tableModel = new NavTableModel(parent, navLevel, op);
        NavTable table = new NavTable(tableModel);
        table.setHeaderVisible(false);
        table.setRenderer(new NavTableRenderer());
        return table;
    }

    public void writeImageCommand(BOrd ord, HxOp op) throws Exception {
        SmartCommand command = this.showChildren;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ");
        out.attr("style", "cursor:pointer;");
        out.attr("id", op.scope(command.getName(op) + ord));
        out.attr("name", op.scope(command.getName(op) + ord));
        String displayName = command.getDisplayName(op);
        out.attr(" title", displayName);
        out.w((Object)" onclick='");
        out.w((Object)SmartCommand.getInvokeCodeForSetFormValue((String)op.scope("ord"), (Object)ord, (String)"&quot;", (boolean)true, (HxOp)op));
        out.w((Object)command.getInvokeCode(op)).w((Object)"'");
        String enablePolicyInvokeCode = command.getEnablePolicyInvokeCode(op);
        if (enablePolicyInvokeCode != null) {
            out.w((Object)" enablePolicy='").w((Object)enablePolicyInvokeCode).w((Object)"'");
        }
        out.w((Object)">");
        out.w((Object)"<span>");
        if (this.isExpanded(ord, op)) {
            HxUtil.makeImageJS((BImage)BImage.make((BIcon)BIcon.make((String)lex.get("showChildren.icon.selected"))), (HxOp)op);
        } else {
            HxUtil.makeImageJS((BImage)BImage.make((BIcon)BIcon.make((String)lex.get("showChildren.icon.unselected"))), (HxOp)op);
        }
        out.w((Object)"</span> ");
        out.w((Object)"</span>");
    }

    public boolean isExpanded(BOrd ord, HxOp op) {
        return this.getExpansionHash(op).get(ord) != null;
    }

    public void setExpanded(BOrd ord, HxOp op) {
        this.getExpansionHash(op).put(ord, BBoolean.TRUE);
    }

    public void setCollapsed(BOrd ord, HxOp op) {
        this.getExpansionHash(op).remove(ord);
    }

    public HashMap<BOrd, BBoolean> getExpansionHash(HxOp op) {
        HashMap map = (HashMap)op.getRequest().getSession().getAttribute(ENTSEC_NAV_SESSION_KEY);
        if (map == null) {
            map = new LinkedHashMap<BOrd, BBoolean>(256){

                @Override
                protected boolean removeEldestEntry(Map.Entry<BOrd, BBoolean> eldest) {
                    return this.size() > 500;
                }
            };
            op.getRequest().getSession().setAttribute(ENTSEC_NAV_SESSION_KEY, (Object)map);
        }
        return map;
    }

    public Tab getTab(Object o, HxOp op) {
        int depth = op.getFacets().geti("depth", 0);
        BEntsecNavContainer container = null;
        container = o instanceof BEntsecNavContainer ? (BEntsecNavContainer)o : new BEntsecNavContainer((BINavNode)o);
        HxOp subOp = op.make("sub", (BObject)container, BFacets.make((String)"depth", (BIDataValue)BInteger.make((int)(depth + 1))));
        return new Tab((BHxView)INSTANCE, subOp);
    }

    public class ShowChildren
    extends SmartCommand {
        public ShowChildren(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showChildren";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = BOrd.make((String)op.getFormValue("ord"));
            boolean expanded = BEntsecNavView.this.isExpanded(ord, op);
            if (expanded) {
                BEntsecNavView.this.setCollapsed(ord, op);
            } else {
                BEntsecNavView.this.setExpanded(ord, op);
            }
            BImage image = null;
            image = expanded ? BImage.make((BIcon)BIcon.make((String)this.lexModule.get("showChildren.icon.unselected", (Context)op))) : BImage.make((BIcon)BIcon.make((String)this.lexModule.get("showChildren.icon.selected", (Context)op)));
            this.updateImage(image, ord, op);
            HtmlWriter out = op.getHtmlWriter();
            if (expanded) {
                out.w((Object)("var elem = $$('" + op.scope("" + ord) + "'); elem.parentNode.style.display='none';"));
            } else {
                out.w((Object)("var elem = $$('" + op.scope("" + ord) + "'); elem.parentNode.style.display='';"));
                out.w((Object)"elem.innerHTML = \"");
                BEntsecNavView.this.getTab(ord.get(), op).write();
                out.w((Object)"\";");
            }
            HxUtil.addJavascriptOnload((HxOp)op);
        }

        public void updateImage(BImage image, BOrd ord, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"smartTable.$$('").safe((Object)op.scope(this.getLexName(op) + ord)).w((Object)"').getElementsByTagName('IMG')[0].src='");
            out.w((Object)WebUtil.toUri((OrdTarget)op, (HttpServletRequest)op.getRequest(), (BOrd)image.getOrdList().get(0))).w((Object)"';");
        }
    }

    public class NavTableRenderer
    extends TableRenderer {
        public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
            BINavNode node = (BINavNode)value;
            BOrd navOrd = node.getNavOrd();
            BIcon navIcon = BEntsecNavNode.getNavIcon((BINavNode)node, (Context)op);
            int navLevel = ((NavTableModel)this.getModel()).getNavLevel();
            BOrd ord = NavBar.getNavOrd(node, navLevel, (Context)op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr>");
            out.w((Object)"<td style='padding-right: 5px;'>");
            int depth = op.getFacets().geti("depth", 0);
            for (int i = 0; i < depth; ++i) {
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            BEntsecNavNode entsecNavNode = (BEntsecNavNode)node;
            if (entsecNavNode.isNavGroup()) {
                BEntsecNavView.this.writeImageCommand(navOrd, op);
            } else {
                out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            out.w((Object)"</td>");
            out.w((Object)"<td style='padding-right: 5px;'>");
            out.w((Object)"<a href='").w((Object)HxUtil.encodeURLForHref((String)ord.toString())).w((Object)"' style='text-decoration: none; color: black; cursor:pointer;'>");
            HxUtil.makeImageJS((BImage)BImage.make((BIcon)navIcon), (String)"class='nav-view-icon'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"</td>");
            out.w((Object)"<td class='nav-view-node-name'>");
            out.w((Object)"<a href='").w((Object)HxUtil.encodeURLForHref((String)ord.toString())).w((Object)"' style='text-decoration: none; color: black;'>");
            out.safe((Object)node.getNavDisplayName((Context)op));
            out.w((Object)"</a>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            String id = "" + navOrd;
            if (BEntsecNavView.this.isExpanded(navOrd, op)) {
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td ");
                HxTabUtil.scope((String)id, (HtmlWriter)out, (HxOp)op);
                out.w((Object)">");
                BEntsecNavView.this.getTab(node, op).write();
            } else {
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"<tr style='display:none;'>");
                out.w((Object)"<td ");
                HxTabUtil.scope((String)id, (HtmlWriter)out, (HxOp)op);
                out.w((Object)"> ");
            }
        }
    }

    private class NavTableModel
    extends TableModel {
        private BINavNode parent;
        private BINavNode[] children;
        private int navLevel;

        public NavTableModel(BINavNode parent, int navLevel, HxOp op) {
            this.parent = parent;
            this.children = this.filterChildren(parent, navLevel, op);
            this.navLevel = navLevel;
        }

        private BINavNode[] filterChildren(BINavNode parent, int navLevel, HxOp op) {
            BINavNode[] children = parent.getNavChildren();
            Array temp = new Array(BINavNode.class, children.length);
            for (int i = 0; i < children.length; ++i) {
                BOrd ord;
                if (!NavBar.include(children[i], (Context)op) || (ord = NavBar.getNavOrd(children[i], navLevel, (Context)op)) == null) continue;
                temp.add((Object)children[i]);
            }
            return (BINavNode[])temp.trim();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col, HxOp op) {
            return "Child";
        }

        public int getRowCount(int group) {
            return this.children.length;
        }

        public Object getValueAt(int group, int row, int column, HxOp op) {
            return this.children[row];
        }

        public int getNavLevel() {
            return this.navLevel;
        }
    }

    public class NavTable
    extends Table {
        public NavTable(TableModel model) {
            super(model);
        }

        public TableModel getModel() {
            return this.model;
        }
    }
}

