/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.MulticastUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationName", type="String", defaultValue="", flags=8), @NiagaraProperty(name="scheme", type="String", defaultValue="fox", flags=8), @NiagaraProperty(name="address", type="String", defaultValue="", flags=8), @NiagaraProperty(name="hostName", type="String", defaultValue=""), @NiagaraProperty(name="hostAddress", type="String", defaultValue=""), @NiagaraProperty(name="foxPort", type="int", defaultValue="0"), @NiagaraProperty(name="version", type="String", defaultValue="", flags=8), @NiagaraProperty(name="hostModel", type="String", defaultValue="", flags=8), @NiagaraProperty(name="hostModelVersion", type="String", defaultValue=""), @NiagaraProperty(name="hostId", type="String", defaultValue=""), @NiagaraProperty(name="vmName", type="String", defaultValue=""), @NiagaraProperty(name="vmVersion", type="String", defaultValue=""), @NiagaraProperty(name="osName", type="String", defaultValue=""), @NiagaraProperty(name="osVersion", type="String", defaultValue=""), @NiagaraProperty(name="niagaraPlatformType", type="String", defaultValue="", flags=4)})
public class BLearnStation
extends BStruct {
    @Generated
    public static final Property stationName = BLearnStation.newProperty((int)8, (String)"", null);
    @Generated
    public static final Property scheme = BLearnStation.newProperty((int)8, (String)"fox", null);
    @Generated
    public static final Property address = BLearnStation.newProperty((int)8, (String)"", null);
    @Generated
    public static final Property hostName = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property hostAddress = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property foxPort = BLearnStation.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property version = BLearnStation.newProperty((int)8, (String)"", null);
    @Generated
    public static final Property hostModel = BLearnStation.newProperty((int)8, (String)"", null);
    @Generated
    public static final Property hostModelVersion = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property hostId = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property vmName = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property vmVersion = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property osName = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property osVersion = BLearnStation.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property niagaraPlatformType = BLearnStation.newProperty((int)4, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLearnStation.class);
    private String key;

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public String getScheme() {
        return this.getString(scheme);
    }

    @Generated
    public void setScheme(String v) {
        this.setString(scheme, v, null);
    }

    @Generated
    public String getAddress() {
        return this.getString(address);
    }

    @Generated
    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    @Generated
    public String getHostName() {
        return this.getString(hostName);
    }

    @Generated
    public void setHostName(String v) {
        this.setString(hostName, v, null);
    }

    @Generated
    public String getHostAddress() {
        return this.getString(hostAddress);
    }

    @Generated
    public void setHostAddress(String v) {
        this.setString(hostAddress, v, null);
    }

    @Generated
    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    @Generated
    public void setFoxPort(int v) {
        this.setInt(foxPort, v, null);
    }

    @Generated
    public String getVersion() {
        return this.getString(version);
    }

    @Generated
    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Generated
    public String getHostModel() {
        return this.getString(hostModel);
    }

    @Generated
    public void setHostModel(String v) {
        this.setString(hostModel, v, null);
    }

    @Generated
    public String getHostModelVersion() {
        return this.getString(hostModelVersion);
    }

    @Generated
    public void setHostModelVersion(String v) {
        this.setString(hostModelVersion, v, null);
    }

    @Generated
    public String getHostId() {
        return this.getString(hostId);
    }

    @Generated
    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    @Generated
    public String getVmName() {
        return this.getString(vmName);
    }

    @Generated
    public void setVmName(String v) {
        this.setString(vmName, v, null);
    }

    @Generated
    public String getVmVersion() {
        return this.getString(vmVersion);
    }

    @Generated
    public void setVmVersion(String v) {
        this.setString(vmVersion, v, null);
    }

    @Generated
    public String getOsName() {
        return this.getString(osName);
    }

    @Generated
    public void setOsName(String v) {
        this.setString(osName, v, null);
    }

    @Generated
    public String getOsVersion() {
        return this.getString(osVersion);
    }

    @Generated
    public void setOsVersion(String v) {
        this.setString(osVersion, v, null);
    }

    @Generated
    public String getNiagaraPlatformType() {
        return this.getString(niagaraPlatformType);
    }

    @Generated
    public void setNiagaraPlatformType(String v) {
        this.setString(niagaraPlatformType, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BLearnStation[] make(FoxMessage msg) throws Exception {
        Array stations = new Array(BLearnStation.class);
        BLearnStation station = new BLearnStation();
        station.setStationName(msg.getString("station"));
        if (MulticastUtil.isIpv6Message(msg)) {
            station.setHostName(msg.getString("hostNameIPv6", msg.getString("hostName", "unknown")));
            station.setHostAddress(msg.getString("hostAddressIPv6", msg.getString("hostAddress", "unknown")));
        } else {
            station.setHostName(msg.getString("hostName"));
            station.setHostAddress(msg.getString("hostAddress"));
        }
        station.setVersion(msg.getString("version", "unknown"));
        station.setHostModel(msg.getString("hostModel", "unknown"));
        station.setHostModelVersion(msg.getString("hostModelVersion", "unknown"));
        station.setHostId(msg.getString("hostId", "unknown"));
        station.setVmName(msg.getString("vmName", "unknown"));
        station.setVmVersion(msg.getString("vmVersion", "unknown"));
        station.setOsName(msg.getString("osName", "unknown"));
        station.setOsVersion(msg.getString("osVersion", "unknown"));
        station.setNiagaraPlatformType(msg.getString("niagaraPlatformType", ""));
        station.invariant(false);
        if (msg.getInt("foxPort", 0) != 0) {
            BLearnStation foxStation = (BLearnStation)station.newCopy();
            foxStation.setScheme("fox");
            foxStation.setFoxPort(msg.getInt("foxPort", 0));
            foxStation.invariant(false);
            stations.add((Object)foxStation);
        }
        if (msg.getInt("foxsPort", 0) != 0) {
            BLearnStation foxsStation = (BLearnStation)station.newCopy();
            foxsStation.setScheme("foxs");
            foxsStation.setFoxPort(msg.getInt("foxsPort", 0));
            foxsStation.invariant(false);
            stations.add((Object)foxsStation);
        }
        return (BLearnStation[])stations.trim();
    }

    public BLearnStation() {
    }

    public BLearnStation(String stationName) {
        this.setStationName(stationName);
    }

    public String getKey() {
        return this.key;
    }

    public void invariant(boolean useHostName) {
        String preferredAddr;
        String string = preferredAddr = useHostName ? this.getHostName() : this.getHostAddress();
        if (preferredAddr.indexOf(58) != -1) {
            preferredAddr = "[" + preferredAddr + "]";
        }
        if (this.getScheme().equalsIgnoreCase("fox") && this.getFoxPort() != 1911) {
            preferredAddr = preferredAddr + ":" + this.getFoxPort();
        } else if (this.getScheme().equalsIgnoreCase("foxs") && this.getFoxPort() != 4911) {
            preferredAddr = preferredAddr + ":" + this.getFoxPort();
        }
        this.setAddress(preferredAddr);
        this.key = this.getStationName() + ":" + this.getScheme() + "@" + this.getHostAddress() + ":" + this.getFoxPort();
    }

    public String toString(Context cx) {
        String hostAddr = this.getHostAddress();
        if (hostAddr.indexOf(58) != -1) {
            hostAddr = "[" + hostAddr + "]";
        }
        return this.getStationName() + ":" + this.getScheme() + " @ " + this.getHostName() + "/" + hostAddr + ":" + this.getFoxPort() + " [" + this.getVersion() + "; " + this.getHostId() + "; " + this.getHostModel() + "; " + this.getHostModelVersion() + "; " + this.getOsName() + " " + this.getOsVersion() + "; " + this.getVmName() + " " + this.getVmVersion() + (this.getNiagaraPlatformType().isEmpty() ? "]" : "; " + this.getNiagaraPlatformType() + "]");
    }
}

