/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.sys;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.util.ContextThread;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lastLoginTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="lastLoginAddress", type="String", defaultValue="-", flags=3), @NiagaraProperty(name="lastLoginUsername", type="String", defaultValue="-", flags=3), @NiagaraProperty(name="lastLoginApp", type="String", defaultValue="-", flags=3)})
@NiagaraAction(name="forceDisconnect")
public class BFoxServerConnection
extends BFoxConnection {
    @Generated
    public static final Property lastLoginTime = BFoxServerConnection.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastLoginAddress = BFoxServerConnection.newProperty((int)3, (String)"-", null);
    @Generated
    public static final Property lastLoginUsername = BFoxServerConnection.newProperty((int)3, (String)"-", null);
    @Generated
    public static final Property lastLoginApp = BFoxServerConnection.newProperty((int)3, (String)"-", null);
    @Generated
    public static final Action forceDisconnect = BFoxServerConnection.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxServerConnection.class);
    private boolean persistent = false;

    @Generated
    public BAbsTime getLastLoginTime() {
        return (BAbsTime)this.get(lastLoginTime);
    }

    @Generated
    public void setLastLoginTime(BAbsTime v) {
        this.set(lastLoginTime, (BValue)v, null);
    }

    @Generated
    public String getLastLoginAddress() {
        return this.getString(lastLoginAddress);
    }

    @Generated
    public void setLastLoginAddress(String v) {
        this.setString(lastLoginAddress, v, null);
    }

    @Generated
    public String getLastLoginUsername() {
        return this.getString(lastLoginUsername);
    }

    @Generated
    public void setLastLoginUsername(String v) {
        this.setString(lastLoginUsername, v, null);
    }

    @Generated
    public String getLastLoginApp() {
        return this.getString(lastLoginApp);
    }

    @Generated
    public void setLastLoginApp(String v) {
        this.setString(lastLoginApp, v, null);
    }

    @Generated
    public void forceDisconnect() {
        this.invoke(forceDisconnect, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        if (this.session() != null) {
            this.session().close(null);
        }
        if (Sys.getStation() != null && Sys.getStation().isRunning()) {
            this.getConnectionTarget(NiagaraStation.class).ifPresent(station -> station.serverConnectionStopped(this));
        }
    }

    public final BUser getUser() {
        FoxSession session = this.session();
        if (session != null) {
            return session.getUser();
        }
        return null;
    }

    public final Context getSessionContext() {
        FoxSession session = this.session();
        if (session != null) {
            return session.getSessionContext();
        }
        return null;
    }

    @Override
    public void sessionOpened(FoxSession session) {
        if (this.session() != null) {
            this.session().close(new Exception("Reconnect while still server still connected"));
        }
        super.sessionOpened(session);
        this.getConnectionTarget(NiagaraStation.class).ifPresent(NiagaraStation::serverOpened);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionClosed(FoxSession session, Throwable cause) {
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        try {
            try {
                AuditEvent auditEvent;
                Auditor auditor = Sys.getAuditor();
                if (auditor != null && session.getUser() != null && (auditEvent = session.makeAuditEvent("Logout", session.getUser())) != null) {
                    auditor.audit(auditEvent);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.session() == session) {
                super.sessionClosed(session, cause);
            } else {
                this.log.trace("Closing session [" + session + " doesn't match opened session [" + this.session() + "]");
            }
        }
        finally {
            foxService.notifyServerConnectionClosed(this, cause);
        }
    }

    @Override
    public Thread makeThread(ThreadGroup group, Runnable runnable, String name) {
        return new FoxServerThread(group, runnable, name);
    }

    public void setPersistent(boolean value) {
        this.persistent = value;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void doForceDisconnect() throws Exception {
        this.close();
    }

    class FoxServerThread
    extends Thread
    implements ContextThread {
        FoxServerThread(ThreadGroup group, Runnable runnable, String name) {
            super(group, runnable, name);
        }

        public Context getContext() {
            return BFoxServerConnection.this.getSessionContext();
        }
    }
}

