/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.session;

import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.FoxServer;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.session.FrameQueue;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidChannelException;
import com.tridium.fox.sys.UnreachableStationException;
import java.util.logging.Level;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.LocalizableRuntimeException;

public class SessionDispatcher
implements Runnable {
    private FoxSession session;
    private String name;
    private boolean isAlive;
    private Thread thread;
    private FrameQueue queue;

    public SessionDispatcher(FoxSession session) {
        this.name = "Fox:Dispatcher:" + SecurityUtil.calculateSessionIdHash((String)session.getId());
        this.session = session;
        this.queue = new FrameQueue();
        this.isAlive = true;
    }

    public void enqueue(FoxFrame frame) throws InterruptedException {
        if (this.session.isClosed()) {
            throw new InterruptedException("FoxSession is closed");
        }
        this.queue.enqueue(frame);
    }

    public void start() {
        this.thread = this.session.conn.makeThread(Fox.threadGroup, this, this.name);
        this.thread.start();
    }

    public void kill() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.queue.kill();
    }

    @Override
    public void run() {
        while (this.isAlive && !this.session.isClosed()) {
            try {
                FoxFrame request = this.queue.dequeue(-1);
                this.dispatch(request);
            }
            catch (InterruptedException request) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void dispatch(FoxFrame frame) throws InterruptedException {
        block4: {
            try {
                FoxResponse resp = frame.channel == "fox" ? this.session.processFoxChannelRequest((FoxRequest)frame.message) : this.session.conn().process((FoxRequest)frame.message);
                this.session.sendReply(frame, resp);
            }
            catch (Throwable e) {
                if (!this.isAlive) break block4;
                if (e instanceof IncompatibleVersionException || e instanceof UnreachableStationException || e instanceof InvalidChannelException || e instanceof LocalizableRuntimeException && ("fox.channel.unsupportedRemoteVersion".equals(((LocalizableRuntimeException)e).getLexiconKey()) || "fox.channel.unsupportedRemoteVersionAlongRoute".equals(((LocalizableRuntimeException)e).getLexiconKey()))) {
                    FoxServer.log.log(Level.FINE, e.getMessage(), e);
                } else {
                    e.printStackTrace();
                }
                this.session.sendError(frame, e);
            }
        }
    }

    public String toString() {
        return this.name + " {" + this.queue + "}";
    }
}

