/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.kerberos;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class KerberosConfig
extends Configuration {
    AppConfigurationEntry entry = null;
    String principal = null;
    boolean useTicketCache = false;
    boolean doNotPrompt = false;
    boolean isInitiator = true;
    boolean storeKey = false;

    public KerberosConfig(String principal) {
        this.principal = principal;
        this.init();
    }

    public KerberosConfig(boolean useTicketCache, boolean doNotPrompt) {
        this.useTicketCache = useTicketCache;
        this.doNotPrompt = doNotPrompt;
        this.init();
    }

    public void setUseTicketCache(boolean useTicketCache) {
        this.useTicketCache = useTicketCache;
        this.init();
    }

    public void setDoNotPrompt(boolean doNotPrompt) {
        this.doNotPrompt = doNotPrompt;
        this.init();
    }

    public void setIsInitiator(boolean isInitiator) {
        this.isInitiator = isInitiator;
        if (!isInitiator) {
            this.storeKey = true;
        }
        this.init();
    }

    private void init() {
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.principal != null) {
            options.put("principal", this.principal);
        }
        options.put("useTicketCache", Boolean.toString(this.useTicketCache));
        options.put("doNotPrompt", Boolean.toString(this.doNotPrompt));
        options.put("isInitiator", Boolean.toString(this.isInitiator));
        options.put("storeKey", Boolean.toString(this.storeKey));
        options.put("refreshKrb5Config", "true");
        this.entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[]{this.entry};
        return entries;
    }
}

