/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid.ui;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.GridModel;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.util.BFormat;

public class GridUtil {
    public static String getString(GridModel model, int row, int col, Context cx) {
        BObject obj = model.getObjectAt(row, col);
        if (obj == null) {
            return "-";
        }
        BFormat format = model.getColumnFormat(col);
        return format == null ? obj.toString() : format.format((Object)obj, cx);
    }

    public static String getSummary(GridModel model, int row, int col, BOrd hyperlink, boolean linkFirstColOnly, Context cx) {
        BObject obj = model.getObjectAt(row, col);
        String text = model.getColumnName(col) + " = " + (obj == null ? "" : obj.toString());
        if (!(hyperlink.isNull() || linkFirstColOnly && col != 0)) {
            hyperlink = GridUtil.makeHyperlink(model, row, hyperlink);
            text = "Link to " + hyperlink + " | " + text;
        }
        return text;
    }

    public static BOrd makeHyperlink(GridModel model, int row, BOrd hyperlink) {
        if (hyperlink.isNull()) {
            return BOrd.NULL;
        }
        BObject base = model.getObjectAt(row, 0);
        if (base != null && base.isComponent()) {
            BOrd baseOrd = base.asComponent().getNavOrd().relativizeToSession();
            hyperlink = BOrd.make((BOrd)baseOrd, (BOrd)hyperlink).normalize();
        }
        return hyperlink;
    }

    public static BBrush getStatusFg(BObject obj) {
        if (obj instanceof BIStatusValue) {
            BStatus s = ((BIStatusValue)obj).getStatusValue().getStatus();
            if (s.isDisabled()) {
                return GridUtil.b(BStatus.disabledFg);
            }
            if (s.isFault()) {
                return GridUtil.b(BStatus.faultFg);
            }
            if (s.isDown()) {
                return GridUtil.b(BStatus.downFg);
            }
            if (s.isAlarm()) {
                return GridUtil.b(BStatus.alarmFg);
            }
            if (s.isStale()) {
                return GridUtil.b(BStatus.staleFg);
            }
            if (s.isOverridden()) {
                return GridUtil.b(BStatus.overriddenFg);
            }
        }
        return null;
    }

    public static BBrush getStatusBg(BObject obj) {
        if (obj instanceof BIStatusValue) {
            BStatus s = ((BIStatusValue)obj).getStatusValue().getStatus();
            if (s.isDisabled()) {
                return GridUtil.b(BStatus.disabledBg);
            }
            if (s.isFault()) {
                return GridUtil.b(BStatus.faultBg);
            }
            if (s.isDown()) {
                return GridUtil.b(BStatus.downBg);
            }
            if (s.isAlarm()) {
                return GridUtil.b(BStatus.alarmBg);
            }
            if (s.isStale()) {
                return GridUtil.b(BStatus.staleBg);
            }
            if (s.isOverridden()) {
                return GridUtil.b(BStatus.overriddenBg);
            }
        }
        return null;
    }

    private static BBrush b(BSimple s) {
        return ((BColor)s).toBrush();
    }
}

