/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.ux.history;

import com.tridium.history.BRootHistoryFolder;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryGroupings;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryScheme;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BAbsTimeRange;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;

@NiagaraType(agent={@AgentOn(types={"baja:Component"}, app="defaultMobile", requiredPermissions="r")})
@NiagaraSingleton
public final class BHistoryServerSideHandler
extends BSingleton
implements BIServerSideCallHandler {
    @Generated
    public static final BHistoryServerSideHandler INSTANCE = new BHistoryServerSideHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryServerSideHandler.class);
    private static final Log log = Log.getLog((String)"MobileHistoryApp");
    private static final String COL_ID = "id";
    private static final String COL_REC_TYPE = "recordType";
    private static final String COL_DISPLAY = "displayName";
    private static final String COL_ORD = "ord";
    private static final String QUERY_PARAM_END = "end=";
    private static final String QUERY_PARAM_START = "start=";
    private static final String FACETS_END_TIME = "END_TIME";
    private static final String FACETS_START_TIME = "START_TIME";

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BHistoryServerSideHandler() {
    }

    public BValue getHistoryRange(BComponent component, BValue value, Context cx) {
        BOrd ord = BOrd.NULL;
        BAbsTimeRange timeRange = new BAbsTimeRange();
        if (!(value instanceof BOrd)) {
            return timeRange;
        }
        ord = (BOrd)value;
        OrdQuery[] queries = ord.parse();
        for (int i = 0; i < queries.length; ++i) {
            OrdQuery query = queries[i];
            if (!query.getScheme().equals(BHistoryScheme.INSTANCE.getId())) continue;
            String body = query.getBody();
            BAbsTime startTime = BAbsTime.DEFAULT;
            BAbsTime endTime = BAbsTime.DEFAULT;
            int paramIndex = body.indexOf(63);
            if (paramIndex > 0) {
                String param = body.substring(paramIndex + 1);
                body = body.substring(0, paramIndex);
                int startIndex = param.indexOf(QUERY_PARAM_START);
                int endIndex = param.indexOf(QUERY_PARAM_END);
                if (startIndex > 0 && endIndex > 0) {
                    String startParam = param.substring(startIndex);
                    startParam = startParam.substring(QUERY_PARAM_START.length(), startParam.indexOf(";") - 1);
                    String endParam = param.substring(endIndex);
                    endParam = endParam.substring(QUERY_PARAM_END.length(), endParam.indexOf(";") - 1);
                    try {
                        startTime = (BAbsTime)startTime.decodeFromString(startParam);
                        endTime = (BAbsTime)endTime.decodeFromString(endParam);
                        timeRange.setStartTime(startTime);
                        timeRange.setEndTime(endTime);
                        break;
                    }
                    catch (Exception e) {
                        log.error("failed to parse time query data for history query: " + query.toString(), (Throwable)e);
                    }
                }
            }
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryId id = BHistoryId.make((String)body);
            BHistoryDatabase db = service.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(cx);){
                BIHistory history = conn.getHistory(id);
                startTime = conn.getFirstTimestamp(history);
                endTime = conn.getLastTimestamp(history);
                timeRange.setStartTime(startTime);
                timeRange.setEndTime(endTime);
                break;
            }
        }
        return timeRange;
    }

    public BValue getHistoryNavList(BComponent component, Context context) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BINavNode[] navChildren = service.getDatabase().getNavChildren();
        return BHistoryServerSideHandler.encodeNavNodePaths(navChildren, context);
    }

    public BValue getNavChildren(BComponent component, BValue value, Context cx) {
        BOrd ord = (BOrd)value;
        BObject bObject = ord.get();
        if (bObject instanceof BINavNode) {
            BINavNode node = (BINavNode)bObject;
            return BHistoryServerSideHandler.encodeNavNodePaths(node.getNavChildren(), cx);
        }
        return null;
    }

    public BValue getOrdDisplayName(BComponent comp, BValue ord, Context cx) {
        BINavNode node = (BINavNode)((BOrd)ord).get();
        return BString.make((String)node.getNavDisplayName(cx));
    }

    public BValue getDeviceHistories(BComponent comp, BValue devName, Context cx) {
        if (null == devName) {
            return null;
        }
        String dev = devName.toString();
        String bql = "history:|bql:select id where id like '/" + dev + "/%' order by " + COL_ID;
        BOrd query = BOrd.make((String)bql);
        BITable result = (BITable)query.get();
        return BHistoryServerSideHandler.encodeDeviceNavPaths(result, cx);
    }

    private static BComponent encodeNavNodePaths(BINavNode[] nodes, Context cx) {
        Arrays.sort(nodes, new SortNavNodesByDisplay(cx));
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryGroupings groupings = service.getHistoryGroupings();
        BComponent result = new BComponent();
        try (HistoryDatabaseConnection conn = service.getDatabase().getDbConnection(cx);){
            for (int i = 0; i < nodes.length; ++i) {
                Property prop;
                BPermissions permissions;
                BINavNode node = nodes[i];
                if (node instanceof BIProtected && !(permissions = cx.getUser().getPermissionsFor((BIProtected)node)).hasOperatorRead()) continue;
                BUnrestrictedFolder row = new BUnrestrictedFolder();
                BFacets facets = BFacets.NULL;
                BOrd navOrd = node.getNavOrd();
                BObject navObj = navOrd.get();
                if (navObj instanceof BIHistory) {
                    BIHistory history = (BIHistory)navObj;
                    BHistoryId id = history.getId();
                    BAbsTime firstTimestamp = conn.getFirstTimestamp(history);
                    BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                    BTypeSpec recordType = history.getRecordType();
                    facets = BFacets.make((String)FACETS_START_TIME, (BIDataValue)firstTimestamp, (String)FACETS_END_TIME, (BIDataValue)lastTimestamp);
                    row.add(SlotPath.escape((String)COL_REC_TYPE), recordType.newCopy(true));
                    row.add(SlotPath.escape((String)COL_ID), (BValue)BString.make((String)id.getHistoryName()));
                }
                OrdQuery[] parse = navOrd.parse();
                for (int j = 0; j < parse.length; ++j) {
                    OrdQuery query = parse[j];
                    if (!query.getScheme().equals(BHistoryScheme.INSTANCE.getId())) continue;
                    navOrd = BOrd.make((OrdQuery)query);
                    break;
                }
                row.add(SlotPath.escape((String)COL_ORD), navOrd.newCopy(true));
                String displayName = node.getNavDisplayName(cx);
                if (node instanceof BRootHistoryFolder && (prop = groupings.getProperty(displayName)) != null) {
                    displayName = groupings.getDisplayName((Slot)prop, cx);
                }
                row.add(SlotPath.escape((String)COL_DISPLAY), (BValue)BString.make((String)displayName));
                result.add("row?", (BValue)row, 0, facets, null);
            }
        }
        return result;
    }

    private static BComponent encodeDeviceNavPaths(BITable<?> table, Context cx) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BComponent result = new BComponent();
        Column[] columns = table.getColumns().list();
        try (TableCursor cursor = table.cursor();
             HistoryDatabaseConnection conn = service.getDatabase().getDbConnection(cx);){
            while (cursor.next()) {
                BUnrestrictedFolder row = new BUnrestrictedFolder();
                BPermissions permissions = BPermissions.DEFAULT;
                for (int i = 0; i < columns.length; ++i) {
                    BHistoryId id;
                    BIHistory history;
                    BObject rowObj = (BObject)cursor.cell(columns[i]);
                    if (!(rowObj instanceof BHistoryId) || (history = conn.getHistory(id = (BHistoryId)rowObj)) instanceof BIProtected && !(permissions = cx.getUser().getPermissionsFor((BIProtected)history)).hasOperatorRead()) continue;
                    BAbsTime firstTimestamp = conn.getFirstTimestamp(history);
                    BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                    BFacets facets = BFacets.make((String)FACETS_START_TIME, (BIDataValue)firstTimestamp, (String)FACETS_END_TIME, (BIDataValue)lastTimestamp);
                    BTypeSpec recordType = history.getRecordType();
                    row.add(COL_DISPLAY, (BValue)BString.make((String)history.getNavDisplayName(cx)));
                    row.add(COL_ORD, (BValue)history.getOrdInSpace());
                    row.add(COL_REC_TYPE, recordType.newCopy(true));
                    row.add(COL_ID, (BValue)BString.make((String)id.getHistoryName()));
                    result.add("row?", (BValue)row, 0, facets, null);
                }
            }
        }
        return result;
    }

    private static class SortNavNodesByDisplay
    implements Comparator<BINavNode> {
        private Context cx;

        public SortNavNodesByDisplay(Context cx) {
            this.cx = cx;
        }

        @Override
        public int compare(BINavNode a, BINavNode b) {
            if (a == null) {
                return b == null ? 0 : 1;
            }
            if (b == null) {
                return -1;
            }
            return a.getNavDisplayName(this.cx).compareTo(b.getNavDisplayName(this.cx));
        }
    }
}

