/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.ux;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.mobile.ux.BVelocityMobileView;
import com.tridium.mobile.ux.theme.BDefaultJQueryMobileTheme;
import com.tridium.mobile.ux.util.MobileUtil;
import com.tridium.ux.NiagaraEnv;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.mobile.fieldeditor.BMobileFieldEditor;
import javax.baja.mobile.theme.BMobileTheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.velocity.BIVelocityWebProfile;
import javax.baja.velocity.BVelocityView;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.WebOp;
import javax.baja.web.mobile.BIMobileWebView;
import javax.baja.web.mobile.BMobileWebProfile;
import javax.baja.web.mobile.BMobileWebViewExt;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

@NiagaraType
public final class BDefaultMobileWebProfile
extends BMobileWebProfile
implements BIVelocityWebProfile {
    @Generated
    public static final Type TYPE = Sys.loadType(BDefaultMobileWebProfile.class);
    @Deprecated
    private BTypeSpec themeTypeSpec = BTypeSpec.make((Type)BDefaultJQueryMobileTheme.TYPE);
    private static final Type mobilePxAppType = BDefaultMobileWebProfile.typeInfo("mobile:MobilePxApp");
    private boolean showHeader = true;
    private boolean showBack = true;
    private boolean showViews = true;
    private boolean showHome = true;
    private boolean showLogoutCommand = true;
    private static final String themeName = "theme";
    private static final String showHeaderName = "showHeader";
    private static final String showBackName = "showHeaderBackButton";
    private static final String showViewsName = "showSelectViews";
    private static final String showHomeName = "showHome";
    private static final String showLogoutCommandName = "showLogoutCommand";
    private static final BFacets showHideFacets = BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(mobile:show)%"), (String)"falseText", (BIDataValue)BString.make((String)"%lexicon(mobile:hide)%"));
    private static final BFacets themeFacets = BFacets.make((String)"targetType", (String)"mobile:MobileTheme");
    private static final String[] configList = new String[]{"theme", "showHeader", "showHeaderBackButton", "showSelectViews", "showHome", "showLogoutCommand"};
    private static final Log log = Log.getLog((String)"mobile");
    private static final String[] APP_NAMES = new String[]{"defaultMobile"};
    private static final AgentFilter viewExtFilter = AgentFilter.is((Type)BMobileWebViewExt.TYPE);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String[] getAppNames() {
        return (String[])APP_NAMES.clone();
    }

    public BWebProfileConfig getHxProfileConfig(BWebProfileConfig mobileConfig) {
        BWebProfileConfig hxConfig = new BWebProfileConfig();
        hxConfig.setTypeSpec(BTypeSpec.make((String)"mobile:DefaultMobileHandheldHxProfile"));
        String themeName = this.getBajauxThemeName(mobileConfig);
        hxConfig.add("selectedHxTheme", (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{themeName})));
        return hxConfig;
    }

    public BValue getConfig(String key) {
        if (key.equals(themeName)) {
            return this.themeTypeSpec;
        }
        if (key.equals(showHeaderName)) {
            return BBoolean.make((boolean)this.showHeader);
        }
        if (key.equals(showBackName)) {
            return BBoolean.make((boolean)this.showBack);
        }
        if (key.equals(showViewsName)) {
            return BBoolean.make((boolean)this.showViews);
        }
        if (key.equals(showHomeName)) {
            return BBoolean.make((boolean)this.showHome);
        }
        if (key.equals(showLogoutCommandName)) {
            return BBoolean.make((boolean)this.showLogoutCommand);
        }
        return null;
    }

    public void setConfig(String key, BValue value) {
        if (key.equals(themeName)) {
            if (value instanceof BDynamicEnum) {
                try {
                    this.themeTypeSpec = BTypeSpec.make((String)((BDynamicEnum)value).getTag());
                }
                catch (Throwable t) {
                    this.themeTypeSpec = BTypeSpec.make((Type)BDefaultJQueryMobileTheme.TYPE);
                }
            } else if (value instanceof BTypeSpec) {
                this.themeTypeSpec = (BTypeSpec)value;
            }
        } else if (key.equals(showHeaderName)) {
            if (value instanceof BBoolean) {
                this.showHeader = ((BBoolean)value).getBoolean();
            }
        } else if (key.equals(showBackName)) {
            if (value instanceof BBoolean) {
                this.showBack = ((BBoolean)value).getBoolean();
            }
        } else if (key.equals(showViewsName)) {
            if (value instanceof BBoolean) {
                this.showViews = ((BBoolean)value).getBoolean();
            }
        } else if (key.equals(showHomeName)) {
            if (value instanceof BBoolean) {
                this.showHome = ((BBoolean)value).getBoolean();
            }
        } else if (key.equals(showLogoutCommandName) && value instanceof BBoolean) {
            this.showLogoutCommand = ((BBoolean)value).getBoolean();
        }
    }

    public String[] listConfig() {
        return configList;
    }

    public BFacets getConfigFacets(String key) {
        if (key.equals(showHeaderName) || key.equals(showBackName) || key.equals(showViewsName) || key.equals(showHomeName) || key.equals(showLogoutCommandName)) {
            return showHideFacets;
        }
        if (key.equals(themeName)) {
            return themeFacets;
        }
        return BFacets.DEFAULT;
    }

    private boolean isPxMediaSupported(BAbstractPxView pxView) {
        String typeSpec = pxView.getMedia().toString();
        if ("mobile:MobilePxMedia".equals(typeSpec)) {
            return true;
        }
        if (("hx:HxPxMedia".equals(typeSpec) || "workbench:WbPxMedia".equals(typeSpec)) && mobilePxAppType != null) {
            Optional app = Sys.findService((Type)mobilePxAppType);
            return app.isPresent() && ((BBoolean)((BComponent)app.get()).get("showHxPx")).getBoolean();
        }
        return false;
    }

    private boolean isMobilePxAppView(AgentInfo agentInfo) {
        String typeSpec = agentInfo.getAgentType().toString();
        return "mobile:MobilePxAppView".equals(typeSpec);
    }

    public boolean hasView(BObject target, AgentInfo agentInfo) {
        if (agentInfo instanceof BAbstractPxView) {
            return this.isPxMediaSupported((BAbstractPxView)agentInfo);
        }
        return !this.isMobilePxAppView(agentInfo);
    }

    public VelocityContext makeVelocityContext(BVelocityView view, WebOp op) throws Exception {
        String themeName;
        VelocityContext vContext = view.makeVelocityContext(op, (BIWebProfile)this);
        vContext.put("viewTemplate", (Object)view.getTemplateFileOrd(op));
        vContext.put("profileCss", (Object)this.generateProfileCss(view, op));
        vContext.put("view", (Object)view);
        vContext.put("viewPortZoom", (Object)Boolean.FALSE);
        JSONObject viewInfo = new JSONObject();
        viewInfo.put("ord", (Object)op.getOrd());
        viewInfo.put("typeSpec", (Object)view.getType().toString());
        this.initNiagaraViewInfo(viewInfo, view, op);
        if (view instanceof BVelocityMobileView) {
            ((BVelocityMobileView)view).initNiagaraViewInfo(viewInfo, op);
            vContext.put("keepAlive", (Object)((BVelocityMobileView)view).keepViewAlive());
        }
        if ((themeName = this.getBajauxThemeName(op.getProfileConfig((javax.baja.sys.Context)op))) != null) {
            NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)op.getRequest(), (boolean)true);
            session.setAttribute("themeName", (Object)themeName);
        }
        vContext.put("viewInfo", (Object)("<script type='text/javascript'>" + new NiagaraEnv(NiagaraEnv.EnvType.MOBILE).withWebOp(op).withThemeName(themeName).toJavaScript() + "niagara.view=" + viewInfo.toString() + ";</script>\n"));
        StringBuilder viewExtBuff = new StringBuilder();
        AgentList list = this.getAgents().filter(viewExtFilter);
        if (list.size() > 0) {
            LinkedHashSet<BOrd> cssSet = null;
            LinkedHashSet<BOrd> jsSet = null;
            for (int i = 0; i < list.size(); ++i) {
                int j;
                BMobileWebViewExt ext = (BMobileWebViewExt)list.get(i).getInstance();
                BOrd[] ords = ext.getCssResources((BMobileWebProfile)this, (BIMobileWebView)view, (javax.baja.sys.Context)op);
                for (j = 0; j < ords.length; ++j) {
                    if (ords[i].isNull()) continue;
                    if (cssSet == null) {
                        cssSet = new LinkedHashSet<BOrd>();
                    }
                    cssSet.add(ords[j]);
                }
                ords = ext.getJavaScriptResources((BMobileWebProfile)this, (BIMobileWebView)view, (javax.baja.sys.Context)op);
                for (j = 0; j < ords.length; ++j) {
                    if (ords[i].isNull()) continue;
                    if (jsSet == null) {
                        jsSet = new LinkedHashSet<BOrd>();
                    }
                    jsSet.add(ords[j]);
                }
            }
            if (cssSet != null) {
                for (BOrd ord : cssSet) {
                    viewExtBuff.append("<link rel='stylesheet' href='/ord?");
                    viewExtBuff.append(ord.toString());
                    viewExtBuff.append("'/>");
                }
            }
            if (jsSet != null) {
                for (BOrd ord : jsSet) {
                    viewExtBuff.append("<script type='text/javascript' src='/ord?");
                    viewExtBuff.append(ord.toString());
                    viewExtBuff.append("'></script>");
                }
            }
        }
        vContext.put("viewExt", (Object)viewExtBuff.toString());
        return vContext;
    }

    public String getBajauxThemeName(BWebProfileConfig mobileConfig) {
        BTypeSpec spec = (BTypeSpec)mobileConfig.get(themeName);
        BMobileTheme profile = (BMobileTheme)spec.getInstance();
        return profile.getBajauxThemeName(mobileConfig);
    }

    public void write(BVelocityView view, VelocityContext vContext, WebOp op) throws Exception {
        HttpServletResponse response = op.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Expires", "-1");
        response.addHeader("Cache-Control", "no-store");
        op.setContentType("text/html");
        PrintWriter out = op.getWriter();
        Template template = BVelocityView.getVelocityEngineInstance().getTemplate(this.getTemplateFileOrd().toString());
        template.merge((Context)vContext, (Writer)out);
        out.flush();
    }

    private BOrd getTemplateFileOrd() {
        return BOrd.make((String)"module://mobile/rc/profile.vm");
    }

    private void addAvailableFieldEditors(JSONObject viewInfo, BVelocityView view, javax.baja.sys.Context cx) throws JSONException {
        JSONObject typeToFE = new JSONObject();
        JSONObject feToResource = new JSONObject();
        TypeInfo[] feTypes = Sys.getRegistry().getConcreteTypes(BMobileFieldEditor.TYPE.getTypeInfo());
        for (int i = 0; i < feTypes.length; ++i) {
            TypeInfo feType = feTypes[i];
            BMobileFieldEditor feInstance = (BMobileFieldEditor)feType.getInstance();
            String feTypeName = feType.getTypeSpec().toString();
            JSONObject resourceObj = new JSONObject();
            JSONArray agentOnArr = new JSONArray();
            typeToFE.put(feTypeName, (Object)new JSONArray());
            TypeInfo[] agentOn = feType.getAgentInfo().getAgentOn();
            for (int j = 0; j < agentOn.length; ++j) {
                JSONArray arr;
                String typeName = agentOn[j].getTypeSpec().toString();
                if (typeToFE.has(typeName)) {
                    arr = typeToFE.getJSONArray(typeName);
                } else {
                    arr = new JSONArray();
                    typeToFE.put(typeName, (Object)arr);
                }
                arr.put((Object)feTypeName);
                agentOnArr.put((Object)typeName);
            }
            BOrd[] jsResources = feInstance.getJavaScriptResources(this, (BIMobileWebView)view, cx);
            JSONArray jsArray = new JSONArray();
            if (jsResources != null) {
                for (int j = 0; j < jsResources.length; ++j) {
                    BOrd ord = jsResources[j];
                    jsArray.put((Object)ord.toString());
                }
            }
            resourceObj.put("js", (Object)jsArray);
            BOrd[] cssResources = feInstance.getCssResources(this, (BIMobileWebView)view, cx);
            JSONArray cssArray = new JSONArray();
            if (cssResources != null) {
                for (int j = 0; j < cssResources.length; ++j) {
                    BOrd ord = cssResources[j];
                    cssArray.put((Object)ord.toString());
                }
            }
            resourceObj.put("css", (Object)cssArray);
            resourceObj.put("agentOn", (Object)agentOnArr);
            feToResource.put(feTypeName, (Object)resourceObj);
        }
        viewInfo.put("customFieldEditors", (Object)typeToFE);
        viewInfo.put("fieldEditorResources", (Object)feToResource);
    }

    private void initNiagaraViewInfo(JSONObject viewInfo, BVelocityView view, WebOp op) throws Exception {
        JSONObject profile = new JSONObject();
        profile.put(showHeaderName, this.showHeader);
        profile.put("showBack", this.showBack);
        profile.put("showViews", this.showViews);
        profile.put(showHomeName, this.showHome);
        profile.put("showLogoutCmd", this.showLogoutCommand);
        viewInfo.put("profile", (Object)profile);
        this.addAvailableFieldEditors(viewInfo, view, null);
    }

    private String generateProfileCss(BVelocityView view, WebOp op) {
        StringBuilder buff = new StringBuilder();
        buff.append("<style>\n");
        buff.append("  .profileHeader {");
        if (!this.showHeader) {
            buff.append("display: none !important;");
        }
        buff.append("}\n");
        buff.append("  .profileHeaderBack {");
        if (!this.showBack) {
            buff.append("display: none !important;");
        }
        buff.append("}\n");
        buff.append("</style>\n");
        String[] cssResources = MobileUtil.getThemeCssResources((BMobileTheme)this.themeTypeSpec.getInstance(), this, (BIMobileWebView)view, op);
        if (cssResources != null && cssResources.length > 0) {
            for (int i = 0; i < cssResources.length; ++i) {
                buff.append("<link rel='stylesheet' href='").append(cssResources[i]).append("'/>\n");
            }
        } else {
            buff.append("<link rel='stylesheet' src='/module/mobile/ext/jqm/jquery.mobile.theme-1.4.5.css' />\n");
        }
        return buff.toString();
    }

    private static Type typeInfo(String typeSpec) {
        try {
            return Sys.getRegistry().getType(typeSpec).getTypeSpec().getResolvedType();
        }
        catch (Exception e) {
            return null;
        }
    }
}

