/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
public final class BLonDouble
extends BLonPrimitive
implements BINumeric {
    public static final BLonDouble DEFAULT = new BLonDouble(0.0);
    public static final Type TYPE = Sys.loadType(BLonDouble.class);
    public static final BLonDouble POSITIVE_INFINITY = new BLonDouble(Double.POSITIVE_INFINITY);
    public static final BLonDouble NEGATIVE_INFINITY = new BLonDouble(Double.NEGATIVE_INFINITY);
    public static final BLonDouble NaN = new BLonDouble(Double.NaN);
    private double value;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BLonDouble make(double value) {
        if (value == 0.0) {
            return DEFAULT;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Double.isNaN(value)) {
            return NaN;
        }
        return new BLonDouble(value);
    }

    private BLonDouble(double value) {
        this.value = value;
    }

    public double getDouble() {
        return this.value;
    }

    public int getInt() {
        return (int)this.value;
    }

    public static String toString(double value, Context context) {
        BUnit units = null;
        if (context != null && (units = (BUnit)context.getFacet("units")) != null && units.isNull()) {
            units = null;
        }
        String s = value == Double.POSITIVE_INFINITY ? "+inf" : (value == Double.NEGATIVE_INFINITY ? "-inf" : (Double.isNaN(value) ? "nan" : Double.toString(value)));
        if (units != null) {
            s = s + ' ' + units.getSymbol();
        }
        return s;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.value) & 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLonDouble) {
            double x = ((BLonDouble)((Object)obj)).value;
            if (x == this.value) {
                return true;
            }
            if (Double.isNaN(x) && Double.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(double a, double b) {
        if (a == b) {
            return true;
        }
        return Double.isNaN(a) && Double.isNaN(b);
    }

    public int compareTo(Object obj) {
        double a = this.value;
        double b = ((BLonDouble)((Object)obj)).value;
        if (BLonDouble.equals(a, b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public String toString(Context context) {
        return BLonDouble.toString(this.value, context);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    public BObject decode(DataInput in) throws IOException {
        double f = in.readDouble();
        if (BLonDouble.equals(this.value, f)) {
            return this;
        }
        return new BLonDouble(f);
    }

    public String encodeToString() throws IOException {
        return BLonDouble.encodeToString(this.value);
    }

    public static String encodeToString(double value) throws IOException {
        if (value == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Double.isNaN(value)) {
            return "nan";
        }
        return String.valueOf(value);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            if (s.equals("+inf")) {
                return POSITIVE_INFINITY;
            }
            if (s.equals("-inf")) {
                return NEGATIVE_INFINITY;
            }
            if (s.equals("nan")) {
                return NaN;
            }
            return new BLonDouble(Double.parseDouble(s));
        }
        catch (Throwable e) {
            throw new IOException("Invalid double: " + s);
        }
    }

    public static double doubleFromString(String s) throws IOException {
        try {
            if (s.equalsIgnoreCase("+inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (s.equalsIgnoreCase("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (s.equalsIgnoreCase("nan")) {
                return Double.NaN;
            }
            return Double.parseDouble(s);
        }
        catch (Throwable e) {
            throw new IOException("Invalid double: " + s);
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out, BLonElementQualifiers e) {
        double val = this.value;
        boolean invalid = false;
        if (e.hasInvalidValue() && Double.isNaN(val)) {
            val = e.getInvalidValue();
            invalid = true;
        } else {
            if (e.getOffset() != 0.0f) {
                val += (double)e.getOffset();
            }
            if (e.getResolution() != 1.0f) {
                val /= (double)e.getResolution();
            }
        }
        switch (e.getElemtype().getOrdinal()) {
            case 0: {
                out.writeUnsigned8((int)val);
                break;
            }
            case 1: {
                out.writeSigned8((int)val);
                break;
            }
            case 2: {
                out.writeUnsigned8((int)val);
                break;
            }
            case 3: {
                out.writeSigned16((int)val);
                break;
            }
            case 4: {
                out.writeUnsigned16((int)val);
                break;
            }
            case 5: {
                out.writeSigned32((int)val);
                break;
            }
            case 16: {
                if (invalid) {
                    out.writeUnsigned32(e.getInvalidValueL());
                    break;
                }
                out.writeUnsigned32((long)val);
                break;
            }
            case 12: {
                out.writeBit((int)val, e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 13: {
                out.writeSignedBit((int)val, e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 8: {
                out.writeFloat((float)val);
                break;
            }
            case 17: {
                out.writeDouble(val);
                break;
            }
            case 18: {
                if (invalid) {
                    out.writeSigned64(e.getInvalidValueL());
                    break;
                }
                out.writeSigned64((long)val);
                break;
            }
            case 19: {
                if (invalid) {
                    out.writeUnsigned64(new BigInteger(Long.toString(e.getInvalidValueL())));
                    break;
                }
                out.writeUnsigned64(new BigInteger(Long.toString((long)val)));
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonDouble " + (Object)((Object)e.getElemtype()));
            }
        }
    }

    @Override
    public BLonPrimitive fromInputStream(LonInputStream in, BLonElementQualifiers e) {
        double val;
        switch (e.getElemtype().getOrdinal()) {
            case 0: {
                val = in.readUnsigned8();
                break;
            }
            case 1: {
                val = in.readSigned8();
                break;
            }
            case 2: {
                val = in.readUnsigned8();
                break;
            }
            case 3: {
                val = in.readSigned16();
                break;
            }
            case 4: {
                val = in.readUnsigned16();
                break;
            }
            case 5: {
                val = in.readSigned32();
                break;
            }
            case 16: {
                long lval = in.readUnsigned32();
                if (e.isInvalid(lval)) {
                    return BLonDouble.make(Double.NaN);
                }
                val = lval;
                break;
            }
            case 12: {
                val = in.readBit(e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 13: {
                val = in.readSignedBit(e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 8: {
                val = in.readFloat();
                break;
            }
            case 17: {
                val = in.readDouble();
                break;
            }
            case 18: {
                long lval = in.readSigned64();
                if (e.isInvalid(lval)) {
                    return BLonDouble.make(Double.NaN);
                }
                val = lval;
                break;
            }
            case 19: {
                val = in.readUnsigned64().doubleValue();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonDouble.");
            }
        }
        if (e.isInvalid(val)) {
            return BLonDouble.make(Double.NaN);
        }
        if (e.getResolution() != 1.0f) {
            val *= (double)e.getResolution();
        }
        if (e.getOffset() != 0.0f) {
            val -= (double)e.getOffset();
        }
        if (val == this.value) {
            return this;
        }
        return BLonDouble.make(val);
    }

    @Override
    public double getDataAsDouble() {
        return this.value;
    }

    @Override
    public BLonPrimitive makeFromDouble(double v, BLonElementQualifiers e) {
        return BLonDouble.make(v);
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public boolean getDataAsBoolean() {
        return this.value > 0.0;
    }

    @Override
    public BLonPrimitive makeFromBoolean(boolean v) {
        return BLonDouble.make(v ? 1.0f : 0.0f);
    }

    @Override
    public String getDataAsString() {
        return Double.toString(this.value);
    }

    @Override
    public BLonPrimitive makeFromString(String v) {
        double f = Double.NaN;
        try {
            f = Double.valueOf(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BLonDouble.make(f);
    }

    @Override
    public BEnum getDataAsEnum(BEnum en) {
        try {
            BEnumRange enRng = en.getRange();
            return enRng.get((int)this.value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public BLonPrimitive makeFromEnum(BEnum v) {
        return new BLonDouble(v.getOrdinal());
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public double getNumeric() {
        return this.value;
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }
}

