/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUtil;
import java.util.Vector;

public class XLonDataUtil {
    private static String[] SnvtTypeNames = null;
    private static String[] ScptTypeNames = null;
    private static final String[] ApplicationTypes = new String[]{"unknown", "mip", "neuron", "hostSelect", "hostNISelect"};
    private static final String[] ServiceTypes = new String[]{"acked", "unackedRpt", "unacked", "request"};
    private static final String[] Scope = new String[]{"node", "object", "nv"};

    public static String snvtTypeToString(int type) {
        return XLonDataUtil.getString(XLonDataUtil.getSnvtTypeNames(), type, SnvtTypeNames[0]);
    }

    public static int snvtTypeFromString(String type) {
        if (type == null || type.length() == 0) {
            return 0;
        }
        int ndx = type.indexOf(43);
        String name = ndx > 0 ? type.substring(0, ndx) : type;
        return XLonDataUtil.fromString(XLonDataUtil.getSnvtTypeNames(), name, 0);
    }

    public static boolean isDiffQualifier(String type) {
        int ndx = type.indexOf(43);
        if (ndx < 0) {
            return false;
        }
        return type.substring(ndx + 1).equals("diff");
    }

    public static String getSnvtTypeName(int snvt, String def) {
        String[] snvts = XLonDataUtil.getSnvtTypeNames();
        if (snvt < 1 || snvt >= snvts.length) {
            return def;
        }
        return snvts[snvt];
    }

    private static String[] getSnvtTypeNames() {
        if (SnvtTypeNames == null) {
            int ndx;
            XTypeDef t;
            int i;
            Vector<XTypeDef> types = XUtil.getStandard().types;
            int maxType = 0;
            for (i = 0; i < types.size(); ++i) {
                t = types.elementAt(i);
                if (t.isCpType() || (ndx = t.getTypeIndex()) <= maxType) continue;
                maxType = ndx;
            }
            SnvtTypeNames = new String[maxType + 1];
            for (i = 0; i < types.size(); ++i) {
                t = types.elementAt(i);
                if (t.isCpType() || (ndx = t.getTypeIndex()) < 0) continue;
                XLonDataUtil.SnvtTypeNames[ndx] = NameUtil.toJavaName(t.getName(), false);
            }
            for (i = 0; i <= maxType; ++i) {
                if (SnvtTypeNames[i] != null) continue;
                XLonDataUtil.SnvtTypeNames[i] = "xxx";
            }
        }
        return SnvtTypeNames;
    }

    public static String scptTypeToString(int type) {
        return XLonDataUtil.getString(XLonDataUtil.getScptTypeNames(), type, ScptTypeNames[0]);
    }

    public static int scptTypeFromString(String type) {
        return XLonDataUtil.fromString(XLonDataUtil.getScptTypeNames(), type, 0);
    }

    public static String getScptTypeName(int scpt, String def) {
        String[] scpts = XLonDataUtil.getScptTypeNames();
        if (scpt < 1 || scpt >= scpts.length) {
            return def;
        }
        return scpts[scpt];
    }

    private static String[] getScptTypeNames() {
        if (ScptTypeNames == null) {
            int ndx;
            XTypeDef t;
            int i;
            Vector<XTypeDef> types = XUtil.getStandard().types;
            int maxType = 0;
            for (i = 0; i < types.size(); ++i) {
                t = types.elementAt(i);
                if (!t.isCpType() || (ndx = t.getTypeIndex()) <= maxType) continue;
                maxType = ndx;
            }
            ScptTypeNames = new String[maxType + 1];
            for (i = 0; i < types.size(); ++i) {
                t = types.elementAt(i);
                if (!t.isCpType() || (ndx = t.getTypeIndex()) < 0) continue;
                XLonDataUtil.ScptTypeNames[ndx] = NameUtil.toJavaName(t.getName(), false);
            }
            for (i = 0; i <= maxType; ++i) {
                if (ScptTypeNames[i] != null) continue;
                XLonDataUtil.ScptTypeNames[i] = "xxx";
            }
        }
        return ScptTypeNames;
    }

    public static String applicationTypeToString(int ndx) {
        return XLonDataUtil.getString(ApplicationTypes, ndx, ApplicationTypes[0]);
    }

    public static int applicationTypeFromString(String type) {
        return XLonDataUtil.fromString(ApplicationTypes, type, 0);
    }

    public static boolean isHostedApplication(String type) {
        return type.equals("mip") || type.equals("hostSelect") || type.equals("hostNISelect");
    }

    public static String serviceTypeToString(int ndx) {
        return XLonDataUtil.getString(ServiceTypes, ndx, ServiceTypes[0]);
    }

    public static int serviceTypeFromString(String type) {
        return XLonDataUtil.fromString(ServiceTypes, type, 0);
    }

    public static String scopeToString(int ndx) {
        return XLonDataUtil.getString(Scope, ndx, Scope[0]);
    }

    public static int scopeFromString(String type) {
        return XLonDataUtil.fromString(Scope, type, 0);
    }

    public static String flagToString(int flag) {
        String sendBack = "";
        if (((flag &= 0xFF) & 0x7F) == 0) {
            return "anytime";
        }
        if ((flag & 1) != 0) {
            sendBack = sendBack + " objDisable";
        }
        if ((flag & 2) != 0) {
            sendBack = sendBack + " offline";
        }
        if ((flag & 4) != 0) {
            sendBack = (flag & 0x20) != 0 ? sendBack + " deviceSpecific" : sendBack + " constant";
        }
        if ((flag & 8) != 0) {
            sendBack = sendBack + " reset";
        }
        if ((flag & 0x10) != 0) {
            sendBack = sendBack + " mfgOnly";
        }
        if (sendBack.startsWith(" ")) {
            sendBack = sendBack.substring(1);
        }
        return sendBack;
    }

    public static int flagFromString(String string) {
        int flag = 128;
        if (string.indexOf("anytime") != -1) {
            return flag;
        }
        if (string.indexOf("objDisable") != -1) {
            flag |= 1;
        }
        if (string.indexOf("offline") != -1) {
            flag |= 2;
        }
        if (string.indexOf("constant") != -1) {
            flag |= 4;
        }
        if (string.indexOf("reset") != -1) {
            flag |= 8;
        }
        if (string.indexOf("mfgOnly") != -1) {
            flag |= 0x10;
        }
        if (string.indexOf("deviceSpecific") != -1) {
            flag |= 0x24;
        }
        return flag;
    }

    public static boolean isReadOnly(String flag) {
        return flag.indexOf("constant") >= 0 || flag.indexOf("deviceSpecific") >= 0;
    }

    public static String getString(String[] a, int ndx, String def) {
        if (ndx >= a.length) {
            return def;
        }
        return a[ndx];
    }

    public static int fromString(String[] a, String s, int def) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(s)) continue;
            return i;
        }
        return def;
    }
}

