/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.file.LonFileReadWrite;
import com.tridium.lonworks.file.LonFileTransfer;
import com.tridium.lonworks.file.NoDirectoryException;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.util.LonFile;

public class XLonFile {
    public static LonFile createFile(LonAddress devAdr, LonComm lonComm, XLonDevice xdev) throws LonException {
        LonFile file = null;
        int dirNv = XLonFile.findLonObjectNvProperty(xdev, 0, 8, 114);
        if (dirNv != -1) {
            file = new LonFileReadWrite(devAdr, lonComm, dirNv);
        } else {
            int statNv;
            int reqNv = XLonFile.findLonObjectNvProperty(xdev, 0, 5, 73);
            if (reqNv != -1 && (statNv = XLonFile.findLonObjectNvProperty(xdev, 0, 6, 74)) != -1) {
                int posNv = XLonFile.findLonObjectNvProperty(xdev, 0, 7, 90);
                try {
                    file = new LonFileTransfer(devAdr, lonComm, reqNv, statNv, posNv);
                }
                catch (NoDirectoryException e) {
                    lonComm.lonNetwork().log().warning("Device has file snvts but reports no file directory");
                    return null;
                }
            } else {
                return null;
            }
        }
        return file;
    }

    public static int findLonObjectNvProperty(XLonDevice xdev, int objectIndex, int memberIndex, int snvtType) throws LonException {
        XNetworkVariable[] nvs = xdev.getNetworkVariables();
        for (int i = 0; i < nvs.length; ++i) {
            XNetworkVariable nv = nvs[i];
            try {
                if (nv.objectIndex.length() <= 0 || Integer.parseInt(nv.objectIndex) != objectIndex || nv.memberIndex != memberIndex || nv.mfgMember || XLonDataUtil.snvtTypeFromString(nv.snvtType) != snvtType) continue;
                return nv.index;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }
}

