/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.TypeScalar;
import java.io.IOException;

public class TypeBitfield
extends TypeScalar {
    public boolean bitfSigned;
    public int bitfOffset;
    public int bitfSize;

    public TypeBitfield(ResFileInputStream in) throws IOException {
        this.nodeType = 11;
        int bitfStuff = in.readUnsigned8();
        this.bitfSigned = (bitfStuff & 0x80) != 0;
        this.bitfOffset = (bitfStuff & 0x70) >> 4;
        this.bitfSize = bitfStuff & 0xF;
        this.parseRangeScale(in);
    }

    @Override
    protected long getMinPossible() {
        if (this.bitfSigned) {
            return -1 << this.bitfSize - 1;
        }
        return 0L;
    }

    @Override
    protected long getMaxPossible() {
        if (this.bitfSigned) {
            return 1 << this.bitfSize - 1;
        }
        return (1 << this.bitfSize) - 1;
    }

    @Override
    protected long readRange(ResFileInputStream in) throws IOException {
        if (this.bitfSigned) {
            return in.readSigned8();
        }
        return in.readUnsigned8();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append("TypeBitField").append("\n");
        super.toString(sb);
        sb.append("  bit - ");
        if (this.bitfSigned) {
            sb.append("signed  ");
        }
        sb.append(" Offset = ").append(this.bitfOffset);
        sb.append(" Size = ").append(this.bitfSize).append("\n");
    }
}

