/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryNvConfigResponse;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;

public class ExEnumerateNvConfigResponse
extends QueryNvConfigResponse
implements NetMessages {
    int index;
    int tgtNvIndex;
    boolean nvWriteByIndex;
    boolean nvRemoteNvAuth;
    boolean nvReadByIndex;

    public ExEnumerateNvConfigResponse(LonInputStream in) throws LonException {
        this.fromInputStream(in);
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTgtNvIndex() {
        return this.tgtNvIndex;
    }

    public boolean getNvWriteByIndex() {
        return this.nvWriteByIndex;
    }

    public boolean getNvRemoteNvAuth() {
        return this.nvRemoteNvAuth;
    }

    public boolean getNvReadByIndex() {
        return this.nvReadByIndex;
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.code = in.readUnsigned8();
        if (this.code != 48) {
            throw new InvalidResponseException(this.code);
        }
        this.index = in.readUnsigned16();
        int mrk = in.setBitFieldMark();
        if (this.configData == null) {
            this.configData = new BNvConfigData();
        }
        this.configData.setPriority(in.readBooleanBit(0, 7, 1));
        BLonNvDirection dir = in.readBooleanBit(0, 6, 1) ? BLonNvDirection.output : BLonNvDirection.input;
        this.configData.setDirection(dir);
        this.configData.setSelector(in.readBit(0, 0, 6) << 8 | in.readUnsigned8());
        this.configData.setTurnAround(in.readBooleanBit(2, 7, 1));
        this.configData.setAuthenticated(in.readBooleanBit(2, 6, 1));
        this.nvWriteByIndex = in.readBooleanBit(2, 5, 1);
        this.nvRemoteNvAuth = in.readBooleanBit(2, 4, 1);
        this.nvReadByIndex = in.readBooleanBit(3, 7, 1);
        this.configData.setServiceType(BLonServiceType.make(in.readBit(3, 5, 2)));
        int adrNdx = in.readUnsigned16();
        if (adrNdx == 65535) {
            adrNdx = -1;
        }
        this.configData.setAddrIndex(adrNdx);
        this.tgtNvIndex = in.readUnsigned16();
        in.resetBitFieldMark(mrk);
    }
}

