/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.discover;

import com.tridium.util.CompUtil;
import java.util.HashMap;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonSimple;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targetName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="elementName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="pointType", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="units", type="String", defaultValue="", flags=1), @NiagaraProperty(name="targetType", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=1), @NiagaraProperty(name="isTargetComponentWritable", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="targetFacets", type="BFacets", defaultValue="BFacets.DEFAULT", flags=1), @NiagaraProperty(name="defaultName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="targetPathName", type="String", defaultValue="", flags=1)})
public class BLonCreationEntry
extends BComponent {
    @Generated
    public static final Property targetName = BLonCreationEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property elementName = BLonCreationEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property pointType = BLonCreationEntry.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property units = BLonCreationEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property targetType = BLonCreationEntry.newProperty((int)1, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Property isTargetComponentWritable = BLonCreationEntry.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property targetFacets = BLonCreationEntry.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property defaultName = BLonCreationEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property targetPathName = BLonCreationEntry.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonCreationEntry.class);
    private BComponent target;
    private Property targetProp;
    private static BIcon FloatElementIcon = BIcon.make((String)"module://icons/x16/statusNumeric.png");
    private static BIcon BooleanElementIcon = BIcon.make((String)"module://icons/x16/statusBoolean.png");
    private static BIcon EnumElementIcon = BIcon.make((String)"module://icons/x16/statusEnum.png");
    private static BIcon StringElementIcon = BIcon.make((String)"module://icons/x16/statusString.png");
    private static BIcon LonObjectIcon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/object.png");
    private static BIcon LonObjectFolderIcon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/objectFolder.png");

    @Generated
    public String getTargetName() {
        return this.getString(targetName);
    }

    @Generated
    public void setTargetName(String v) {
        this.setString(targetName, v, null);
    }

    @Generated
    public String getElementName() {
        return this.getString(elementName);
    }

    @Generated
    public void setElementName(String v) {
        this.setString(elementName, v, null);
    }

    @Generated
    public int getPointType() {
        return this.getInt(pointType);
    }

    @Generated
    public void setPointType(int v) {
        this.setInt(pointType, v, null);
    }

    @Generated
    public String getUnits() {
        return this.getString(units);
    }

    @Generated
    public void setUnits(String v) {
        this.setString(units, v, null);
    }

    @Generated
    public BTypeSpec getTargetType() {
        return (BTypeSpec)this.get(targetType);
    }

    @Generated
    public void setTargetType(BTypeSpec v) {
        this.set(targetType, (BValue)v, null);
    }

    @Generated
    public boolean getIsTargetComponentWritable() {
        return this.getBoolean(isTargetComponentWritable);
    }

    @Generated
    public void setIsTargetComponentWritable(boolean v) {
        this.setBoolean(isTargetComponentWritable, v, null);
    }

    @Generated
    public BFacets getTargetFacets() {
        return (BFacets)this.get(targetFacets);
    }

    @Generated
    public void setTargetFacets(BFacets v) {
        this.set(targetFacets, (BValue)v, null);
    }

    @Generated
    public String getDefaultName() {
        return this.getString(defaultName);
    }

    @Generated
    public void setDefaultName(String v) {
        this.setString(defaultName, v, null);
    }

    @Generated
    public String getTargetPathName() {
        return this.getString(targetPathName);
    }

    @Generated
    public void setTargetPathName(String v) {
        this.setString(targetPathName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLonCreationEntry() {
    }

    public BLonCreationEntry(BComponent lo) {
        this.target = lo;
        this.setTargetName(lo.getName());
        BIcon targetIcon = this.getTargetIcon();
        if (targetIcon != null) {
            this.add("icon", (BValue)targetIcon);
        }
        this.setTargetType(this.getTarget().getType().getTypeSpec());
        this.setTargetFacets(this.getFacets());
        this.setDefaultName(this.getDefaultProxyName());
        this.setTargetPathName(this.getDefaultTargetPathName());
        BLonComponent lonComponent = this.getLonComponent();
        if (lonComponent != null) {
            this.setIsTargetComponentWritable(lonComponent.isWriteable());
        }
    }

    public BLonCreationEntry(BLonData ldat, String elementName, String units) {
        this.target = ldat;
        this.targetProp = ldat.getProperty(elementName);
        String targetName = this.getPathToParentType(this.target, BLonComponent.TYPE, true, "/");
        this.setTargetName(SlotPath.unescape((String)targetName));
        this.setElementName(SlotPath.unescape((String)elementName));
        this.setUnits(units);
        BIcon targetIcon = this.getTargetIcon();
        if (targetIcon != null) {
            this.add("icon", (BValue)targetIcon);
        }
        this.setTargetType(this.getTarget().getType().getTypeSpec());
        this.setTargetFacets(this.getFacets());
        this.setDefaultName(this.getDefaultProxyName());
        this.setTargetPathName(this.getDefaultTargetPathName());
        BLonComponent lonComponent = this.getLonComponent();
        if (lonComponent != null) {
            this.setIsTargetComponentWritable(lonComponent.isWriteable());
        }
    }

    private String getPathToParentType(BComponent tgt, Type baseTyp, boolean noDataInPath, String delimiter) {
        BComponent c = tgt;
        String path = "";
        boolean end = false;
        while (!end && !c.getType().is(BLonDevice.TYPE)) {
            if (!(noDataInPath && c.getName().equals("data") && c.getParent().getType().is(BLonComponent.TYPE))) {
                path = path.length() == 0 ? c.getName() : c.getName() + delimiter + path;
            }
            if (c.getType().is(baseTyp)) {
                end = true;
                continue;
            }
            c = (BComponent)c.getParent();
        }
        return path;
    }

    public BObject getTarget() {
        if (this.target.getType().is(BLonObject.TYPE)) {
            return this.target;
        }
        if (this.target.getType().is(BLonObjectFolder.TYPE)) {
            return this.target;
        }
        return this.target.get(this.getElementName());
    }

    public BLonComponent getLonComponent() {
        return CompUtil.closestAncestor((BComplex)this.target, BLonComponent.class).orElse(null);
    }

    public String getDefaultProxyName() {
        String n = this.getPathToParentType(this.target, BLonDevice.TYPE, true, "_");
        BComponent lonData = this.target;
        int cnt = 0;
        lonData = this.target;
        Property[] a = lonData.getPropertiesArray();
        for (int i = 0; i < a.length; ++i) {
            if (!BLonData.isDataProp(a[i])) continue;
            ++cnt;
        }
        if (cnt > 1) {
            n = n + "_" + this.getElementName();
        }
        return n;
    }

    private String getDefaultTargetPathName() {
        return this.getPathToParentType(this.target, BLonDevice.TYPE, false, "/");
    }

    public BFacets getFacets() {
        Type type = this.getTarget().getType();
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            return this.getFloatFacets();
        }
        if (type == BLonEnum.TYPE) {
            return this.getEnumFacets();
        }
        return BFacets.NULL;
    }

    private BFacets getFloatFacets() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BFacets f = this.targetProp.getFacets();
        BObject s = f.getFacet("units");
        if (s != null) {
            map.put("units", (BUnit)s);
        }
        map.put("precision", (s = f.getFacet("precision")) != null ? (BInteger)s : BInteger.make((int)2));
        s = f.getFacet("min");
        map.put("min", s != null ? (BNumber)s : BFloat.NEGATIVE_INFINITY);
        s = f.getFacet("max");
        map.put("max", s != null ? (BNumber)s : BFloat.POSITIVE_INFINITY);
        return BFacets.make(map);
    }

    private BFacets getEnumFacets() {
        BLonPrimitive p = (BLonPrimitive)this.target.get(this.targetProp);
        if (p.getType() == BLonEnum.TYPE) {
            BEnum e = ((BLonEnum)p).getEnum();
            return BFacets.makeEnum((BEnumRange)e.getRange());
        }
        return BFacets.makeEnum((BEnumRange)BEnumRange.DEFAULT);
    }

    public void setChildren(BLonCreationEntry[] children) {
        for (BLonCreationEntry child : children) {
            this.add(null, (BValue)child);
        }
    }

    private BIcon getTargetIcon() {
        if (this.target != null) {
            Type type = this.getTarget().getType();
            if (type.is(BLonObject.TYPE)) {
                return LonObjectIcon;
            }
            if (type.is(BLonObjectFolder.TYPE)) {
                return LonObjectFolderIcon;
            }
            if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
                return FloatElementIcon;
            }
            if (type == BLonBoolean.TYPE) {
                return BooleanElementIcon;
            }
            if (type == BLonEnum.TYPE) {
                return EnumElementIcon;
            }
            if (type == BLonString.TYPE || type == BLonByteArray.TYPE || type == BLonSimple.TYPE) {
                return StringElementIcon;
            }
        }
        return null;
    }
}

