/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.device;

import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.TimedCoalesceQueue;
import com.tridium.lonworks.xml.XDeviceFacets;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.Invocation;

public class DeviceFacets {
    private int delayToReset = 0;
    private int delayToHardOffline = 0;
    private int minNvUpdateInterMsgDelay = 0;
    private boolean disableSetOfflineInBind = false;
    private boolean disableToggleMode = false;
    private int nodeObjectIndex;
    private long lastNvWriteTime = 0L;
    private int delayCnt = 0;

    public static int getNodeObjectIndex(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.nodeObjectIndex;
        }
        return 0;
    }

    public static int getDelayToReset(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.delayToReset;
        }
        return 0;
    }

    public static void delayToReset(BLonDevice dev) {
        int delay = DeviceFacets.getDelayToReset(dev);
        if (delay > 0) {
            NmUtil.wait(delay);
        }
    }

    public static int getDelayToHardOffline(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.delayToHardOffline;
        }
        return 0;
    }

    public static void delayToHardOffline(BLonDevice dev) {
        int delay = DeviceFacets.getDelayToHardOffline(dev);
        if (delay > 0) {
            NmUtil.wait(delay);
        }
    }

    public static int getMinNvUpdateInterMsgDelay(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.minNvUpdateInterMsgDelay;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delayNvUpdate(BLonDevice dev, BNetworkVariable nv) {
        Object sync;
        DeviceFacets p = DeviceFacets.getPickle(dev);
        int minUpdateTime = p != null ? p.minNvUpdateInterMsgDelay : 0;
        int writeDelay = nv.getWriteDelay();
        if (minUpdateTime == 0 && writeDelay == 0) {
            return false;
        }
        Object object = sync = p != null ? p : nv;
        synchronized (object) {
            long delayedTime;
            long currentTime;
            long nextWriteTime = currentTime = Clock.ticks();
            if (p != null && minUpdateTime > 0) {
                nextWriteTime = p.lastNvWriteTime + (long)(minUpdateTime * (p.delayCnt + 1));
            }
            if (writeDelay > 0 && (delayedTime = currentTime + (long)writeDelay) > nextWriteTime) {
                nextWriteTime = delayedTime;
            }
            if (currentTime < nextWriteTime) {
                TimedCoalesceQueue q = (TimedCoalesceQueue)dev.lonNetwork().getTimedQueue().getTodo();
                TimedInvocation invoc = new TimedInvocation((BComponent)nv, BNetworkVariable.forceWrite, p, nextWriteTime);
                try {
                    if (q.enqueue(invoc) && p != null) {
                        ++p.delayCnt;
                    }
                    return true;
                }
                catch (Throwable e) {
                    System.out.println("in delayNvUpdate could not queue TimedInvocation " + e);
                }
            }
            if (p != null) {
                p.lastNvWriteTime = Clock.ticks();
            }
        }
        return false;
    }

    public static boolean disableToggleMode(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.disableToggleMode;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delayedWrite(BNetworkVariable nv, DeviceFacets p) {
        Object sync;
        Object object = sync = p != null ? p : nv;
        synchronized (object) {
            nv.doForceWrite();
            if (p != null) {
                --p.delayCnt;
                p.lastNvWriteTime = Clock.ticks();
            }
        }
    }

    public static boolean getDisableSetOfflineInBind(BLonDevice dev) {
        DeviceFacets p = DeviceFacets.getPickle(dev);
        if (p != null) {
            return p.disableSetOfflineInBind;
        }
        return false;
    }

    private static DeviceFacets getPickle(BLonDevice dev) {
        BDeviceData dd = dev.getDeviceData();
        BFacets f = dd.getFacets();
        if (BFacets.NULL == f) {
            return null;
        }
        Object o = dd.getPickle();
        if (o != null) {
            return (DeviceFacets)o;
        }
        DeviceFacets df = new DeviceFacets();
        df.delayToReset = f.geti("delayToReset", 0);
        df.delayToHardOffline = f.geti("delayToHardOffline", 0);
        df.minNvUpdateInterMsgDelay = f.geti("minNvUpdateInterMsgDelay", 0);
        df.disableSetOfflineInBind = f.getb("disableSetOfflineInBind", false);
        df.disableToggleMode = f.getb("disableToggleMode", false);
        df.nodeObjectIndex = f.geti("nodeObjectIndex", 0);
        dd.setPickle(df);
        return df;
    }

    public static void moveDeviceFacets(BLonDevice dev) {
        if (dev.getDeviceData().getFacets() != BFacets.NULL) {
            return;
        }
        Property prop = dev.getPropertyInParent();
        if (prop == null) {
            return;
        }
        BFacets f = prop.getFacets();
        if (f == BFacets.NULL) {
            return;
        }
        dev.getDeviceData().setFacets(f);
        ((BComponent)dev.getParent()).setFacets((Slot)dev.getPropertyInParent(), BFacets.NULL, null);
    }

    public static BFacets makeDeviceFacets(XDeviceFacets xdevFacets) {
        Array keyA = new Array(String.class);
        Array valueA = new Array(BIDataValue.class);
        if (xdevFacets.delayToReset > 0) {
            keyA.add((Object)"delayToReset");
            valueA.add((Object)BInteger.make((int)xdevFacets.delayToReset));
        }
        if (xdevFacets.delayToHardOffline > 0) {
            keyA.add((Object)"delayToHardOffline");
            valueA.add((Object)BInteger.make((int)xdevFacets.delayToHardOffline));
        }
        if (xdevFacets.minNvUpdateInterMsgDelay > 0) {
            keyA.add((Object)"minNvUpdateInterMsgDelay");
            valueA.add((Object)BInteger.make((int)xdevFacets.minNvUpdateInterMsgDelay));
        }
        if (xdevFacets.disableSetOfflineInBind) {
            keyA.add((Object)"disableSetOfflineInBind");
            valueA.add((Object)BBoolean.make((boolean)xdevFacets.disableSetOfflineInBind));
        }
        if (xdevFacets.disableToggleMode) {
            keyA.add((Object)"disableToggleMode");
            valueA.add((Object)BBoolean.make((boolean)xdevFacets.disableToggleMode));
        }
        if (xdevFacets.nodeObjectIndex > 0) {
            keyA.add((Object)"nodeObjectIndex");
            valueA.add((Object)BInteger.make((int)xdevFacets.nodeObjectIndex));
        }
        if (keyA.size() == 0) {
            return null;
        }
        String[] keys = (String[])keyA.trim();
        BIDataValue[] values = (BIDataValue[])valueA.trim();
        BFacets f = BFacets.make((String[])keys, (BIDataValue[])values);
        return f;
    }

    public static void spy(BLonDevice dev, SpyWriter out) throws Exception {
        DeviceFacets df = DeviceFacets.getPickle(dev);
        if (df == null) {
            return;
        }
        out.startProps("DeviceFacets");
        out.prop((Object)"DelayToReset", df.delayToReset);
        out.prop((Object)"DelayToHardOffline", df.delayToHardOffline);
        out.prop((Object)"MinNvUpdateInterMsgDelay", df.minNvUpdateInterMsgDelay);
        out.prop((Object)"DisableSetOfflineInBind", df.disableSetOfflineInBind);
        out.prop((Object)"disableToggleMode", df.disableToggleMode);
        out.prop((Object)"nodeObjectIndex", df.nodeObjectIndex);
        out.prop((Object)"ticks since last NvWrite", (Object)Long.toString(Clock.ticks() - df.lastNvWriteTime));
        out.prop((Object)"DelayCnt", df.delayCnt);
        out.endProps();
    }

    public static class TimedInvocation
    extends Invocation
    implements TimedCoalesceQueue.ITimed {
        DeviceFacets devFacets;
        long invocationTime;

        public TimedInvocation(BComponent instance, Action action, DeviceFacets df, long time) {
            super(instance, action, null, null);
            this.devFacets = df;
            this.invocationTime = time;
        }

        public void run() {
            DeviceFacets.delayedWrite((BNetworkVariable)this.instance, this.devFacets);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public long getTime() {
            return this.invocationTime;
        }

        public String getName() {
            return this.instance.getParent().getDisplayName(null) + ":" + this.instance.getDisplayName(null);
        }
    }
}

