/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.px.ui;

import com.tridium.mobile.px.ui.BBasicMobilePane;
import com.tridium.mobile.px.ui.BIMobilePane;
import java.util.ArrayList;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BPane;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="columnCount", type="int", defaultValue="2", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(1), BFacets.MAX, BInteger.make(maxColumnCount))")}), @NiagaraProperty(name="rowGap", type="double", defaultValue="8"), @NiagaraProperty(name="columnGap", type="double", defaultValue="8"), @NiagaraProperty(name="padding", type="BInsets", defaultValue="BInsets.DEFAULT"), @NiagaraProperty(name="shadow", type="boolean", defaultValue="false"), @NiagaraProperty(name="roundedCorners", type="boolean", defaultValue="false"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BBrush.NULL"), @NiagaraProperty(name="foreground", type="BBrush", defaultValue="BBrush.NULL")})
public final class BMobileGridPane
extends BPane
implements BIMobilePane {
    public static final int maxColumnCount = 5;
    @Generated
    public static final Property columnCount = BMobileGridPane.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)5)));
    @Generated
    public static final Property rowGap = BMobileGridPane.newProperty((int)0, (int)8, null);
    @Generated
    public static final Property columnGap = BMobileGridPane.newProperty((int)0, (int)8, null);
    @Generated
    public static final Property padding = BMobileGridPane.newProperty((int)0, (BValue)BInsets.DEFAULT, null);
    @Generated
    public static final Property shadow = BMobileGridPane.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property roundedCorners = BMobileGridPane.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property background = BMobileGridPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Property foreground = BMobileGridPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMobileGridPane.class);

    @Generated
    public int getColumnCount() {
        return this.getInt(columnCount);
    }

    @Generated
    public void setColumnCount(int v) {
        this.setInt(columnCount, v, null);
    }

    @Generated
    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    @Generated
    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    @Generated
    public double getColumnGap() {
        return this.getDouble(columnGap);
    }

    @Generated
    public void setColumnGap(double v) {
        this.setDouble(columnGap, v, null);
    }

    @Generated
    public BInsets getPadding() {
        return (BInsets)this.get(padding);
    }

    @Generated
    public void setPadding(BInsets v) {
        this.set(padding, (BValue)v, null);
    }

    @Generated
    public boolean getShadow() {
        return this.getBoolean(shadow);
    }

    @Generated
    public void setShadow(boolean v) {
        this.setBoolean(shadow, v, null);
    }

    @Generated
    public boolean getRoundedCorners() {
        return this.getBoolean(roundedCorners);
    }

    @Generated
    public void setRoundedCorners(boolean v) {
        this.setBoolean(roundedCorners, v, null);
    }

    @Generated
    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    @Generated
    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    @Generated
    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    @Generated
    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMobileGridPane() {
    }

    public BMobileGridPane(int colCount) {
        this.setColumnCount(colCount);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BBasicMobilePane || parent instanceof BMobileGridPane || parent instanceof BWidgetShell;
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        BWidget[] kids = this.getChildWidgets();
        int colCount = this.getColumnCount();
        int count = 0;
        double rh = 50.0;
        double rw = 0.0;
        boolean firstRow = true;
        double rg = this.getRowGap();
        double cg = this.getColumnGap();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isVisible()) continue;
            kids[i].computePreferredSize();
            rw += kids[i].getPreferredWidth() + cg;
            rh = Math.max(kids[i].getPreferredHeight(), rh);
            if (++count != colCount) continue;
            count = 0;
            if (!firstRow) {
                rh += rg;
            }
            ph += rh;
            pw = Math.max(rw, pw);
            rh = 50.0;
            rw = 0.0;
            firstRow = false;
        }
        if (rh > 0.0 && rw > 0.0) {
            if (!firstRow) {
                rh += rg;
            }
            ph += rh;
            pw = Math.max(rw, pw);
        }
        BInsets padding = this.getPadding();
        pw += padding.left + padding.right;
        ph += padding.top + padding.bottom;
        pw = Math.max(pw, 10.0);
        ph = Math.max(ph, 10.0);
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        int colCount = this.getColumnCount();
        int count = 0;
        ArrayList rows = new ArrayList();
        List r = new ArrayList<BWidget>();
        ArrayList<BWidget> firstRow = r;
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isVisible()) continue;
            r.add(kids[i]);
            if (++count != colCount) continue;
            count = 0;
            rows.add(r);
            r = new ArrayList();
        }
        if (r.size() > 0) {
            rows.add(r);
        }
        double rg = this.getRowGap();
        double cg = this.getColumnGap();
        BInsets padding = this.getPadding();
        double width = Math.abs(this.getWidth() - padding.left - padding.right);
        double y = padding.top;
        double cellw = (width + cg) / (double)firstRow.size();
        for (int i = 0; i < rows.size(); ++i) {
            r = (List)rows.get(i);
            double maxh = 50.0;
            for (int j = 0; j < r.size(); ++j) {
                maxh = Math.max(maxh, ((BWidget)r.get(j)).getPreferredHeight());
            }
            double x = padding.left - cg;
            double w = cellw;
            for (int k = 0; k < r.size(); ++k) {
                ((BWidget)r.get(k)).setBounds(Math.max(x + cg, padding.left), y, Math.max(w - cg, 0.0), maxh);
                x += cellw;
            }
            y += maxh + rg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        try {
            double width = this.getWidth();
            double height = this.getHeight();
            g.push();
            g.setBrush(this.getBackground());
            g.fillRect(0.0, 0.0, width, height);
            g.setBrush(this.getForeground());
            g.strokeRect(0.0, 0.0, width - 1.0, height - 1.0);
        }
        finally {
            g.pop();
        }
        this.paintChildren(g);
    }
}

