/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mobile.px.ui;

import com.tridium.mobile.px.ui.BIMobilePane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BPane;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scrollBar", type="BWidget", defaultValue="new BNullWidget()", flags=7), @NiagaraProperty(name="rowGap", type="double", defaultValue="16"), @NiagaraProperty(name="padding", type="BInsets", defaultValue="BInsets.make(15,15,15,15)")})
@NiagaraAction(name="vscroll", parameterType="BScrollEvent", defaultValue="new BScrollEvent()")
public final class BBasicMobilePane
extends BPane
implements BIMobilePane {
    @Generated
    public static final Property scrollBar = BBasicMobilePane.newProperty((int)7, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property rowGap = BBasicMobilePane.newProperty((int)0, (int)16, null);
    @Generated
    public static final Property padding = BBasicMobilePane.newProperty((int)0, (BValue)BInsets.make((double)15.0, (double)15.0, (double)15.0, (double)15.0), null);
    @Generated
    public static final Action vscroll = BBasicMobilePane.newAction((int)0, (BValue)new BScrollEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBasicMobilePane.class);
    private double yoff = 0.0;
    private static final double ipad = 18.0;
    static final double minHeight = 50.0;

    @Generated
    public BWidget getScrollBar() {
        return (BWidget)this.get(scrollBar);
    }

    @Generated
    public void setScrollBar(BWidget v) {
        this.set(scrollBar, (BValue)v, null);
    }

    @Generated
    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    @Generated
    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    @Generated
    public BInsets getPadding() {
        return (BInsets)this.get(padding);
    }

    @Generated
    public void setPadding(BInsets v) {
        this.set(padding, (BValue)v, null);
    }

    @Generated
    public void vscroll(BScrollEvent parameter) {
        this.invoke(vscroll, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBasicMobilePane() {
        BScrollBar sb = new BScrollBar();
        sb.setUnitIncrement(25);
        this.linkTo((BComponent)sb, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
        this.setScrollBar((BWidget)sb);
    }

    public void computePreferredSize() {
        double pw = 200.0;
        double ph = 36.0;
        double rg = this.getRowGap();
        BWidget[] kids = this.getChildWidgets();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isVisible()) continue;
            kids[i].computePreferredSize();
            pw = Math.max(pw, kids[i].getPreferredWidth());
            ph += Math.max(50.0, kids[i].getPreferredHeight());
            if (i <= 0) continue;
            ph += rg;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        BInsets opad = this.getPadding();
        double w = this.getWidth();
        double h = this.getHeight();
        this.computePreferredSize();
        double ph = this.getPreferredHeight();
        if (!this.getScrollBar().isNull()) {
            BScrollBar sb = (BScrollBar)this.getScrollBar();
            sb.computePreferredSize();
            double sbpw = sb.getPreferredWidth();
            sb.setBounds(w - sbpw, 0.0, sbpw, h);
            w -= sbpw;
            sb.setMin(0);
            sb.setMax((int)ph);
            sb.setExtent((int)Math.min(ph, h));
            if ((double)sb.getPosition() > ph - (double)sb.getExtent()) {
                this.yoff = ph - (double)sb.getExtent();
                sb.setPosition((int)this.yoff);
            } else {
                this.yoff = sb.getPosition();
            }
        }
        double cx = opad.left();
        double cy = opad.top();
        double ch = h - (opad.top() + opad.bottom());
        double cw = w - (opad.left() + opad.right());
        double hh = 0.0;
        double fh = 0.0;
        if (hh > 0.0) {
            cy += hh + 18.0;
            ch -= hh + 18.0;
        }
        if (fh > 0.0) {
            ch -= fh + 18.0;
        }
        this.layoutContent(cx, cy, cw, ch);
    }

    private void layoutContent(double cx, double cy, double cw, double ch) {
        double rg = this.getRowGap();
        BWidget[] kids = this.getChildWidgets();
        for (int i = 1; i < kids.length; ++i) {
            if (!kids[i].isVisible()) continue;
            BWidget w = kids[i];
            w.computePreferredSize();
            double ph = Math.max(50.0, w.getPreferredHeight());
            w.setBounds(cx, cy, cw, ph);
            cy += ph + rg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        this.paintBackground(g);
        BWidget sb = this.getScrollBar();
        if (!sb.isNull()) {
            this.paintChild(g, sb);
        }
        g.push();
        try {
            g.translate(0.0, -this.yoff);
            BWidget[] w = this.getChildWidgets();
            for (int i = 0; i < w.length; ++i) {
                if (!w[i].isVisible() || w[i] == sb) continue;
                this.paintChild(g, w[i]);
            }
        }
        finally {
            g.pop();
        }
        this.paintBorder(g);
    }

    private void paintBackground(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, 0.0, w, h);
    }

    private void paintBorder(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
    }

    public BWidget childAt(Point pt) {
        BScrollBar sb = (BScrollBar)this.getScrollBar();
        if (sb.contains(pt.x - sb.getX(), pt.y - sb.getY())) {
            return sb;
        }
        return super.childAt(new Point(pt.x, pt.y + this.yoff));
    }

    public Point translateToChild(BWidget child, Point pt) {
        if (child != this.getScrollBar()) {
            pt.translate(0.0, this.yoff);
        }
        return super.translateToChild(child, pt);
    }

    public void mouseWheel(BMouseWheelEvent event) {
        BScrollBar sb = (BScrollBar)this.getScrollBar();
        sb.scrollByUnits(event.getPreciseWheelRotation());
        event.consume();
    }

    public void doVscroll(BScrollEvent event) {
        this.yoff = event.getPosition();
        this.repaint();
    }
}

