/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.baja.file.BajaFileUtil;
import javax.baja.migration.BFileMigrator;
import javax.baja.migration.BIFileMigrator;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class MigratorRegistry {
    private static final Logger LOG = Logger.getLogger("migration.registry");
    private static final Lexicon LEX = Lexicon.make((String)"migration");
    private static final String MIGRATOR_PROP_FILE = "migrator.properties";
    private static boolean initialized = false;
    private static Map<String, TypeInfo> migratorsByDirName = new HashMap<String, TypeInfo>();
    private static Map<String, TypeInfo> migratorsByFile = new HashMap<String, TypeInfo>();
    private static Map<String, TypeInfo> migratorsByPattern = new HashMap<String, TypeInfo>();
    private static Map<String, TypeInfo> migratorsByExt = new HashMap<String, TypeInfo>();

    public static void initialize() {
        File userHomeEtcDir = new File(Sys.getNiagaraUserHome(), "etc");
        File propsFile = new File(userHomeEtcDir, MIGRATOR_PROP_FILE);
        try (FileInputStream inStrm = new FileInputStream(propsFile);){
            MigratorRegistry.initialize(inStrm);
        }
        catch (FileNotFoundException eNotFoundExpt) {
            Object[] args = new Object[]{propsFile.getAbsolutePath()};
            LOG.info(LEX.getText("migrator.properties.find", args));
            MigratorRegistry.initialize(null);
        }
        catch (IOException eIOExpt) {
            Object[] args = new Object[]{eIOExpt.getLocalizedMessage()};
            LOG.warning(LEX.getText("migrator.properties.close", args));
        }
    }

    public static void initialize(InputStream inputStream) {
        BIFileMigrator migrator;
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BIFileMigrator.TYPE.getTypeInfo());
        Properties migratorProps = null;
        migratorsByDirName.clear();
        migratorsByFile.clear();
        migratorsByPattern.clear();
        migratorsByExt.clear();
        if (inputStream != null) {
            try {
                migratorProps = new Properties();
                migratorProps.load(inputStream);
            }
            catch (IOException eIOExpt) {
                LOG.severe(LEX.getText("migrator.properties.read"));
            }
        }
        for (TypeInfo typeInfo : types) {
            migrator = (BIFileMigrator)typeInfo.getInstance();
            String[] migrateFiles = MigratorRegistry.getPatterns(migratorProps, typeInfo.getTypeName() + ".files");
            if (migrateFiles == null && ((migrateFiles = migrator.getMigrateFiles()) == null || migrateFiles.length == 0)) continue;
            for (String targetFile : migrateFiles) {
                if (migratorsByFile.containsKey(targetFile)) {
                    LOG.severe("Attempt to register duplicate Migrator " + migrator.getType() + " for target filename " + targetFile + "; already registered by " + migratorsByFile.get(targetFile).getTypeName());
                    continue;
                }
                migratorsByFile.put(targetFile, typeInfo);
            }
        }
        for (TypeInfo typeInfo : types) {
            migrator = (BIFileMigrator)typeInfo.getInstance();
            String[] migratePatterns = MigratorRegistry.getPatterns(migratorProps, typeInfo.getTypeName() + ".patterns");
            if (migratePatterns == null && ((migratePatterns = migrator.getMigratePatterns()) == null || migratePatterns.length == 0)) continue;
            for (String targetPattern : migratePatterns) {
                if (migratorsByPattern.containsKey(targetPattern)) {
                    LOG.severe("Attempt to register duplicate Migrator " + migrator.getType() + " for target pattern " + targetPattern + "; already registered by " + migratorsByPattern.get(targetPattern).getTypeName());
                    continue;
                }
                migratorsByPattern.put(targetPattern, typeInfo);
            }
        }
        for (TypeInfo typeInfo : types) {
            migrator = (BIFileMigrator)typeInfo.getInstance();
            String[] migrateExts = MigratorRegistry.getPatterns(migratorProps, typeInfo.getTypeName() + ".extensions");
            if (migrateExts == null && ((migrateExts = migrator.getMigrateTypes()) == null || migrateExts.length == 0)) continue;
            for (String targetType : migrateExts) {
                if (migratorsByExt.containsKey(targetType)) {
                    LOG.severe("Attempt to register duplicate Migrator " + migrator.getType() + " for target file type " + targetType + "; already registered by " + migratorsByExt.get(targetType).getTypeName());
                    continue;
                }
                migratorsByExt.put(targetType, typeInfo);
            }
        }
        for (TypeInfo typeInfo : types) {
            migrator = (BIFileMigrator)typeInfo.getInstance();
            String[] migrateDirs = MigratorRegistry.getPatterns(migratorProps, typeInfo.getTypeName() + ".directories");
            if (migrateDirs == null && ((migrateDirs = migrator.getMigrateDirs()) == null || migrateDirs.length == 0)) continue;
            for (String targetDir : migrateDirs) {
                if (migratorsByDirName.containsKey(targetDir)) {
                    LOG.severe("Attempt to register duplicate Migrator " + migrator.getType() + " for target directory name " + targetDir + "; already registered by " + migratorsByDirName.get(targetDir).getTypeName());
                    continue;
                }
                migratorsByDirName.put(targetDir, typeInfo);
            }
        }
        initialized = true;
    }

    public static BIFileMigrator lookup(File f) {
        if (!initialized) {
            MigratorRegistry.initialize();
        }
        String filename = f.getName();
        BIFileMigrator migrator = null;
        if (f.isDirectory()) {
            TypeInfo ti = migratorsByDirName.get(filename);
            return ti != null ? (BIFileMigrator)ti.getInstance() : null;
        }
        TypeInfo ti = migratorsByFile.get(filename);
        if (ti != null) {
            migrator = (BIFileMigrator)ti.getInstance();
        }
        if (migrator == null) {
            for (String key : migratorsByPattern.keySet()) {
                if (!filename.matches(key)) continue;
                migrator = (BIFileMigrator)migratorsByPattern.get(key).getInstance();
            }
        }
        if (migrator == null) {
            String ext = BajaFileUtil.getExtension((String)filename);
            for (String key : migratorsByExt.keySet()) {
                if (!key.equals(ext)) continue;
                migrator = (BIFileMigrator)migratorsByExt.get(key).getInstance();
            }
        }
        if (migrator == null) {
            migrator = new BFileMigrator();
        }
        return migrator;
    }

    static String[] getPatterns(Properties properties, String propertyName) {
        if (properties == null) {
            return null;
        }
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || propertyValue.isEmpty()) {
            return null;
        }
        String[] patterns = propertyValue.split("\\s*,\\s*");
        LinkedList<String> tmpList = new LinkedList<String>(Arrays.asList(patterns));
        tmpList.removeIf(p -> p.isEmpty());
        patterns = tmpList.toArray(new String[0]);
        return patterns.length == 0 ? null : patterns;
    }

    public static void main(String ... args) {
        if (args.length == 0) {
            MigratorRegistry.initialize();
            System.out.println("\nRegistered Migrators by Filename");
            for (String filename : migratorsByFile.keySet()) {
                System.out.println(filename + "\t" + migratorsByFile.get(filename));
            }
            System.out.println("\nRegistered Migrators by Pattern");
            for (String filename : migratorsByPattern.keySet()) {
                System.out.println(filename + "\t" + migratorsByPattern.get(filename));
            }
            System.out.println("\nRegistered Migrators by Extension");
            for (String filename : migratorsByExt.keySet()) {
                System.out.println(filename + "\t" + migratorsByExt.get(filename));
            }
            System.out.println("\nRegistered Migrators by Directory");
            for (String filename : migratorsByDirName.keySet()) {
                System.out.println(filename + "\t" + migratorsByDirName.get(filename));
            }
        } else {
            for (String s : args) {
                File f = new File(s);
                BIFileMigrator migrator = MigratorRegistry.lookup(f);
                System.out.println("Filename: " + s + " -> Migrator: " + migrator);
            }
        }
    }
}

