/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table.view;

import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.table.view.BTableView;
import javax.baja.hx.table.view.CompTableViewCol;
import javax.baja.hx.table.view.CompTableViewModel;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class CompTableViewCommands {
    static String lex(String key, Context cx) {
        return Lexicon.make((String)"hx", (Context)cx).getText(key);
    }

    public static class Delete
    extends Command {
        public Delete(BTableView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return CompTableViewCommands.lex("delete", (Context)op);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BTableView view = (BTableView)this.getView();
            CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
            BComponent parent = op.get().asComponent();
            HtmlWriter out = op.getHtmlWriter();
            String[] ids = model.getSelectedRowIds(op);
            if (ids.length == 0) {
                out.w((Object)"alert('").safe((Object)CompTableViewCommands.lex("tableView.noRowsSelected", (Context)op)).w((Object)"');");
            } else {
                BComponent row;
                int i;
                BComponent[] rows = new BComponent[ids.length];
                for (i = 0; i < rows.length; ++i) {
                    row = (BComponent)model.fromRowId(ids[i], op);
                    op.getUser().checkWrite(row.getParentComponent(), (Slot)row.getParentComponent().getPropertyInParent());
                }
                for (i = 0; i < ids.length; ++i) {
                    row = (BComponent)model.fromRowId(ids[i], op);
                    parent.remove(row.getPropertyInParent());
                }
                this.refresh(op);
            }
        }
    }

    static class EditDialog
    extends Dialog {
        public EditDialog(Command handler) {
            super(LexiconText.make((String)"hx", (String)"edit"), handler);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            BTableView view = (BTableView)this.getHandler().getView();
            CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
            CompTableViewCol[] cols = model.getEditableColumns();
            String[] ids = model.getSelectedRowIds(op);
            BComponent[] rows = new BComponent[ids.length];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = (BComponent)model.fromRowId(ids[i], op);
            }
            HxOp rowOp = op.make("row", new OrdTarget((OrdTarget)op, (BObject)rows[0]));
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            for (int i = 0; i < cols.length; ++i) {
                CompTableViewCol col = cols[i];
                BHxFieldEditor editor = col.getEditor(rows);
                BValue val = (BValue)col.get(rows[0]);
                out.w((Object)"<tr>");
                if (rows.length > 1) {
                    out.w((Object)"<td style='padding:0; margin:0;'>");
                    if (editor == null) {
                        out.w((Object)"&nbsp;");
                    } else {
                        out.w((Object)"<input type='checkbox' onclick='tableView.selectEditor(event);'");
                        out.w((Object)"name='").w((Object)op.scope("_fieldEditorEnable" + i)).w((Object)"'").w((Object)"/>");
                    }
                    out.w((Object)"</td>");
                }
                out.w((Object)"<td style='padding-right:5px;'>");
                out.w((Object)"<b>").safe((Object)col.getDisplayName((Context)op)).w((Object)"</b>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                if (editor == null) {
                    out.safe((Object)CompTableViewCommands.lex("cannotEdit", (Context)op));
                } else {
                    HxOp editOp = rowOp.make("col" + i, new OrdTarget((OrdTarget)rowOp, (BObject)val));
                    if (rows.length > 1) {
                        editOp.setReadonly(true);
                    }
                    editor.write(editOp);
                }
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            out.w((Object)"</table>");
        }
    }

    public static class Edit
    extends Command {
        private EditDialog dlg = new EditDialog(this);

        public Edit(BTableView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return CompTableViewCommands.lex("edit", (Context)op);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BTableView view = (BTableView)this.getView();
            CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
            String[] ids = model.getSelectedRowIds(op);
            if (ids.length == 0) {
                out.w((Object)"alert('").safe((Object)CompTableViewCommands.lex("tableView.noRowsSelected", (Context)op)).w((Object)"');");
            } else {
                BComponent[] rows = new BComponent[ids.length];
                for (int i = 0; i < rows.length; ++i) {
                    BComponent row = (BComponent)model.fromRowId(ids[i], op);
                    op.getUser().checkWrite(row.getParentComponent(), (Slot)row.getParentComponent().getPropertyInParent());
                }
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                } else {
                    CompTableViewCol[] cols = model.getEditableColumns();
                    for (int i = 0; i < rows.length; ++i) {
                        rows[i] = (BComponent)model.fromRowId(ids[i], op);
                    }
                    HxOp rowOp = op.make("row", new OrdTarget((OrdTarget)op, (BObject)rows[0]));
                    for (int i = 0; i < cols.length; ++i) {
                        String checked;
                        CompTableViewCol col = cols[i];
                        BHxFieldEditor editor = col.getEditor(rows);
                        if (editor == null || rows.length > 1 && (checked = op.getFormValue("_fieldEditorEnable" + i)) == null) continue;
                        BValue val = (BValue)col.get(rows[0]);
                        val = (BValue)editor.fwSave(rowOp.make("col" + i, new OrdTarget((OrdTarget)rowOp, (BObject)val)));
                        col.save(rows, val, (Context)op);
                    }
                    this.refresh(op);
                }
            }
        }
    }

    static class CompleteNewDialog
    extends Dialog {
        public CompleteNewDialog(Command handler) {
            super(LexiconText.make((String)"hx", (String)"new"), handler);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            BTableView view = (BTableView)this.getHandler().getView();
            CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
            CompTableViewCol[] cols = model.getEditableColumns();
            Type[] newTypes = model.getNewTypes();
            int index = Integer.parseInt(op.getFormValue("type"));
            BComponent[] rows = new BComponent[]{model.newInstance(newTypes[index])};
            HxOp rowOp = op.make("row", new OrdTarget((OrdTarget)op, (BObject)rows[0]));
            HtmlWriter out = op.getHtmlWriter();
            HxUtil.writeFormValue("step", "2", op);
            HxUtil.persistFormValue("type", op);
            HxUtil.persistFormValue("num", op);
            out.w((Object)"<table>");
            for (int i = 0; i < cols.length; ++i) {
                CompTableViewCol col = cols[i];
                BHxFieldEditor editor = col.getEditor(rows);
                BValue val = (BValue)col.get(rows[0]);
                out.w((Object)"<tr>");
                out.w((Object)"<td style='padding-right:5px;'>");
                out.w((Object)"<b>").safe((Object)col.getDisplayName((Context)op)).w((Object)"</b>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                if (editor == null) {
                    out.safe((Object)CompTableViewCommands.lex("cannotEdit", (Context)op));
                } else {
                    HxOp editOp = rowOp.make("col" + i, new OrdTarget((OrdTarget)rowOp, (BObject)val));
                    if (rows.length > 1) {
                        editOp.setReadonly(true);
                    }
                    editor.write(editOp);
                }
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            out.w((Object)"</table>");
        }
    }

    static class NewDialog
    extends Dialog {
        public NewDialog(Command handler) {
            super(LexiconText.make((String)"hx", (String)"new"), handler);
        }

        @Override
        protected void writeContent(HxOp op) throws Exception {
            BTableView view = (BTableView)this.getHandler().getView();
            CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
            HxUtil.writeFormValue("step", "1", op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr>");
            out.w((Object)" <td><b>").safe((Object)CompTableViewCommands.lex("typeToAdd", (Context)op)).w((Object)"</b>&nbsp;</td>");
            out.w((Object)" <td><select name='").w((Object)op.scope("type")).w((Object)"'>");
            Type[] newTypes = model.getNewTypes();
            for (int i = 0; i < newTypes.length; ++i) {
                out.w((Object)"<option value='").w(i).w((Object)"'>");
                out.safe((Object)newTypes[i].getDisplayName((Context)op)).w((Object)"</option>");
            }
            out.w((Object)" </select>");
            out.w((Object)" </td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)" <td><b>").safe((Object)CompTableViewCommands.lex("numberToAdd", (Context)op)).w((Object)"</b> </td>");
            out.w((Object)" <td><input name='").w((Object)op.scope("num"));
            out.w((Object)"' type='text' size='5' value='1' /></td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    public static class New
    extends Command {
        private NewDialog dlg = new NewDialog(this);
        private CompleteNewDialog completeDlg = new CompleteNewDialog(this);

        public New(BTableView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            return CompTableViewCommands.lex("new", (Context)op);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            String step = op.getFormValue("step");
            if (step == null && !this.dlg.isSubmit(op)) {
                this.dlg.open(op);
            } else if ("1".equals(step)) {
                this.completeDlg.open(op);
            } else if ("2".equals(step)) {
                BComponent c = op.get().asComponent();
                BTableView view = (BTableView)this.getView();
                CompTableViewModel model = (CompTableViewModel)view.makeModel(op);
                Type[] newTypes = model.getNewTypes();
                int index = Integer.parseInt(op.getFormValue("type"));
                int num = Integer.parseInt(op.getFormValue("num"));
                BComponent[] rows = new BComponent[]{model.newInstance(newTypes[index])};
                String name = rows[0].getType().getDisplayName((Context)op);
                HxOp rowOp = op.make("row", new OrdTarget((OrdTarget)op, (BObject)rows[0]));
                CompTableViewCol[] cols = model.getEditableColumns();
                for (int j = 0; j < cols.length; ++j) {
                    CompTableViewCol col = cols[j];
                    BHxFieldEditor editor = col.getEditor(rows);
                    if (editor == null) continue;
                    BValue val = (BValue)col.get(rows[0]);
                    val = (BValue)editor.fwSave(rowOp.make("col" + j, new OrdTarget((OrdTarget)rowOp, (BObject)val)));
                    if (col instanceof CompTableViewCol.Name) {
                        name = val.toString();
                        continue;
                    }
                    col.save(rows, val, (Context)op);
                }
                for (int i = 0; i < num; ++i) {
                    c.add(name + "?", rows[0].newCopy(true), (Context)op);
                }
                this.refresh(op);
            }
        }
    }
}

