/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx.table;

import javax.baja.hx.HxOp;
import javax.baja.hx.table.TableModel;
import javax.baja.hx.table.TableRenderer;
import javax.baja.io.HtmlWriter;

public class Table {
    protected TableModel model;
    protected TableRenderer renderer = new TableRenderer();
    private boolean headerVisible = true;
    private String width = "100%";
    private boolean hgridVisible = true;
    private boolean vgridVisible = true;

    public Table(TableModel model) {
        this.model = model;
    }

    public TableRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TableRenderer r) {
        this.renderer = r;
    }

    public boolean getHeaderVisible() {
        return this.headerVisible;
    }

    public void setHeaderVisible(boolean v) {
        this.headerVisible = v;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void write(HxOp op) throws Exception {
        this.renderer.setModel(this.model);
        int groupCount = this.model.getGroupCount();
        int colCount = this.model.getColumnCount();
        boolean showGroups = this.model.getGroupHeaderVisible();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table width='100%' cellspacing='0' cellpadding='0'>");
        if (this.headerVisible) {
            out.w((Object)"<tr>");
            for (int col = 0; col < colCount; ++col) {
                this.renderer.writeHeader(col, op);
            }
            out.w((Object)"</tr>");
        }
        for (int group = 0; group < groupCount; ++group) {
            if (showGroups) {
                out.w((Object)"<tr>");
                this.renderer.writeGroup(group, op);
                out.w((Object)"</tr>");
            }
            int rowCount = this.model.getRowCount(group);
            for (int row = 0; row < rowCount; ++row) {
                out.w((Object)"<tr>");
                for (int col = 0; col < colCount; ++col) {
                    this.renderer.writeCell(group, row, col, op);
                }
                out.w((Object)"</tr>");
            }
        }
        out.w((Object)"</table>");
    }
}

