/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hx;

import com.tridium.web.WebUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxProfile;
import javax.baja.hx.HxUtil;
import javax.baja.hx.MultiPartForm;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.WebDev;
import javax.baja.web.WebOp;
import javax.baja.web.hx.BIHxProfile;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.owasp.encoder.Encode;

public class HxOp
extends WebOp {
    private BComplex delegate = null;
    private HashMap<String, BValue> config = null;
    private boolean readonly = false;
    private String path = "";
    private String[] keys = null;
    private HxDocument document;
    protected boolean mounted = true;
    private static final WebDev bindRcWebDev = WebDev.get((String)"bindResources");
    private static final Logger LOGGER = Logger.getLogger("hx");

    public HxOp make(OrdTarget base) {
        return this.make(this.getUniqueName(base), base);
    }

    public HxOp make(String name, OrdTarget base) {
        HxOp newOp = new HxOp(name, base, this);
        newOp.mounted = this.mounted;
        return newOp;
    }

    public HxOp make(String name, BObject def, BFacets facets) {
        HxOp sub = this.make(name, new OrdTarget((OrdTarget)this, def));
        sub.mergeFacets(facets);
        sub.mounted = false;
        return sub;
    }

    protected HxOp(String name, OrdTarget base, HxOp op) {
        super(base, op.getService(), op.getRequest(), op.getResponse());
        this.document = op.document;
        this.path = op.path;
        if (op.path.length() > 0) {
            this.path = this.path + ".";
        }
        this.path = this.path + name;
    }

    public HxOp(WebOp op) throws Exception {
        this(op, true);
    }

    HxOp(WebOp op, boolean initializeDocument) throws Exception {
        super((OrdTarget)op.getBase(), op.getService(), op.getRequest(), op.getResponse());
        String contentType;
        this.document = new HxDocument(op);
        if (!initializeDocument) {
            return;
        }
        this.document.init();
        if (op.getRequest().getMethod().equals("POST") && (contentType = op.getRequest().getContentType()) != null) {
            if (contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data")) {
                if (contentType.startsWith("multipart/form-data")) {
                    this.setMultiPartForm();
                } else {
                    this.loadPostBody();
                }
                this.document.formPost = true;
                this.decodeFormValues();
            } else if (contentType.startsWith("application/x-niagara-hx-update")) {
                this.loadPostBody();
                this.document.update = true;
            } else if (contentType.startsWith("application/x-niagara-hx-bux")) {
                this.loadPostBody();
                this.document.form = new HashMap<String, String>();
            } else {
                this.loadPostBody();
            }
        }
    }

    public BWebProfileConfig getProfileConfig(Context cx) {
        BFacets facets = BIHxProfile.PREFER_HX_FACETS;
        if (cx != null && cx.getFacets() != null) {
            facets = BFacets.make((BFacets)facets, (BFacets)cx.getFacets());
        }
        return super.getProfileConfig((Context)facets);
    }

    public BWebProfileConfig getProfileConfig() {
        return super.getProfileConfig((Context)BIHxProfile.PREFER_HX_FACETS);
    }

    void loadPostBody() throws Exception {
        WebOp c = this.getWebOp();
        byte[] buf = new byte[c.getRequest().getContentLength()];
        DataInputStream in = new DataInputStream((InputStream)c.getRequest().getInputStream());
        in.readFully(buf);
        this.document.postBody = new String(buf);
    }

    public BHxProfile getProfile() {
        return this.document.profile;
    }

    public WebOp getWebOp() {
        return this.document.webop;
    }

    public String getPath() {
        return this.path;
    }

    public HxOp mergeFacets(BFacets newFacets) {
        return (HxOp)super.mergeFacets(newFacets);
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isMultiPartForm() {
        return this.document.multiPart;
    }

    public void setMultiPartForm() {
        this.document.multiPart = true;
    }

    public Lexicon getLexicon(String module) {
        Lexicon lex = this.document.lexicons.get(module);
        if (lex == null) {
            lex = Lexicon.make((String)module, (Context)this);
            this.document.lexicons.put(module, lex);
        }
        return lex;
    }

    public void addCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        this.getResponse().addCookie(cookie);
    }

    public String getCookie(String name) {
        Cookie[] cookies = this.getRequest().getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public void removeCookie(String name) {
        Cookie c = new Cookie(name, "");
        c.setPath("/");
        c.setMaxAge(0);
        this.getResponse().addCookie(c);
    }

    public Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    public String[] getAttributeNames() {
        ArrayList s = new ArrayList();
        Enumeration e = this.getRequest().getAttributeNames();
        while (e.hasMoreElements()) {
            s.add(e.nextElement());
        }
        return s.toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    public BValue getConfig(String name, BValue def) {
        BValue v;
        if (this.config != null && (v = this.config.get(name)) != null) {
            return v;
        }
        if (this.delegate != null && (v = this.delegate.get(name)) != null) {
            return v;
        }
        return def;
    }

    public void setConfig(String name, BValue value) {
        if (this.config == null) {
            this.config = new HashMap();
        }
        this.config.put(name, value);
    }

    public void setConfig(BComplex complex) {
        this.delegate = complex;
    }

    public StringBuffer getContent() {
        return this.document.content.getBuffer();
    }

    public PrintWriter getWriter() throws IOException {
        return this.document.writerStack.peek();
    }

    public PrintWriter setWriter(PrintWriter writer) throws IOException {
        return this.document.writerStack.push(writer);
    }

    public void resetWriter() throws IOException {
        if (this.document.writerStack.size() > 1) {
            this.document.writerStack.pop();
        }
    }

    public boolean isDynamic() {
        return this.document.dynamic;
    }

    public void setDynamic() {
        this.document.dynamic = true;
    }

    public boolean isRaw() {
        return this.document.raw;
    }

    public void setRaw() {
        this.document.raw = true;
    }

    public String scope(String s) {
        if (this.path.length() == 0) {
            return s;
        }
        return this.path + "." + s;
    }

    public String getUniqueName() {
        return "uid" + this.document.id++;
    }

    public String getUniqueName(OrdTarget target) {
        if (target == null || !(target.get() instanceof BComplex)) {
            return this.getUniqueName();
        }
        return ((BComplex)target.get()).getName();
    }

    public void addHeadTag(String tag) {
        if (!this.document.htags.contains(tag)) {
            this.document.htags.add(tag);
        }
    }

    public String[] getHeadTags() {
        return this.document.htags.toArray(new String[0]);
    }

    @Deprecated
    public void addStyleSheet(String url) {
        BOrd ord = BOrd.make((String)url);
        this.addStyleSheet(ord);
    }

    public void addStyleSheet(BOrd ord) {
        if (!this.document.styles.contains(ord)) {
            this.document.styles.add(ord);
            if (!this.getRequest().getMethod().toLowerCase().equals("get")) {
                this.addOnload("hx.addStyleSheet('" + WebUtil.toUri((OrdTarget)this, (HttpServletRequest)this.getRequest(), (BOrd)ord) + "');");
            }
        }
    }

    @Deprecated
    public String[] getStyleSheets() {
        String[] styles = new String[this.document.styles.size()];
        for (int i = 0; i < this.document.styles.size(); ++i) {
            styles[i] = this.document.styles.get(i).toString();
        }
        return styles;
    }

    public BOrd[] getStyleSheetOrds() {
        return this.document.styles.toArray(new BOrd[0]);
    }

    @Deprecated
    public void addJavaScript(String url) {
        BOrd ord = BOrd.make((String)url);
        this.addJavaScript(ord);
    }

    public void addJavaScript(BOrd ord) {
        if (!this.document.scripts.contains(ord)) {
            this.document.scripts.add(ord);
        }
    }

    @Deprecated
    public String[] getJavaScript() {
        String[] javascript = new String[this.document.scripts.size()];
        for (int i = 0; i < this.document.scripts.size(); ++i) {
            javascript[i] = this.document.scripts.get(i).toString();
        }
        return javascript;
    }

    public BOrd[] getJavaScriptOrds() {
        return this.document.scripts.toArray(new BOrd[0]);
    }

    public void addOnload(String code) {
        this.document.onload.add(code);
    }

    public void addOnunload(String code) {
        this.document.onunload.add(code);
    }

    public void addOnresize(String code) {
        this.document.onresize.add(code);
    }

    public String[] getOnload() {
        return this.document.onload.toArray(new String[0]);
    }

    public String[] getOnunload() {
        return this.document.onunload.toArray(new String[0]);
    }

    public String[] getOnresize() {
        return this.document.onresize.toArray(new String[0]);
    }

    public void addGlobal(String code) {
        this.document.global.add(code);
    }

    public String[] getGlobal() {
        return this.document.global.toArray(new String[0]);
    }

    public boolean isJQuery() {
        return this.document.jQuery;
    }

    public boolean isBindResources() {
        return this.document.isBindResources;
    }

    public String getUnsafePostBody() {
        return this.document.postBody;
    }

    public String getPostBody() {
        String body = this.getUnsafePostBody();
        return body != null ? Encode.forHtml((String)body) : null;
    }

    public void decodeFormValues() {
        if (this.document.form != null) {
            return;
        }
        if (this.isMultiPartForm()) {
            try {
                this.document.form = new MultiPartForm().decode(this);
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        } else {
            this.document.form = new HashMap<String, String>();
            if (this.document.postBody != null) {
                String[] pairs = TextUtil.split((String)this.document.postBody, (char)'&');
                for (int i = 0; i < pairs.length; ++i) {
                    String[] pair = TextUtil.split((String)pairs[i], (char)'=');
                    if (pair.length < 2) continue;
                    this.document.form.put(HxUtil.decode(pair[0]), HxUtil.decode(pair[1]));
                }
            }
        }
    }

    public boolean isFormPost() {
        return this.document.formPost;
    }

    public boolean isUpdate() {
        return this.document.update;
    }

    public String getFormValue(String key) {
        String value;
        this.decodeFormValues();
        String formKey = this.makeFormKey(key);
        String string = value = this.document.escapedForm != null ? this.document.escapedForm.get(formKey) : null;
        if (value == null && (value = this.document.form.get(formKey)) != null) {
            if (this.document.escapedForm == null) {
                this.document.escapedForm = new HashMap<String, String>();
            }
            value = Encode.forHtml((String)value);
            this.document.escapedForm.put(formKey, value);
        }
        return value;
    }

    public String getUnsafeFormValue(String key) {
        this.decodeFormValues();
        return this.document.form.get(this.makeFormKey(key));
    }

    private String makeFormKey(String key) {
        return this.path.length() > 0 ? this.path + "." + key : key;
    }

    public String[] getFormKeys() {
        this.decodeFormValues();
        if (this.keys == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : this.document.form.keySet()) {
                if (this.path.length() == 0) {
                    list.add(key);
                    continue;
                }
                if (!key.startsWith(this.path) || key.length() <= this.path.length() || key.charAt(this.path.length()) != '.') continue;
                list.add(key.substring(this.path.length() + 1));
            }
            this.keys = list.toArray(new String[0]);
        }
        return this.keys;
    }

    public BIFile getFile(String key) {
        if (this.document.files == null) {
            return null;
        }
        if (this.path.length() > 0) {
            StringBuilder buf = new StringBuilder(this.path).append(".").append(key);
            key = buf.toString();
        }
        return this.document.files.get(key);
    }

    public String getRedirect() {
        return this.document.redirect;
    }

    public void setRedirect(String url) {
        this.document.redirect = url;
    }

    public boolean isErrorSent() {
        return this.document.error;
    }

    public void sendError(Exception ex) {
        this.sendError(400, ex);
    }

    public void sendError(int sc, Exception ex) {
        try {
            WebOp op = this.document.webop;
            String message = WebUtil.toUserMessage((Throwable)ex, (Context)op);
            if (op.getResponse().isCommitted()) {
                ServletOutputStream out = op.getResponse().getOutputStream();
                out.write(message.getBytes());
            } else {
                op.getResponse().sendError(sc, message);
            }
            this.document.error = true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot send Error", e);
        }
    }

    public void setProfile(BHxProfile profile) {
        this.document.profile = profile;
    }

    public boolean canWrite() {
        if (!this.mounted || this.getComponent() == null) {
            return !this.readonly;
        }
        return super.canWrite() && !this.readonly;
    }

    void setFile(String name, BIFile file) {
        if (this.document.files == null) {
            this.document.files = new HashMap();
        }
        this.document.files.put(name, file);
    }

    void deleteTempFiles() throws Exception {
        if (this.document.files == null) {
            return;
        }
        for (BIFile file : this.document.files.values()) {
            file.delete();
        }
    }

    public void jQuery() {
        if (!this.document.jQuery && !this.getRequest().getMethod().toLowerCase().equals("get")) {
            this.addJavaScript(BHxProfile.jQueryJs);
            this.addOnload("jQuery.noConflict();");
        }
        this.document.jQuery = true;
    }

    private static class HxDocument {
        WebOp webop;
        int id = 0;
        HashMap<String, Lexicon> lexicons;
        BHxProfile profile;
        boolean multiPart = false;
        ArrayList<String> htags;
        ArrayList<BOrd> styles;
        ArrayList<BOrd> scripts;
        ArrayList<String> onload;
        ArrayList<String> onunload;
        ArrayList<String> onresize;
        ArrayList<String> global;
        StringWriter content;
        Stack<PrintWriter> writerStack;
        boolean dynamic = false;
        boolean raw = false;
        boolean error = false;
        boolean jQuery = false;
        boolean isBindResources = false;
        Map<String, String> form = null;
        Map<String, String> escapedForm = null;
        HashMap<String, BIFile> files = null;
        String postBody = null;
        boolean formPost = false;
        boolean update = false;
        String redirect = null;

        public HxDocument(WebOp webop) {
            this.webop = webop;
        }

        private void init() {
            this.lexicons = new HashMap();
            this.htags = new ArrayList();
            this.styles = new ArrayList();
            this.scripts = new ArrayList();
            this.onload = new ArrayList();
            this.onunload = new ArrayList();
            this.onresize = new ArrayList();
            this.global = new ArrayList();
            this.content = new StringWriter();
            this.writerStack = new Stack();
            this.writerStack.push(new PrintWriter(this.content));
            this.isBindResources = !bindRcWebDev.isEnabled() && !WebDev.get((String)"js").isEnabled() && !WebDev.get((String)"search").isEnabled() && !WebDev.get((String)"webChart").isEnabled() && !WebDev.get((String)"webEditors").isEnabled() && !WebDev.get((String)"bajaScript").isEnabled() && !WebDev.get((String)"hierarchy-ux").isEnabled();
        }
    }
}

