/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hx.util;

import com.tridium.web.RequireJsUtil;
import java.io.IOException;
import java.security.AccessController;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.web.js.BIWebResource;
import javax.baja.webeditors.ux.BWebEditorsJsBuild;

public class HxUtils {
    public static final String HX_PROCESS_WITH_JSON = "application/x-niagara-hx-bux";
    static int forceUpdate = AccessController.doPrivileged(() -> Integer.getInteger("hx.poll.quick", 100));
    public static final String DEPRECATION_KEY = "deprecationFilter";
    public static final BFacets DEPRECATION_FACETS = BFacets.make((String)"deprecationFilter", (boolean)false);

    private HxUtils() {
    }

    public static String getInitSyncedSessionStorageScript() {
        String script = "require(['nmodule/webEditors/rc/util/SyncedSessionStorage'], function (SyncedSessionStorage) {\n  SyncedSessionStorage.getInstance()\n    .catch(function (err) {\n      console.error(err);\n    });\n});\n";
        String wrapped = RequireJsUtil.wrapInBuiltfileRequireScript((String)script, (BIWebResource[])new BIWebResource[]{BWebEditorsJsBuild.INSTANCE});
        return "<script type='text/javascript'>\n" + wrapped + "\n</script>";
    }

    public static String getAutoRefreshScript(long millis) {
        return String.join((CharSequence)"\n", "<script type='text/javascript'>", "setTimeout(function () {", "  var iframes = Array.prototype.slice.call(document.querySelectorAll('iframe'));", "  var allWindows = [ window ].concat(iframes.map(getWindow));", "  var unsavedChangesDetected = false;", "  try {", "    for (var i = 0; i < allWindows.length; i++) {", "      if (hasUnsavedChanges(allWindows[i])) { unsavedChangesDetected = true; }", "    }", "  } catch (ignore) {", "    return doRefresh();", "  }", "", "  if (unsavedChangesDetected) {", "    require(['lex!web', 'log!com.tridium.hx.util.HxUtils'], function (lexs, log) {", "      var webLex = lexs[0];", "      log.info(webLex.get('autoRefresh.changesWereLost')).then(doRefresh, doRefresh);", "    }, doRefresh);", "  } else {", "    doRefresh();", "  }", "", "  function doRefresh() {", "    allWindows.forEach(function (window) {", "      window.onbeforeunload = function () {};", "    });", "    hx.topWindow().location.reload();", "  }", "", "  function hasUnsavedChanges(window) {", "    return typeof window.onbeforeunload === 'function' && window.onbeforeunload();", "  }", "", "  function getWindow(iframe) { return iframe.contentWindow; }", "", "}, " + millis + ");", "</script>");
    }

    public static void forceUpdate(HxOp op) throws IOException {
        HxUtils.forceUpdate(null, op);
    }

    public static void forceUpdate(BRelTime millisDelay, HxOp op) throws IOException {
        if (millisDelay == null) {
            millisDelay = BRelTime.make((long)forceUpdate);
        }
        String invokeCode = "setTimeout(function(){ hx.poll(); }, " + millisDelay.getMillis() + ");";
        if (HxUtil.isPost(op)) {
            op.getHtmlWriter().w((Object)invokeCode);
        } else {
            op.addOnload(invokeCode);
        }
    }

    public static void writeAutoRefresh(HxOp op) throws IOException {
        long millis;
        BValue autoReloadObject = op.getProfileConfig().get("autoRefreshTrigger");
        if (autoReloadObject instanceof BTriggerMode && (millis = HxUtils.getMillisToNextTrigger((BTriggerMode)autoReloadObject)) > 0L) {
            op.getResponse().getWriter().println(HxUtils.getAutoRefreshScript(millis));
        }
    }

    private static long getMillisToNextTrigger(BTriggerMode triggerMode) {
        BAbsTime now;
        TriggerScheduler triggerScheduler = triggerMode.makeScheduler(new BTimeTrigger());
        BAbsTime nextTrigger = triggerScheduler.getNextTriggerTime(now = BAbsTime.now(), now);
        if (BAbsTime.END_OF_TIME.equals((Object)nextTrigger)) {
            return -1L;
        }
        return nextTrigger.getMillis() - now.getMillis();
    }
}

