/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.ui;

import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.ui.util.MediaUtil;
import com.tridium.util.PxUtil;
import com.tridium.web.WebUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.OrdUtil;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualGateway;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class UxMediaUtil {
    private static final List<String> IGNORED_VIEW_QUERY_PARAMS = Collections.singletonList("ux");
    private static final String CLASS_NAME = UxMediaUtil.class.getName();
    private static final Logger LOG = Logger.getLogger("niagara.uxMediaUtil");
    private static final TypeInfo SUBSTITUTE_PX_VIEW = PxUtil.typeInfo((String)"niagaraDriver:AbstractSubstitutePxView");
    private static final TypeInfo VIRTUAL_GATEWAY = BVirtualGateway.TYPE.getTypeInfo();

    private UxMediaUtil() {
    }

    public static synchronized void getMediaInfo(OrdTarget target, HttpServletRequest req, HttpServletResponse response, Context cx) throws Exception {
        PrintWriter writer = response.getWriter();
        JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)writer);
        jsonWriter.object();
        boolean auditionMode = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionMode", Boolean::parseBoolean, (Object)false);
        boolean next = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"next", Boolean::parseBoolean, (Object)false);
        boolean showValidationWarnings = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"showValidationWarnings", Boolean::parseBoolean, (Object)false);
        boolean auditionModeRemove = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionModeRemove", Boolean::parseBoolean, (Object)false);
        boolean applyIncrement = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"applyIncrement", Boolean::parseBoolean, (Object)false);
        if (auditionModeRemove) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Removing Audition Mode cache");
            }
            req.getSession().removeAttribute(CLASS_NAME);
        }
        if (auditionMode) {
            BAbstractPxView abstractPxView;
            ViewQuery viewQuery;
            List<String> list = UxMediaUtil.getList(req, cx);
            BOrd ord = target.get() instanceof BPxFile ? target.getOrdWithoutViewQuery() : ((viewQuery = target.getViewQuery()) == null || viewQuery.getViewId() == null ? ((abstractPxView = MediaUtil.getAbstractPxView((OrdTarget)target, (Context)cx)) != null ? BOrd.make((BOrd)target.getOrdWithoutViewQuery(), (String)("view:" + abstractPxView.getAgentId())) : target.getOrdWithoutViewQuery()) : BOrd.make((BOrd)target.getOrdWithoutViewQuery(), (String)("view:" + viewQuery.getViewId())));
            int nextIndex = -1;
            int index = list.indexOf(ord.toString());
            nextIndex = applyIncrement ? UxMediaUtil.getNextResolvableIndex(list, index, next, cx) : UxMediaUtil.tryResolve(list, index, true, cx);
            if (nextIndex < list.size() && nextIndex > -1) {
                String nextOrd = list.get(nextIndex);
                jsonWriter.key("nextOrd").value((Object)nextOrd);
            }
            jsonWriter.key("auditionIndex").value((long)nextIndex);
            jsonWriter.key("auditionSize").value((long)list.size());
        }
        BTypeSpec mediaTypeSpec = MediaUtil.getMedia((OrdTarget)target, (Context)cx);
        if (showValidationWarnings) {
            BTypeSpec validateTypeSpec = BTypeSpec.make((String)((String)WebUtil.getParameter((ServletRequest)req, (String)"mediaType", SlotPath::unescape, (Object)mediaTypeSpec.toString())));
            jsonWriter.key("validationWarnings").value((Object)MediaUtil.getValidationWarnings((BTypeSpec)validateTypeSpec, (OrdTarget)target, (Context)cx));
        }
        jsonWriter.key("mediaType").value((Object)String.valueOf(MediaUtil.getMedia((OrdTarget)target, (Context)cx)));
        jsonWriter.key("isPxFile").value(target.get() instanceof BPxFile);
        jsonWriter.endObject();
    }

    private static List<String> getList(HttpServletRequest req, Context cx) throws Exception {
        List<String> list;
        Object o = req.getSession().getAttribute(CLASS_NAME);
        if (o instanceof List) {
            list = (List<String>)o;
        } else {
            list = UxMediaUtil.populateOrds(cx);
            req.getSession().setAttribute(CLASS_NAME, list);
        }
        return list;
    }

    private static int getNextResolvableIndex(List<String> list, int index, boolean next, Context cx) {
        int nextIndex = index + (next ? 1 : -1);
        if (nextIndex < 0) {
            nextIndex = list.size() - 1;
        } else if (nextIndex >= list.size()) {
            nextIndex = 0;
        }
        if (nextIndex < list.size() && nextIndex > -1) {
            return UxMediaUtil.tryResolve(list, nextIndex, next, cx);
        }
        return -1;
    }

    private static int tryResolve(List<String> list, int nextIndex, boolean next, Context cx) {
        if (nextIndex == -1) {
            return -1;
        }
        String nextOrd = list.get(nextIndex);
        try {
            BAbstractPxView pxView;
            OrdTarget target = BOrd.make((String)nextOrd).resolve(null, cx);
            if (target.get() instanceof BComponent && (pxView = MediaUtil.getAbstractPxView((OrdTarget)target, (Context)cx)) == null) {
                throw new Exception("View is missing:" + pxView);
            }
            return nextIndex;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "removing " + nextIndex + ": " + list.get(nextIndex), e);
            }
            list.remove(nextIndex);
            return UxMediaUtil.getNextResolvableIndex(list, nextIndex, next, cx);
        }
    }

    public static synchronized void setMediaInfo(OrdTarget target, HttpServletRequest req, HttpServletResponse response, Context cx) throws Exception {
        int auditionIndex;
        List<String> list;
        int nextIndex;
        String mediaType = (String)WebUtil.getParameter((ServletRequest)req, (String)"mediaType", SlotPath::unescape, null);
        boolean auditionMode = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"auditionMode", Boolean::parseBoolean, (Object)false);
        boolean preserveIdentities = (Boolean)WebUtil.getParameter((ServletRequest)req, (String)"preserveIdentities", Boolean::parseBoolean, (Object)false);
        PrintWriter writer = response.getWriter();
        if (mediaType != null) {
            try {
                MediaUtil.setMedia((OrdTarget)target, (String)mediaType, (boolean)preserveIdentities, (Context)cx);
            }
            catch (Exception e) {
                throw new LocalizableException("uxBuilder", "servlet.cannotChangeMedia", new Object[]{UxMediaUtil.getNiceMessage(e, cx)}, (Throwable)e);
            }
        }
        String nextOrd = UxMediaUtil.getNextOrd(target);
        if (auditionMode && (nextIndex = UxMediaUtil.tryResolve(list = UxMediaUtil.getList(req, cx), auditionIndex = ((Integer)WebUtil.getParameter((ServletRequest)req, (String)"auditionIndex", Integer::parseInt, (Object)-1)).intValue(), true, cx)) < list.size() && nextIndex > -1) {
            nextOrd = list.get(auditionIndex);
        }
        JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)writer);
        jsonWriter.object();
        jsonWriter.key("nextOrd").value((Object)nextOrd);
        jsonWriter.endObject();
    }

    private static String getNiceMessage(Exception e, Context cx) {
        if (e instanceof LocalizableException) {
            return ((Localizable)e).toString(cx);
        }
        String message = e.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            return e.getClass().getName();
        }
        return message;
    }

    private static String getNextOrd(OrdTarget target) {
        return OrdUtil.getOrdWithoutViewQueryParameters((OrdTarget)target, IGNORED_VIEW_QUERY_PARAMS, (boolean)false).toString();
    }

    private static List<String> populateOrds(Context cx) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Generating new list");
        }
        if (Sys.getStation().getPermissions(cx).hasOperatorRead()) {
            UxMediaUtil.populate((BINavNode)Sys.getStation(), list, cx);
        }
        try {
            BIFile fileRoot = (BIFile)BOrd.make((String)"file:^").get();
            UxMediaUtil.populate((BINavNode)fileRoot, list, cx);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Problem with populating station files", e);
        }
        return list;
    }

    private static void populate(BINavNode root, List<String> list, Context cx) {
        String navOrd;
        if (VIRTUAL_GATEWAY != null && root.getType().is(VIRTUAL_GATEWAY)) {
            return;
        }
        if (root instanceof BPxFile) {
            navOrd = String.valueOf(root.getNavOrd().relativizeToSession());
            UxMediaUtil.addToList(list, navOrd);
        } else if (root instanceof BIFile) {
            navOrd = String.valueOf(root.getNavOrd().relativizeToSession());
            if ("file:^nstations".equals(navOrd)) {
                return;
            }
        } else {
            root.asObject().getAgents(cx).forEach(agentInfo -> {
                if (agentInfo instanceof BAbstractPxView) {
                    BAbstractPxView abstractPxView = (BAbstractPxView)agentInfo;
                    Property property = abstractPxView.getPropertyInParent();
                    if (property != null && property.isFrozen()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            String message = "PxView is frozen:" + property.getName();
                            BComponent parentComponent = abstractPxView.getParentComponent();
                            if (parentComponent != null) {
                                message = "PxView is frozen:" + parentComponent.getSlotPath() + '/' + property.getName();
                            }
                            LOG.log(Level.FINE, message);
                        }
                        return;
                    }
                    if (abstractPxView instanceof BPxView) {
                        BPxView pxView = (BPxView)abstractPxView;
                        BOrd pxFileOrd = pxView.getPxFile();
                        try {
                            BObject file = pxFileOrd.get(null, cx);
                            if (!(file instanceof BPxFile)) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "PxView does not reference a PxFile:" + file);
                                }
                                return;
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Problem resolving PxFile ord" + pxFileOrd, e);
                            }
                            return;
                        }
                        String navOrd = root.getNavOrd().relativizeToSession() + "|view:" + abstractPxView.getAgentId();
                        UxMediaUtil.addToList(list, navOrd);
                    } else if (SUBSTITUTE_PX_VIEW == null || !abstractPxView.getType().is(SUBSTITUTE_PX_VIEW)) {
                        UxMediaUtil.addToList(list, root.getNavOrd().relativizeToSession() + "|view:" + abstractPxView.getAgentId());
                    }
                }
            });
        }
        BINavNode[] children = root.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            UxMediaUtil.populate(children[i], list, cx);
        }
    }

    private static void addToList(List<String> list, String ord) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, list.size() + ": " + ord);
        }
        list.add(ord);
    }
}

