/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.uxBuilder.servlet;

import com.tridium.sys.registry.NAgentList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.bajascript.BIBajaScriptTypeExt;
import javax.baja.bajaux.BIJavaScriptWidget;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.user.BUser;
import javax.baja.web.BIFormFactor;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.mobile.BMobileWebProfileConfig;

public class PxUxAgentFilter
extends AgentFilter {
    private TypeInfo instanceTypeInfo;
    private final String[] profileAppNames;

    public PxUxAgentFilter(TypeInfo instanceTypeInfo) {
        this(instanceTypeInfo, null);
    }

    public PxUxAgentFilter(TypeInfo instanceTypeInfo, String[] profileAppNames) {
        this.instanceTypeInfo = instanceTypeInfo;
        this.profileAppNames = profileAppNames;
    }

    public boolean include(AgentInfo agent) {
        if (!this.includeAppName(agent)) {
            return false;
        }
        TypeInfo agentTypeInfo = agent.getAgentType();
        if (agentTypeInfo.is(BNullWidget.TYPE)) {
            return false;
        }
        if (agentTypeInfo.is(BIBajaScriptTypeExt.TYPE) || agentTypeInfo.is(BIJavaScriptWidget.TYPE)) {
            return true;
        }
        return this.instanceTypeInfo.is(BWidget.TYPE) && agentTypeInfo.is(BIJavaScript.TYPE) && agentTypeInfo.is(BIFormFactor.TYPE);
    }

    private boolean includeAppName(AgentInfo agent) {
        if (agent.getAppName() != null) {
            if (this.profileAppNames == null) {
                return false;
            }
            for (String profileAppName : this.profileAppNames) {
                if (!profileAppName.equals(agent.getAppName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static AgentList getNonWidgetAgents(TypeInfo typeInfo) {
        NAgentList list = new NAgentList();
        while (!typeInfo.equals(BWidget.TYPE.getTypeInfo())) {
            for (AgentInfo agent : Sys.getRegistry().getSpecificAgents(typeInfo)) {
                list.add(list.size(), agent);
            }
            typeInfo = typeInfo.getSuperType();
        }
        return list;
    }

    public static AgentList getAgentList(TypeInfo info) {
        if (info.is(BWidget.TYPE)) {
            return PxUxAgentFilter.getNonWidgetAgents(info);
        }
        return info.getAgents();
    }

    public static BIWebProfile getProfile(Context cx) {
        BObject object;
        BUser user = cx.getUser();
        if (user == null) {
            return null;
        }
        BWebProfileConfig config = (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
        if (config != null && (object = config.make()) instanceof BIWebProfile) {
            return (BIWebProfile)object;
        }
        config = (BWebProfileConfig)user.getMixIn(BMobileWebProfileConfig.TYPE);
        if (config != null && (object = config.make()) instanceof BIWebProfile) {
            return (BIWebProfile)object;
        }
        return null;
    }
}

