/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import com.tridiumx.intrusionSmartKey.BIntrusionDisplay;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"intrusionSmartKey:IntrusionDisplay"}, requiredPermissions="r")})
@NiagaraTopic(name="keyPressed", eventType="BString")
public class BVirtualIntrusionDisplayView
extends BWbComponentView {
    public static final Topic keyPressed = BVirtualIntrusionDisplayView.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVirtualIntrusionDisplayView.class);
    public final BIcon ICON = BIcon.std((String)"lcd.png");
    private Command f1;
    private Command f2;
    private Command f3;
    private Command f4;
    private BLabel line1;
    private BLabel line2;
    private BLabel line3;
    private BLabel template;
    private BEdgePane edge;
    private BEdgePane virtualEdge;
    private BGridPane virtualGrid;
    private BGridPane buttonGrid;
    private BGridPane grid;
    private BGridPane numberGrid;

    public void fireKeyPressed(BString event) {
        this.fire(keyPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVirtualIntrusionDisplayView() {
        String pad16 = TextUtil.pad((String)"", (int)16);
        BFont font = BFont.make((String)"11pt Courier New");
        this.line1 = new BLabel(pad16, font, BHalign.left);
        this.line2 = new BLabel(pad16, font, BHalign.left);
        this.line3 = new BLabel(pad16, font, BHalign.left);
        this.template = new BLabel();
        this.grid = new BGridPane(1);
        this.edge = new BEdgePane();
        this.grid.add(null, (BValue)this.edge);
        this.virtualEdge = new BEdgePane();
        this.virtualGrid = new BGridPane(1);
        this.virtualGrid.setHalign(BHalign.left);
        this.virtualGrid.setColumnAlign(BHalign.left);
        this.virtualGrid.add(null, (BValue)this.line1);
        this.virtualGrid.add(null, (BValue)this.line2);
        this.virtualGrid.add(null, (BValue)this.line3);
        this.buttonGrid = new BGridPane(4);
        this.f1 = new KeyPressCommand("<F1>", BIcon.std((String)"check.png"));
        this.f2 = new KeyPressCommand("<F2>", BIcon.std((String)"arrowUp.png"));
        this.f3 = new KeyPressCommand("<F3>", BIcon.std((String)"arrowDown.png"));
        this.f4 = new KeyPressCommand("<F4>", BIcon.std((String)"redo.png"));
        BButton b1 = new BButton(this.f1);
        b1.setButtonStyle(BButtonStyle.toolBar);
        BButton b2 = new BButton(this.f2);
        b2.setButtonStyle(BButtonStyle.toolBar);
        BButton b3 = new BButton(this.f3);
        b3.setButtonStyle(BButtonStyle.toolBar);
        BButton b4 = new BButton(this.f4);
        b4.setButtonStyle(BButtonStyle.toolBar);
        this.buttonGrid.add(null, (BValue)b1);
        this.buttonGrid.add(null, (BValue)b2);
        this.buttonGrid.add(null, (BValue)b3);
        this.buttonGrid.add(null, (BValue)b4);
        this.edge.setCenter((BWidget)new BBorderPane((BWidget)this.virtualEdge, BBorder.groove));
        this.virtualEdge.setCenter((BWidget)new BBorderPane((BWidget)this.virtualGrid, BBorder.groove));
        this.virtualEdge.setBottom((BWidget)this.buttonGrid);
        BGridPane numbers = new BGridPane(3);
        numbers.setColumnAlign(BHalign.center);
        this.grid.add(null, (BValue)new BBorderPane((BWidget)numbers, BBorder.groove, BInsets.make((double)10.0, (double)25.0, (double)10.0, (double)25.0)));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("1")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("2")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("3")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("4")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("5")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("6")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("7")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("8")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("9")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("*")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("0")));
        numbers.add(null, (BValue)new BButton((Command)new KeyPressCommand("#")));
        this.setContent((BWidget)this.grid);
    }

    public void doLoadValue(BObject value, Context cx) {
        BIntrusionDisplay intrusionDisplay = (BIntrusionDisplay)value;
        intrusionDisplay.lease(2);
        this.display(value, cx);
    }

    public void display(BObject value, Context cx) {
        BIntrusionDisplay intrusionDisplay = (BIntrusionDisplay)value;
        BIntrusionPage page = intrusionDisplay.getCurrentPage();
        this.line1.setText(this.trim(intrusionDisplay.getLine1().getValue()));
        this.line2.setText(this.trim(intrusionDisplay.getLine2().getValue()));
        this.line3.setText(this.trim(intrusionDisplay.getLine3().getValue()));
        if (intrusionDisplay.getInvertLine1().getValue()) {
            this.line1.setForeground((BBrush)this.theme().getControlBackground().newCopy());
            this.line1.setBackground((BBrush)this.theme().getTextBrush().newCopy());
        } else {
            this.line1.setForeground(BBrush.NULL);
            this.line1.setBackground(BBrush.NULL);
        }
        if (intrusionDisplay.getInvertLine2().getValue()) {
            this.line2.setForeground((BBrush)this.theme().getControlBackground().newCopy());
            this.line2.setBackground((BBrush)this.theme().getTextBrush().newCopy());
        } else {
            this.line2.setForeground(BBrush.NULL);
            this.line2.setBackground(BBrush.NULL);
        }
        if (intrusionDisplay.getInvertLine3().getValue()) {
            this.line3.setForeground((BBrush)this.theme().getControlBackground().newCopy());
            this.line3.setBackground((BBrush)this.theme().getTextBrush().newCopy());
        } else {
            this.line3.setForeground(BBrush.NULL);
            this.line3.setBackground(BBrush.NULL);
        }
        this.f1.setEnabled(page.getHasIn());
        this.f2.setEnabled(page.getHasUp());
        this.f3.setEnabled(page.getHasDown());
        this.f4.setEnabled(page.getHasBack());
    }

    public String trim(String line) {
        if (line.length() > 16) {
            return line.substring(0, 16);
        }
        return TextUtil.pad((String)line, (int)(16 - line.length()));
    }

    WidgetTheme theme() {
        return Theme.label();
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (Flags.isUserDefined1((BComplex)event.getSourceComponent(), (Slot)event.getSourceComponent().getSlot(event.getSlotName()))) {
            this.display(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    public BIcon getIcon() {
        return this.ICON;
    }

    public class KeyPressCommand
    extends Command {
        private String key;

        public KeyPressCommand(String key) {
            super((BWidget)BVirtualIntrusionDisplayView.this, key);
            this.key = key;
        }

        public KeyPressCommand(String key, BIcon icon) {
            super((BWidget)BVirtualIntrusionDisplayView.this, "", BImage.make((BIcon)icon), null, null);
            this.key = key;
        }

        public CommandArtifact doInvoke() {
            BIntrusionDisplay display = (BIntrusionDisplay)BVirtualIntrusionDisplayView.this.getCurrentValue();
            display.keyPressed(BString.make((String)this.key));
            return null;
        }
    }
}

