/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.menu;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.BPinActivity;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.intrusionSmartKey.BIntrusionDisplay;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionArmingPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionPage;
import com.tridiumx.intrusionSmartKey.menu.BIntrusionSummaryPage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="cursorLine", type="int", defaultValue="-1", override=true)
public class BIntrusionPinPage
extends BIntrusionPage {
    public static final Property cursorLine = BIntrusionPinPage.newProperty((int)0, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BIntrusionPinPage.class);
    private BIntrusionZone[] lastZones;
    private BIntrusionZone[] linkedZones;
    private String error = "";
    private StringBuffer b = new StringBuffer();
    private BIntrusionPage next;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIntrusionPinPage() {
    }

    public BIntrusionPinPage(BIntrusionZone linkedZone, BIntrusionPage next) {
        this(new BIntrusionZone[]{linkedZone}, next);
    }

    public BIntrusionPinPage(BIntrusionZone[] linkedZones, BIntrusionPage next) {
        this.linkedZones = linkedZones;
        this.next = next;
    }

    @Override
    public void initPosition() {
        this.b = new StringBuffer();
    }

    @Override
    public void doInput(BString c) throws Exception {
        String s = c.toString();
        if (s.equals("*")) {
            this.b = new StringBuffer();
        } else if (s.equals("#") || s.equals("<F1>")) {
            BIntrusionZone[] authenticatedZones = this.authenticate();
            if (authenticatedZones != null && authenticatedZones.length > 0) {
                if (this.next instanceof BIntrusionArmingPage) {
                    ((BIntrusionArmingPage)this.next).setZones(authenticatedZones);
                } else if (this.next instanceof BIntrusionSummaryPage) {
                    ((BIntrusionSummaryPage)this.next).setZones(authenticatedZones);
                }
                BIntrusionDisplay display = this.getDisplay();
                display.setCurrentPage(this.next);
                display.getCurrentPage().initPosition();
                display.doUpdateDisplay();
            }
        } else {
            this.b.append(s);
        }
        if (this.getDisplay() != null) {
            this.getDisplay().doUpdateDisplay();
        }
    }

    public void setError(BActivity activity, String intrusionPinDescription) {
        this.b = new StringBuffer();
        this.error = IntrusionUtil.text((String)"pinError");
        this.getDisplay().doUpdateDisplay();
        BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        String locationDescription = this.getDisplay().getDisplayName(null);
        this.getDisplay().makeAlarm(activity, intrusionPinDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIntrusionZone[] authenticate() throws Exception {
        BPinActivity activity = BPinActivity.invalidPinNumber;
        String intrusionPinDescription = IntrusionUtil.text((String)"intrusionKeypadAuthenticationFailed");
        String sPin = this.b.toString();
        if (sPin.length() == 0) {
            this.setError((BActivity)activity, intrusionPinDescription);
            return null;
        }
        BIntrusionService keyService = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        try (OrionSession session = keyService.createSession(null);){
            BOrd ord2;
            BIntrusionPin intrusionPin;
            BIntrusionPin pin = null;
            OrionCursor cursor = session.scan(BIntrusionPin.ORION_TYPE);
            while (cursor.next()) {
                intrusionPin = (BIntrusionPin)cursor.get();
                if (!intrusionPin.getPinNumber().validate(sPin) || intrusionPin.getIntrusionZones(session).toArray().length <= 0) continue;
                pin = intrusionPin;
                break;
            }
            if (pin == null) {
                this.setError((BActivity)activity, intrusionPinDescription);
                intrusionPin = null;
                return intrusionPin;
            }
            intrusionPinDescription = pin.getIntrusionPinName();
            BScheduleRec scheduleRec = pin.resolveSchedule(session);
            boolean activeSchedule = false;
            try {
                BBooleanSchedule b;
                if (scheduleRec != null && !(ord2 = scheduleRec.getMappedOrd()).equals((Object)BOrd.DEFAULT) && (b = (BBooleanSchedule)ord2.get()).getOut().getValue()) {
                    activeSchedule = true;
                }
            }
            catch (Exception ord2) {
                // empty catch block
            }
            if (!activeSchedule) {
                this.setError((BActivity)BPinActivity.noActiveSchedule, intrusionPinDescription);
                ord2 = null;
                return ord2;
            }
            BIntrusionZoneRec[] recs = (BIntrusionZoneRec[])pin.getIntrusionZones(session).toArray();
            Array zones = new Array(BIntrusionZone.class);
            for (int i = 0; i < recs.length; ++i) {
                BIntrusionZone zone = (BIntrusionZone)recs[i].getMappedOrd().get();
                if (zones.contains((Object)zone)) continue;
                if (this.linkedZones != null) {
                    for (int j = 0; j < this.linkedZones.length; ++j) {
                        if (zone != this.linkedZones[j]) continue;
                        zones.add((Object)zone);
                    }
                    continue;
                }
                zones.add((Object)zone);
            }
            this.lastZones = (BIntrusionZone[])zones.trim();
            if (this.lastZones.length == 0) {
                this.setError((BActivity)activity, IntrusionUtil.text((String)"notValidOnThisIntrusionKeypad", (Object[])new Object[]{intrusionPinDescription}));
            }
            this.getDisplay().setAuthorization(IntrusionUtil.text((String)"pinAuthorization", (Object[])new Object[]{intrusionPinDescription}));
            BIntrusionZone[] bIntrusionZoneArray = this.lastZones;
            return bIntrusionZoneArray;
        }
    }

    @Override
    public void doUpdateDisplay() {
        this.setCommands();
        this.getDisplay().setLines((String[])this.data.trim());
    }

    @Override
    public void doExecute() {
        int i;
        this.data.clear();
        this.data.add((Object)this.error);
        this.data.add((Object)IntrusionUtil.text((String)"enterLoginPin"));
        StringBuffer p = new StringBuffer();
        p.append("   [");
        for (i = 0; i < 8 - this.b.length(); ++i) {
            p.append(" ");
        }
        for (i = 0; i < this.b.length(); ++i) {
            p.append("*");
        }
        p.append("]");
        this.data.add((Object)p.toString());
        this.data.add((Object)this.getNavLine());
    }

    @Override
    public boolean hasUp() {
        return false;
    }

    @Override
    public boolean hasDown() {
        return false;
    }

    @Override
    public void doUp() {
    }

    @Override
    public void doDown() {
    }

    @Override
    public BIntrusionPage doIn() throws Exception {
        BIntrusionZone[] authenticatedZones = this.authenticate();
        if (authenticatedZones != null && authenticatedZones.length > 0) {
            if (this.next instanceof BIntrusionArmingPage) {
                ((BIntrusionArmingPage)this.next).setZones(authenticatedZones);
            } else if (this.next instanceof BIntrusionSummaryPage) {
                ((BIntrusionSummaryPage)this.next).setZones(authenticatedZones);
            }
            return this.next;
        }
        this.getDisplay().doUpdateDisplay();
        return null;
    }

    public BIntrusionZone[] getLastZones() {
        return this.lastZones;
    }
}

