/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator;
import com.tridium.ddfIp.udp.identify.BIDdfUdpDeviceId;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sendToAddress", type="BDdfIpAddressPort", defaultValue="new BDdfIpAddressPort()", facets={@Facet(value="MGR_INCLUDE")}), @NiagaraProperty(name="maxRetryCount", type="int", defaultValue="3", facets={@Facet(value="DdfFacets.combine( MGR_INCLUDE,\n                                        BFacets.make(BFacets.MIN,BInteger.make(0)))")}, override=true)})
public class BDdfUdpTransmitter
extends BDdfTransmitter {
    @Generated
    public static final Property sendToAddress = BDdfUdpTransmitter.newProperty((int)0, (BValue)new BDdfIpAddressPort(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property maxRetryCount = BDdfUdpTransmitter.newProperty((int)0, (int)3, (BFacets)DdfFacets.combine((BFacets)MGR_INCLUDE, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))));
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfUdpTransmitter.class);
    public static final Lexicon LEX = Lexicon.make(BDdfUdpTransmitter.class);
    public static final String lexkeyRequestDoesNotSupportUdp = "RequestDoesNotSupportUdp";
    public static final String requestDoesNotSupportUdp = LEX.getText("RequestDoesNotSupportUdp");

    @Generated
    public BDdfIpAddressPort getSendToAddress() {
        return (BDdfIpAddressPort)this.get(sendToAddress);
    }

    @Generated
    public void setSendToAddress(BDdfIpAddressPort v) {
        this.set(sendToAddress, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfUdpCommunicator getUdpCommunicator() {
        return (BDdfUdpCommunicator)this.getDdfCommunicator();
    }

    public void forceTransmit(BIDdfRequest ddfRequest) throws Exception {
        BDdfIpAddressPort destUdpAddr = this.getUdpSendToAddress(ddfRequest);
        byte[] udpData = ddfRequest.toByteArray();
        if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace(udpData, destUdpAddr);
        }
        this.getUdpCommunicator().getUdpTransmitSocket().send(new DatagramPacket(udpData, udpData.length, destUdpAddr.getInetAddress(), destUdpAddr.getIpPort()));
    }

    public BDdfIpAddressPort getUdpSendToAddress(BIDdfRequest ddfRequest) {
        BDdfIdParams deviceIdForRequest = ddfRequest.getDeviceId();
        if (deviceIdForRequest instanceof BIDdfUdpDeviceId) {
            return ((BIDdfUdpDeviceId)deviceIdForRequest).getUdpAddress();
        }
        return this.getSendToAddress();
    }

    private void trace(byte[] out, BDdfIpAddressPort udpAddress) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("TX:" + udpAddress.getIpAddress() + ':' + udpAddress.getIpPort());
        ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])out, (int)0, (int)out.length);
        pw.flush();
        pw.close();
        this.getDdfCommunicator().getLog().trace(sw.toString());
    }

    public int getTransmitFromPort() {
        return -1;
    }
}

