/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfNullReceiver;
import com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator;
import java.net.DatagramPacket;
import java.net.InetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDdfUdpReceiver
extends BDdfNullReceiver {
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfUdpReceiver.class);
    protected UdpReceiveFrame internalReceiveFrame = null;
    protected DatagramPacket udpReceivePacket = null;
    protected byte[] udpReceiveBuffer = new byte[this.getUdpReceiveBufferSize()];
    protected int availableUdpBytes = 0;
    protected int udpReceiveBufferOffset = 0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfUdpReceiver() {
        this.udpReceivePacket = new DatagramPacket(this.udpReceiveBuffer, this.udpReceiveBuffer.length);
        this.internalReceiveFrame = new UdpReceiveFrame();
    }

    public int getReceivePort() {
        return -1;
    }

    public BDdfUdpCommunicator getUdpCommunicator() {
        return (BDdfUdpCommunicator)this.getDdfCommunicator();
    }

    protected boolean checkFrame(IDdfDataFrame completeFrame) {
        return true;
    }

    protected int getUdpReceiveBufferSize() {
        return 1024;
    }

    protected IDdfDataFrame doReceiveFrame() throws Exception {
        this.getUdpCommunicator().getUdpReceiveSocket().receive(this.udpReceivePacket);
        this.internalReceiveFrame.takeSnapshot();
        return this.internalReceiveFrame;
    }

    public class UdpReceiveFrame
    implements IDdfDataFrame {
        byte[] frameBytes;
        int frameSize;
        InetAddress udpOriginationAddress;
        int udpOriginationPort;

        synchronized void takeSnapshot() {
            this.frameBytes = BDdfUdpReceiver.this.udpReceiveBuffer;
            this.frameSize = BDdfUdpReceiver.this.udpReceivePacket.getLength();
            this.udpOriginationAddress = BDdfUdpReceiver.this.udpReceivePacket.getAddress();
            this.udpOriginationPort = BDdfUdpReceiver.this.udpReceivePacket.getPort();
        }

        public InetAddress getUdpOriginationAddress() {
            return this.udpOriginationAddress;
        }

        public int getUdpOriginationPort() {
            return this.udpOriginationPort;
        }

        public byte[] getFrameBytes() {
            return this.frameBytes;
        }

        public synchronized IDdfDataFrame getFrameCopy() {
            UdpReceiveFrame copy = new UdpReceiveFrame();
            copy.frameSize = this.frameSize;
            copy.frameBytes = new byte[this.frameSize];
            System.arraycopy(this.frameBytes, 0, copy.frameBytes, 0, this.frameSize);
            copy.udpOriginationAddress = this.udpOriginationAddress;
            copy.udpOriginationPort = this.udpOriginationPort;
            return copy;
        }

        public int getFrameSize() {
            return this.frameSize;
        }

        public BSimple getFrameTag() {
            return BDdfUdpReceiver.this.computeTag(this);
        }
    }
}

