/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.demoData.history;

import com.tridium.demoData.history.BDemoFileHistoryExt;
import com.tridium.demoData.history.CsvFileHistoryCursor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.nre.util.LongHashMap;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;

class DemoDataFileManager {
    private static final DemoDataFileManager dataFileManager = new DemoDataFileManager();
    private static Logger log = Logger.getLogger("demoData.history.DemoDataFileManager");
    private final Map<String, LongHashMap> fileMap = Collections.synchronizedMap(new HashMap());

    public static DemoDataFileManager getInstance() {
        return dataFileManager;
    }

    private DemoDataFileManager() {
    }

    LongHashMap getDemoDataTemplate(BIFile file, BDemoFileHistoryExt parent) throws Exception {
        String hashKey = file.getFilePath().getBody() + "-" + parent.getValueColumnIndex() + "-" + parent.getInterval().getMillis();
        if (this.fileMap.containsKey(hashKey)) {
            return this.fileMap.get(hashKey);
        }
        LongHashMap templateMap = this.buildTemplateMap((Cursor<BTrendRecord>)new CsvFileHistoryCursor(file, parent), parent);
        this.fileMap.put(hashKey, templateMap);
        return templateMap;
    }

    private LongHashMap buildTemplateMap(Cursor<BTrendRecord> template, BDemoFileHistoryExt parent) throws BajaRuntimeException {
        long collectionInterval = parent.getInterval().getMillis();
        int size = (int)(604800000L / collectionInterval);
        int recsWritten = 0;
        long currentMillis = 0L;
        BTrendRecord lastRec = null;
        LongHashMap templateRecs = new LongHashMap(size);
        boolean isNumeric = ((BTrendRecord)parent.getRecordType().getInstance()).getValueProperty().getType().is(BINumeric.TYPE);
        boolean shortFile = false;
        while (recsWritten < size) {
            long lastRecMillis;
            BTrendRecord currentRec;
            if (template.next()) {
                currentRec = (BTrendRecord)((BTrendRecord)template.get()).newCopy();
            } else if (lastRec != null) {
                if (!shortFile) {
                    log.warning("DemoData encountered a short data template file: " + parent.getTemplateFile().encodeToString());
                    shortFile = true;
                }
                lastRec.setTimestamp(BAbsTime.make((long)(lastRec.getTimestamp().getMillis() + collectionInterval)));
                currentRec = lastRec;
            } else {
                log.warning("DemoDate file encountered an empty data file: " + parent.getTemplateFile().encodeToString());
                throw new BajaRuntimeException("Provided Data file contains no data.");
            }
            BAbsTime currentRecTstamp = currentRec.getTimestamp();
            long currentRecMillis = DemoDataFileManager.toNormalizedMillis(currentRecTstamp, collectionInterval);
            BAbsTime lastRecTstamp = lastRec != null ? lastRec.getTimestamp() : null;
            long l = lastRecMillis = lastRec != null ? DemoDataFileManager.toNormalizedMillis(lastRecTstamp, collectionInterval) : -1L;
            if (lastRec == null || currentMillis == currentRecMillis) {
                if (templateRecs.get(currentMillis) != null) {
                    return templateRecs;
                }
                templateRecs.put(currentMillis, (Object)currentRec);
                currentMillis += collectionInterval;
                ++recsWritten;
            } else {
                double diff = currentRecMillis - lastRecMillis;
                while (currentMillis <= currentRecMillis) {
                    BTrendRecord newRec;
                    if (templateRecs.get(currentMillis) != null) {
                        return templateRecs;
                    }
                    if (currentMillis < currentRecMillis) {
                        newRec = (BTrendRecord)lastRec.newCopy();
                        newRec.setTimestamp(BAbsTime.make((long)(lastRecTstamp.getMillis() + currentMillis)));
                        if (isNumeric) {
                            double currentNumericVal = ((BNumericTrendRecord)currentRec).getValue();
                            double lastNumericVal = ((BNumericTrendRecord)lastRec).getValue();
                            double fractionOfInterval = (double)(currentMillis - lastRecMillis) / diff;
                            double interpolatedVal = lastNumericVal + fractionOfInterval * (currentNumericVal - lastNumericVal);
                            ((BNumericTrendRecord)newRec).setValue(interpolatedVal);
                        }
                    } else {
                        newRec = currentRec;
                    }
                    templateRecs.put(currentMillis, (Object)newRec);
                    currentMillis += collectionInterval;
                    ++recsWritten;
                }
            }
            lastRec = currentRec;
        }
        return templateRecs;
    }

    static long toNormalizedMillis(BAbsTime timestamp, long intervalMillis) {
        long timeOfDayMillis = timestamp.getTimeOfDayMillis();
        long dayOfWeekOffset = timestamp.getWeekday().getOrdinal();
        long timeOfWeekMillis = timeOfDayMillis + dayOfWeekOffset * 86400000L;
        return timeOfWeekMillis / intervalMillis * intervalMillis;
    }
}

