/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.demoData.history;

import com.tridium.demoData.history.BRdbmsDemoDataGenerator;
import com.tridium.demoData.history.DemoDataFileManager;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.file.BIFile;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BIntervalHistoryExt;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.LongHashMap;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="demoGenerationStatus", type="String", defaultValue="", flags=3), @NiagaraProperty(name="historyStartDate", type="BDate", defaultValue="BDate.make(2014, BMonth.january, 1)"), @NiagaraProperty(name="templateFile", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IFile\"")}), @NiagaraProperty(name="maxDemoValue", type="double", defaultValue="100", facets={@Facet(name="BFacets.MIN", value="Integer.MIN_VALUE"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="minDemoValue", type="double", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="Integer.MIN_VALUE"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="isOutsideTemperatureData", type="boolean", defaultValue="false"), @NiagaraProperty(name="isEnergyData", type="boolean", defaultValue="false"), @NiagaraProperty(name="isNorthernHemisphere", type="boolean", defaultValue="true"), @NiagaraProperty(name="energyClimateSkew", type="double", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="Integer.MIN_VALUE"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="rowStart", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="rowEnd", type="int", defaultValue="-1", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE"), @Facet(name="BFacets.FIELD_EDITOR", value="\"driver:OptionalPositiveIntegerFE\"")}), @NiagaraProperty(name="timestampColumnIndex", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="timestampFormat", type="String", defaultValue="M/d/yy HH:mm", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"driver:TimestampFormatFE\"")}), @NiagaraProperty(name="valueColumnIndex", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="statusColumnIndex", type="int", defaultValue="-1", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE"), @Facet(name="BFacets.FIELD_EDITOR", value="\"driver:OptionalPositiveIntegerFE\"")}), @NiagaraProperty(name="identifierColumnIndex", type="int", defaultValue="-1", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE"), @Facet(name="BFacets.FIELD_EDITOR", value="\"driver:OptionalPositiveIntegerFE\"")}), @NiagaraProperty(name="identifierPattern", type="String", defaultValue="*"), @NiagaraProperty(name="regenerate", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="regenerateHistoricalData", flags=16), @NiagaraAction(name="execute", flags=20)})
public final class BDemoFileHistoryExt
extends BIntervalHistoryExt {
    @Generated
    public static final Property demoGenerationStatus = BDemoFileHistoryExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property historyStartDate = BDemoFileHistoryExt.newProperty((int)0, (BValue)BDate.make((int)2014, (BMonth)BMonth.january, (int)1), null);
    @Generated
    public static final Property templateFile = BDemoFileHistoryExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    @Generated
    public static final Property maxDemoValue = BDemoFileHistoryExt.newProperty((int)0, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)Integer.MIN_VALUE), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property minDemoValue = BDemoFileHistoryExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)Integer.MIN_VALUE), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property isOutsideTemperatureData = BDemoFileHistoryExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property isEnergyData = BDemoFileHistoryExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property isNorthernHemisphere = BDemoFileHistoryExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property energyClimateSkew = BDemoFileHistoryExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)Integer.MIN_VALUE), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property rowStart = BDemoFileHistoryExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property rowEnd = BDemoFileHistoryExt.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)), (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:OptionalPositiveIntegerFE")));
    @Generated
    public static final Property timestampColumnIndex = BDemoFileHistoryExt.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property timestampFormat = BDemoFileHistoryExt.newProperty((int)0, (String)"M/d/yy HH:mm", (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:TimestampFormatFE"));
    @Generated
    public static final Property valueColumnIndex = BDemoFileHistoryExt.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property statusColumnIndex = BDemoFileHistoryExt.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)), (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:OptionalPositiveIntegerFE")));
    @Generated
    public static final Property identifierColumnIndex = BDemoFileHistoryExt.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)), (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:OptionalPositiveIntegerFE")));
    @Generated
    public static final Property identifierPattern = BDemoFileHistoryExt.newProperty((int)0, (String)"*", null);
    @Generated
    public static final Property regenerate = BDemoFileHistoryExt.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action regenerateHistoricalData = BDemoFileHistoryExt.newAction((int)16, null);
    @Generated
    public static final Action execute = BDemoFileHistoryExt.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDemoFileHistoryExt.class);
    private static final BRelTime maxEmbeddedDaysInHistory = BRelTime.makeDays((int)61);
    private static final BRelTime maxDaysInHistory = BRelTime.makeDays((int)366);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/controlExtension.png"), (BIcon)BIcon.std((String)"badges/file.png"));
    private static final CoalesceQueue WORKER_QUEUE = new CoalesceQueue();
    private static final ThreadPoolWorker WORKER = new ThreadPoolWorker((Worker.ITodo)WORKER_QUEUE);
    private static Lexicon lex = Lexicon.make((String)"demoData");
    private static int instanceCount = 0;
    final Object lock = new Object();
    private LongHashMap templateRecs = null;
    private boolean fatalFault;
    private String fatalFaultCause;
    private int maxLicenseRecords;
    final AtomicBoolean rdbmsDemoMode = new AtomicBoolean();

    @Generated
    public String getDemoGenerationStatus() {
        return this.getString(demoGenerationStatus);
    }

    @Generated
    public void setDemoGenerationStatus(String v) {
        this.setString(demoGenerationStatus, v, null);
    }

    @Generated
    public BDate getHistoryStartDate() {
        return (BDate)this.get(historyStartDate);
    }

    @Generated
    public void setHistoryStartDate(BDate v) {
        this.set(historyStartDate, (BValue)v, null);
    }

    @Generated
    public BOrd getTemplateFile() {
        return (BOrd)this.get(templateFile);
    }

    @Generated
    public void setTemplateFile(BOrd v) {
        this.set(templateFile, (BValue)v, null);
    }

    @Generated
    public double getMaxDemoValue() {
        return this.getDouble(maxDemoValue);
    }

    @Generated
    public void setMaxDemoValue(double v) {
        this.setDouble(maxDemoValue, v, null);
    }

    @Generated
    public double getMinDemoValue() {
        return this.getDouble(minDemoValue);
    }

    @Generated
    public void setMinDemoValue(double v) {
        this.setDouble(minDemoValue, v, null);
    }

    @Generated
    public boolean getIsOutsideTemperatureData() {
        return this.getBoolean(isOutsideTemperatureData);
    }

    @Generated
    public void setIsOutsideTemperatureData(boolean v) {
        this.setBoolean(isOutsideTemperatureData, v, null);
    }

    @Generated
    public boolean getIsEnergyData() {
        return this.getBoolean(isEnergyData);
    }

    @Generated
    public void setIsEnergyData(boolean v) {
        this.setBoolean(isEnergyData, v, null);
    }

    @Generated
    public boolean getIsNorthernHemisphere() {
        return this.getBoolean(isNorthernHemisphere);
    }

    @Generated
    public void setIsNorthernHemisphere(boolean v) {
        this.setBoolean(isNorthernHemisphere, v, null);
    }

    @Generated
    public double getEnergyClimateSkew() {
        return this.getDouble(energyClimateSkew);
    }

    @Generated
    public void setEnergyClimateSkew(double v) {
        this.setDouble(energyClimateSkew, v, null);
    }

    @Generated
    public int getRowStart() {
        return this.getInt(rowStart);
    }

    @Generated
    public void setRowStart(int v) {
        this.setInt(rowStart, v, null);
    }

    @Generated
    public int getRowEnd() {
        return this.getInt(rowEnd);
    }

    @Generated
    public void setRowEnd(int v) {
        this.setInt(rowEnd, v, null);
    }

    @Generated
    public int getTimestampColumnIndex() {
        return this.getInt(timestampColumnIndex);
    }

    @Generated
    public void setTimestampColumnIndex(int v) {
        this.setInt(timestampColumnIndex, v, null);
    }

    @Generated
    public String getTimestampFormat() {
        return this.getString(timestampFormat);
    }

    @Generated
    public void setTimestampFormat(String v) {
        this.setString(timestampFormat, v, null);
    }

    @Generated
    public int getValueColumnIndex() {
        return this.getInt(valueColumnIndex);
    }

    @Generated
    public void setValueColumnIndex(int v) {
        this.setInt(valueColumnIndex, v, null);
    }

    @Generated
    public int getStatusColumnIndex() {
        return this.getInt(statusColumnIndex);
    }

    @Generated
    public void setStatusColumnIndex(int v) {
        this.setInt(statusColumnIndex, v, null);
    }

    @Generated
    public int getIdentifierColumnIndex() {
        return this.getInt(identifierColumnIndex);
    }

    @Generated
    public void setIdentifierColumnIndex(int v) {
        this.setInt(identifierColumnIndex, v, null);
    }

    @Generated
    public String getIdentifierPattern() {
        return this.getString(identifierPattern);
    }

    @Generated
    public void setIdentifierPattern(String v) {
        this.setString(identifierPattern, v, null);
    }

    @Generated
    public boolean getRegenerate() {
        return this.getBoolean(regenerate);
    }

    @Generated
    public void setRegenerate(boolean v) {
        this.setBoolean(regenerate, v, null);
    }

    @Generated
    public void regenerateHistoricalData() {
        this.invoke(regenerateHistoricalData, null, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint;
    }

    public Type getRecordType() {
        Type parentType = this.getParentPoint().getType();
        if (parentType.is(BNumericPoint.TYPE)) {
            return BNumericTrendRecord.TYPE;
        }
        if (parentType.is(BBooleanPoint.TYPE)) {
            return BBooleanTrendRecord.TYPE;
        }
        return BStringTrendRecord.TYPE;
    }

    protected void writeRecord(BAbsTime timestamp, BStatusValue out) throws IOException {
        if (!this.fatalFault) {
            this.execute();
        } else {
            this.setFaultCause(this.fatalFaultCause);
            this.updateStatus();
        }
    }

    public void started() throws Exception {
        String demoStationLimitFault;
        super.started();
        this.fatalFaultCause = "";
        this.fatalFault = false;
        Feature demoStationFeature = Sys.getLicenseManager().getFeature("tridium", "demoStation");
        if (demoStationFeature == null || demoStationFeature.isExpired()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.fatalFault = true;
            this.fatalFaultCause = demoStationFeature != null ? lex.get("demoStation.expired") : lex.get("demoStation.notLicensed");
        } else if (!this.fatalFault && (demoStationLimitFault = (String)this.fw(501, demoStationFeature, null, null, null)) != null) {
            this.fatalFaultCause = lex.get("demoStation.error") + " " + demoStationLimitFault;
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.fatalFault = true;
        }
        if (demoStationFeature != null) {
            try {
                this.maxLicenseRecords = demoStationFeature.geti("historyRecord.limit", 500);
            }
            catch (NumberFormatException e) {
                this.maxLicenseRecords = 0;
            }
            if (!this.allowUnrestrictedCapacity()) {
                boolean isDefaultCapacity = this.getHistoryConfig().getCapacity().equals((Object)BHistoryConfig.capacity.getDefaultValue());
                if (this.maxLicenseRecords != 0) {
                    if (isDefaultCapacity || this.getHistoryConfig().getCapacity().getMaxRecords() > this.maxLicenseRecords) {
                        this.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)this.maxLicenseRecords));
                    }
                } else if (isDefaultCapacity) {
                    this.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)Integer.MAX_VALUE));
                }
            }
        }
        this.setFaultCause(this.fatalFaultCause);
        this.updateStatus();
        if (!this.fatalFault && this.getEnabled() && Sys.atSteadyState()) {
            this.execute();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.fatalFault && this.getEnabled()) {
            this.execute();
        } else {
            this.setFaultCause(this.fatalFaultCause);
            this.updateStatus();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (!this.rdbmsDemoMode.get()) {
            this.getWorkerQueue().enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
        }
        return null;
    }

    public void changed(Property p, Context c) {
        if (!this.isRunning()) {
            super.changed(p, c);
            return;
        }
        if (p.equals(interval) && c != null && c.getUser() != null) {
            BHistoryId id = this.getHistoryConfig().getId();
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (!id.isNull() && localDb != null) {
                try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                    if (conn.exists(id)) {
                        conn.deleteHistory(id);
                    }
                }
            }
        }
        if ((p.equals(historyStartDate) || p.equals(templateFile) || p.equals(rowStart) || p.equals(rowEnd) || p.equals(timestampColumnIndex) || p.equals(timestampFormat) || p.equals(valueColumnIndex) || p.equals(statusColumnIndex) || p.equals(identifierColumnIndex) || p.equals(identifierPattern) || p.equals(interval)) && c != null && c.getUser() != null) {
            if (!this.fatalFault && this.getEnabled()) {
                this.regenerateHistoricalData();
            } else {
                this.setRegenerate(true);
            }
        }
        super.changed(p, c);
        if (p.equals(enabled)) {
            if (!this.fatalFault && this.getEnabled()) {
                this.execute();
            } else if (this.fatalFault) {
                this.setEnabled(false);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue getWorkerQueue() {
        if (!WORKER.isRunning()) {
            ThreadPoolWorker threadPoolWorker = WORKER;
            synchronized (threadPoolWorker) {
                if (!WORKER.isRunning()) {
                    WORKER.setMaxThreads(100);
                    WORKER.start("DemoDataWorker");
                }
            }
        }
        return WORKER_QUEUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRegenerateHistoricalData() {
        Object object = this.lock;
        synchronized (object) {
            this.setRegenerate(true);
            this.doExecute();
        }
    }

    protected void initConfig(BHistoryConfig config) {
        if (config != null) {
            config.setFlags((Slot)BHistoryConfig.id, config.getFlags((Slot)BHistoryConfig.id) | 0x10000);
        }
        if (this.fatalFault) {
            this.setFaultCause(this.fatalFaultCause);
            this.setEnabled(false);
            throw new BajaRuntimeException(this.fatalFaultCause);
        }
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        super.historyConfigChanged(config, p);
        this.setMaxRecordSize();
        this.updateStatus();
        this.syncConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExecute() {
        if (!this.fatalFault) {
            Object object = this.lock;
            synchronized (object) {
                this.processTemplateFile((BIFile)this.getTemplateFile().get((BObject)this));
            }
        } else {
            this.setFaultCause(this.fatalFaultCause);
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplateFile(BIFile file) {
        boolean clear = this.getRegenerate();
        BTrendRecord lastRec = null;
        try {
            BHistoryId id;
            if (clear || this.templateRecs == null) {
                this.setDemoGenerationStatus("Generating historical demo data, please wait...");
                this.templateRecs = DemoDataFileManager.getInstance().getDemoDataTemplate(file, this);
            }
            if ((id = this.getHistoryConfig().getId()).isNull()) {
                return;
            }
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (localDb == null) {
                return;
            }
            BAbsTime lastTimestamp = null;
            BAbsTime currentTimestamp = BAbsTime.now();
            BAbsTime maxLastTime = this.rdbmsDemoMode.get() ? BAbsTime.DEFAULT : currentTimestamp.subtract(maxDaysInHistory);
            int maxRecords = this.setMaxRecordSize();
            BCollectionInterval interval = this.getHistoryConfig().getInterval();
            BRelTime maxDayStored = BRelTime.makeMinutes((int)(interval.getInterval().getMinutes() * maxRecords));
            BAbsTime recordCountLastSize = currentTimestamp.subtract(maxDayStored);
            if (recordCountLastSize.isAfter(maxLastTime)) {
                maxLastTime = recordCountLastSize;
            }
            BRelTime collectionInterval = this.getInterval();
            long intervalMillis = this.getInterval().getMillis();
            try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                BIHistory history = null;
                if (conn.exists(id)) {
                    if (clear) {
                        conn.clearAllRecords(id);
                    }
                    history = conn.getHistory(id);
                    lastTimestamp = conn.getLastTimestamp(history);
                    lastRec = (BTrendRecord)conn.getLastRecord(history);
                }
                if (lastTimestamp == null || lastTimestamp.isNull()) {
                    lastTimestamp = BAbsTime.make((int)this.getHistoryStartDate().getYear(), (BMonth)this.getHistoryStartDate().getMonth(), (int)this.getHistoryStartDate().getDay(), (int)0, (int)0, (int)0, (int)0);
                    if (maxLastTime.isAfter(lastTimestamp)) {
                        lastTimestamp = maxLastTime;
                    }
                } else {
                    lastTimestamp = lastTimestamp.add(collectionInterval);
                }
                this.setDemoGenerationStatus("Generating historical demo data, please wait...");
                int recordCount = 0;
                while (currentTimestamp.isAfter(lastTimestamp)) {
                    BTrendRecord rec = (BTrendRecord)this.templateRecs.get(DemoDataFileManager.toNormalizedMillis(lastTimestamp, intervalMillis));
                    if (rec != null) {
                        lastRec = (BTrendRecord)rec.newCopy();
                        lastRec.setTimestamp(lastTimestamp);
                        boolean isNumeric = ((BTrendRecord)this.getRecordType().getInstance()).getValueProperty().getType().is(BINumeric.TYPE);
                        if (isNumeric) {
                            if (this.getIsOutsideTemperatureData()) {
                                lastRec = this.adjustTempRecordForSeason((BNumericTrendRecord)lastRec);
                            } else if (this.getIsEnergyData()) {
                                lastRec = this.adjustEnergyRecordForSeason((BNumericTrendRecord)lastRec);
                            }
                        }
                        this.append(lastRec);
                        ++recordCount;
                        if (history != null && lastRec.getTrendFlags().getBit(1)) {
                            lastRec.setTrendFlags(lastRec.getTrendFlags().set(1, false));
                            conn.update(history, (BHistoryRecord)lastRec);
                        }
                        if (recordCount > 500) {
                            recordCount = 0;
                            Thread.yield();
                        }
                    }
                    lastTimestamp = lastTimestamp.add(collectionInterval);
                }
            }
        }
        catch (Exception e) {
            this.setDemoGenerationStatus(e.toString());
            e.printStackTrace();
        }
        finally {
            if (clear) {
                this.setRegenerate(false);
            }
            if (this.getDemoGenerationStatus().contains("Generating historical demo data, please wait...")) {
                this.setDemoGenerationStatus("");
            }
            if (lastRec != null) {
                BControlPoint parent;
                BValue lastValue = lastRec.get(lastRec.getValueProperty());
                BControlPoint point = this.getParentPoint();
                if (point.getType().is(BIWritablePoint.TYPE) && point.getType().is(BControlPoint.TYPE) && (parent = point).getProxyExt().getType().is(BNullProxyExt.TYPE)) {
                    point.invoke((Action)point.getSlot("set"), lastValue);
                }
            }
        }
    }

    private int setMaxRecordSize() {
        int maxRecords;
        if (this.allowUnrestrictedCapacity()) {
            return Integer.MAX_VALUE;
        }
        if (!this.getHistoryConfig().getCapacity().isUnlimited()) {
            maxRecords = this.getHistoryConfig().getCapacity().getMaxRecords();
            if (this.maxLicenseRecords == 0 || maxRecords < this.maxLicenseRecords) {
                this.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)maxRecords));
            }
        } else if (this.maxLicenseRecords == 0) {
            this.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)Integer.MAX_VALUE));
            maxRecords = Integer.MAX_VALUE;
        } else {
            this.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)this.maxLicenseRecords));
            maxRecords = this.maxLicenseRecords;
        }
        return maxRecords;
    }

    private double calculateSeasonalOffset(BAbsTime timeStamp) {
        long period = 365L;
        int equinoxOffset = 100;
        int currentDay = timeStamp.getDayOfYear();
        currentDay = currentDay < equinoxOffset ? (int)period - (equinoxOffset - currentDay) : (currentDay -= equinoxOffset);
        double periodPercent = (double)currentDay / (double)period;
        double amplitude = Math.abs(this.getMaxDemoValue() - this.getMinDemoValue()) / 2.0;
        double skewValue = 0.0;
        if (this.getIsEnergyData()) {
            skewValue = this.getEnergyClimateSkew();
        }
        double ang = Math.PI * 2 * periodPercent;
        double adjustment = Math.sin(ang) * amplitude;
        if (!this.getIsNorthernHemisphere()) {
            adjustment *= -1.0;
        }
        return adjustment + skewValue;
    }

    private BTrendRecord adjustEnergyRecordForSeason(BNumericTrendRecord rec) {
        double offsetValue = this.calculateSeasonalOffset(rec.getTimestamp());
        rec.setValue(Math.abs(offsetValue) + rec.getValue());
        return rec;
    }

    private BTrendRecord adjustTempRecordForSeason(BNumericTrendRecord rec) {
        double offsetValue = this.calculateSeasonalOffset(rec.getTimestamp());
        rec.setValue(offsetValue + rec.getValue());
        return rec;
    }

    public void updateStatus() {
        super.updateStatus();
        if (this.fatalFault) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(this.fatalFaultCause);
        }
    }

    private boolean allowUnrestrictedCapacity() {
        return this.rdbmsDemoMode.get() || this.getParent() instanceof BUnrestrictedFolder && this.getParent().getParent() instanceof BRdbmsDemoDataGenerator && this.getParent().getPropertyInParent().isFrozen() && !this.getEnabled();
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 501: {
                int licenseCount;
                Feature demoStationFeature = (Feature)a;
                try {
                    licenseCount = demoStationFeature.geti("historyExt.limit", 0);
                }
                catch (NumberFormatException e) {
                    licenseCount = 0;
                }
                if (licenseCount == 0) {
                    return null;
                }
                if (licenseCount > this.getInstanceCount()) {
                    this.addInstance();
                    return null;
                }
                return lex.getText("demoStation.licenseLimitExceeded");
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private int getInstanceCount() {
        return instanceCount;
    }

    private void addInstance() {
        ++instanceCount;
    }
}

