/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.util;

import com.tridium.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PxFileUtil {
    private static final String WB_MEDIA_TYPE = "workbench:WbPxMedia";
    private static final int MEDIA_CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.pxFile.media.size", 500));
    private static final Map<String, MediaInfo> MEDIA_MAP = Collections.synchronizedMap(new LinkedHashMap<String, MediaInfo>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, MediaInfo> eldest) {
            return this.size() > MEDIA_CACHE_SIZE;
        }
    });

    private PxFileUtil() {
    }

    public static synchronized String getMedia(BPxFile file) {
        MediaInfo info;
        BOrd navOrd = file.getNavOrd();
        if (navOrd == null) {
            return PxFileUtil.getMediaFromFile(file);
        }
        long lastModified = file.getLastModified().getMillis();
        if (lastModified > (info = MEDIA_MAP.computeIfAbsent(navOrd.toString(), k -> new MediaInfo(lastModified, PxFileUtil.getMediaFromFile(file)))).lastModified) {
            info.lastModified = lastModified;
            info.mediaType = PxFileUtil.getMediaFromFile(file);
        }
        return info.mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMediaFromFile(BPxFile file) {
        XMLStreamReader parser = null;
        try (InputStream in = file.getInputStream();){
            try {
                parser = StreamUtil.getFactory().createXMLStreamReader(in);
                int event = 0;
                do {
                    if (event == 8) return WB_MEDIA_TYPE;
                } while ((event = parser.next()) != 1 || !"px".equals(parser.getLocalName().toLowerCase()));
                String mediaString = parser.getAttributeValue(null, "media");
                if (mediaString != null) {
                    String string = mediaString;
                    return string;
                }
                String string = WB_MEDIA_TYPE;
                return string;
            }
            finally {
                parser.close();
            }
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        return WB_MEDIA_TYPE;
    }

    private static class MediaInfo {
        private long lastModified;
        private String mediaType;

        public MediaInfo(long lastModified, String mediaType) {
            this.lastModified = lastModified;
            this.mediaType = mediaType;
        }
    }
}

