/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.util.ArrayList;
import obix.Uri;
import obix.net.SessionWatch;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;
import obix.ui.views.AlarmConsoleView;
import obix.ui.views.ObjSheetView;
import obix.ui.views.SessionsView;
import obix.ui.views.SourceView;
import obix.ui.views.SplashView;
import obix.ui.views.WatchServiceView;
import obix.ui.views.WatchView;
import obix.ui.views.XmlView;

public class ViewRegistry {
    public static View[] toBuiltin(Shell shell, String uriStr) {
        if (!uriStr.startsWith("spy:")) {
            return null;
        }
        if (uriStr.equals("spy:sessions")) {
            return new View[]{new SessionsView(shell)};
        }
        return new View[]{new SplashView(shell)};
    }

    public static View[] viewsFor(Shell shell, UiSession.Response resp) throws Exception {
        ArrayList<View> acc = new ArrayList<View>();
        acc.add(0, new SourceView(shell, resp));
        acc.add(0, new XmlView(shell, resp));
        if (resp.obj != null) {
            acc.add(0, new ObjSheetView(shell, resp));
        }
        if (resp.obj != null && resp.obj.getIs() != null) {
            Uri[] contracts = resp.obj.getIs().list();
            for (int i = contracts.length - 1; i >= 0; --i) {
                View[] v = ViewRegistry.viewsForContract(shell, resp, contracts[i]);
                for (int j = 0; v != null && j < v.length; ++j) {
                    acc.add(0, v[j]);
                }
            }
        }
        return acc.toArray(new View[0]);
    }

    public static View[] viewsForContract(Shell shell, UiSession.Response resp, Uri contract) throws Exception {
        String uri = contract.toString();
        if (uri.equals("obix:WatchService")) {
            return ViewRegistry.viewsForWatchService(shell, resp);
        }
        if (uri.equals("obix:AlarmSubject")) {
            return ViewRegistry.viewsForAlarmSubject(shell, resp);
        }
        return null;
    }

    static View[] viewsForWatchService(Shell shell, UiSession.Response resp) throws Exception {
        ArrayList<View> acc = new ArrayList<View>();
        acc.add(new WatchServiceView(shell, resp));
        SessionWatch[] watches = resp.session.getWatches();
        for (int i = 0; i < watches.length; ++i) {
            acc.add(new WatchView(shell, resp, watches[i]));
        }
        return acc.toArray(new View[0]);
    }

    static View[] viewsForAlarmSubject(Shell shell, UiSession.Response resp) throws Exception {
        return new View[]{new AlarmConsoleView(shell, resp)};
    }
}

