/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx.ui;

import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.alarm.BAlarmConsoleVideoPlayerDialog;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"alarm:ConsoleRecipient", "entsec:AlarmHistory"}, app="entsec", requiredPermissions="r")})
public class BVideoReviewView
extends BWbView {
    public static final Type TYPE = Sys.loadType(BVideoReviewView.class);
    boolean loaded = false;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        BComponent recipient = value.asComponent();
        ViewQuery query = this.getWbShell().getActiveOrdTarget().getViewQuery();
        if (query != null) {
            String uuid = query.getParameter("uuid");
            try {
                BOrd videoCameraOrd;
                BAlarmRecord alarmRecord = this.getAlarmRecord(recipient, uuid);
                if (alarmRecord == null) {
                    return;
                }
                BAbsTime alarmTime = (BAbsTime)alarmRecord.getAlarmData().get("videoEventTimestamp");
                String alarmSummary = this.toSummaryString(alarmRecord, alarmTime);
                if (alarmTime == null || alarmTime.isNull()) {
                    alarmTime = alarmRecord.getTimestamp();
                    alarmSummary = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{alarmSummary});
                }
                if ((videoCameraOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)recipient, (BAlarmRecord)alarmRecord)) == null || videoCameraOrd.equals((Object)BOrd.NULL)) {
                    BDialog.error((BWidget)this, (String)VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo"), (Object)VideoDriverLexicon.LEX.getText("UnableToResolveCameraForAlarmRecord"), (String)VideoDriverLexicon.LEX.getText("UnableToResolveCameraForAlarmRecord.Details"));
                    return;
                }
                BObject videoCameraObject = videoCameraOrd.get((BObject)recipient);
                boolean shouldBeLive = !(videoCameraObject instanceof BIVideoAlarmRecorder);
                BVideoPlayback videoPlayback2 = new BVideoPlayback(alarmSummary, alarmTime, shouldBeLive);
                this.setContent((BWidget)videoPlayback2);
                BAlarmConsoleVideoPlayerDialog.hookViewToCamera((BObject)videoCameraObject, (BAlarmRecord)alarmRecord, (BVideoPlayback)videoPlayback2);
            }
            catch (BajaRuntimeException bre) {
                BDialog.error((BWidget)this, (String)VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo"), (Object)VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo2", new Object[]{bre.getMessage()}), (Throwable)bre);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo"), (Object)VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo"), (Throwable)e);
                e.printStackTrace();
            }
        }
        this.loaded = true;
    }

    public void paint(Graphics g) {
        if (this.loaded) {
            super.paint(g);
        }
    }

    private BAlarmRecord getAlarmRecord(BComponent base, String uuid) {
        if (uuid == null) {
            return null;
        }
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
        BITable result = (BITable)ord.resolve((BObject)base).get();
        TableCursor cur = result.cursor();
        BAlarmRecord alarm = null;
        if (cur.next()) {
            alarm = (BAlarmRecord)cur.get();
        } else {
            ord = BOrd.make((String)("alarm:|bql:select * where uuid = Uuid '" + uuid + "'"));
            result = (BITable)ord.resolve((BObject)base).get();
            cur = result.cursor();
            if (cur.next()) {
                alarm = (BAlarmRecord)cur.get();
            }
        }
        return alarm;
    }

    protected String toSummaryString(BAlarmRecord selectedRecord, BAbsTime alarmTime) {
        StringBuffer s = new StringBuffer(selectedRecord.getAlarmData().gets("msgText", ""));
        if (s.toString().trim().length() > 0) {
            s.append(" <-> ");
        }
        if (alarmTime == null) {
            s.append(selectedRecord.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            s.append(alarmTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        s.append(": (").append(selectedRecord.getAckState()).append(':').append(selectedRecord.getSourceState()).append(") ");
        return s.toString();
    }
}

