/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx.nd;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.query.BQueryEngine;
import com.tridium.remoteVideo.nd.BNiagaraCameraExt;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.videoHx.nd.BCameraLearnEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.hx.HxOp;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType
public class BCameraPointsDiscoveryJob
extends BSafeSimpleJob {
    public static final Type TYPE = Sys.loadType(BCameraPointsDiscoveryJob.class);
    public static Logger log = Logger.getLogger("entsec");

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        HxOp op = (HxOp)cx;
        BNiagaraCameraExt ext = (BNiagaraCameraExt)op.getComponent();
        BNiagaraStation station = (BNiagaraStation)ext.getParent();
        BFoxSession session = RemoteUtil.getFoxSession((BNiagaraStation)station);
        String interest = TYPE + BUuid.make().toString();
        try {
            session.engageNoRetry(interest);
            BComponent root = RemoteUtil.getRemoteComponent((BFoxSession)session, (String)"slot:/");
            root.lease(10);
            BCameraLearnEntry[] learnEntries = this.getLearnEntries(root, cx);
            for (int i = 0; i < learnEntries.length; ++i) {
                this.add("cameraLearnEntry?", (BValue)learnEntries[i]);
                this.setProgress((int)((double)i * 1.0 / (double)learnEntries.length) * 100);
            }
        }
        finally {
            session.disengage(interest);
        }
    }

    private BCameraLearnEntry[] getLearnEntries(BComponent root, Context cx) {
        BITable<?> cameras = this.getCameras(root, cx);
        Column displayNameCol = cameras.getColumns().get(TypeSpecPath.DISPLAY_NAME.path);
        Column deviceType = cameras.getColumns().get("type");
        Column slotPath = cameras.getColumns().get(TypeSpecPath.PARENT_COMPONENT_SLOT_PATH.path);
        Array learnEntries = new Array(BCameraLearnEntry.class);
        TableCursor cursor = cameras.cursor();
        while (cursor.next()) {
            String cameraSlotPath = cursor.cell(slotPath).toString();
            String displayName = cursor.cell(displayNameCol).toString();
            BTypeSpec cameraType = BTypeSpec.make((String)cursor.cell(deviceType).toString());
            if (cameraType.getResolvedType().is(BIRemoteVideoCamera.TYPE)) continue;
            BCameraLearnEntry entry = new BCameraLearnEntry();
            entry.setCameraDescription(displayName);
            entry.setCameraSlotPath(cameraSlotPath);
            entry.setCameraType(cameraType);
            learnEntries.add((Object)entry);
        }
        return (BCameraLearnEntry[])learnEntries.trim();
    }

    private BITable<?> getCameras(BComponent root, Context op) {
        String queryStr = op.getFacets().gets("query", null);
        BQuery query = null;
        try {
            query = (BQuery)ValueDocDecoder.unmarshal((String)queryStr);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to prepare query for remote cameras Discovery", e);
        }
        BQueryEngine engine = BQueryEngine.make((BSpace)root.getSpace());
        BITable table = engine.compile(query, root.getAbsoluteOrd()).execute();
        return table;
    }
}

