/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx.discover;

import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.videoHx.VideoHxUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

@NiagaraType
public abstract class BHxVideoDeviceTableView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxVideoDeviceTableView.class);
    public static final Type TYPE = Sys.loadType(BHxVideoDeviceTableView.class);
    SmartCommand pingDevices;
    AddDevice addDevice;
    EditDevice editDevice;
    AddDiscovered addDiscovered = new AddDiscovered((BHxView)this);

    public Type getType() {
        return TYPE;
    }

    public BHxVideoDeviceTableView() {
        this.registerEvent((Event)this.addDiscovered);
        this.addDevice = new AddDevice((BHxView)this);
        this.registerEvent((Event)this.addDevice);
        this.editDevice = new EditDevice((BHxView)this);
        this.registerEvent((Event)this.editDevice);
        this.pingDevices = new PingDevices((BHxView)this);
        this.registerEvent((Event)this.pingDevices);
    }

    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return null;
    }

    public boolean process(HxOp op) throws Exception {
        if (this.getDiscoveryPreferencesTab(op).process()) {
            return true;
        }
        return super.process(op);
    }

    public abstract BTypeSpec getDeviceTypeSpec(HxOp var1);

    public abstract Type getQueryType(HxOp var1);

    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        BComponent container = this.getContainer(op);
        return VideoHxUtil.getLeafType((BComplex)container).getTypeSpec();
    }

    public BQuery getDiscoverQuery(HxOp op) {
        BObject o;
        BOrd jobOrd;
        Type newType = this.getQueryType(op);
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getLearnRowTypeSpec(op)));
        query.select(new BProjection());
        VideoHxUtil.addVideoDeviceIdToDiscoveryQuery(query, newType);
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BBoolean.TYPE, (String)"dbExistence", (String)secUtilLex.getText("deviceExists"));
        QueryUtil.addHiddenColumns((BQuery)query);
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        if (jobOrdStr != null && (jobOrd = BOrd.make((String)jobOrdStr)) != null && (o = jobOrd.get()) instanceof BJob) {
            BJob job = (BJob)o;
            this.updateExistenceFacets(job, op);
            query.add("base", (BValue)job.getAbsoluteOrd());
        }
        return query;
    }

    public BQuery getQuery(HxOp op) {
        Type newType = this.getQueryType(op);
        BComponent component = (BComponent)op.get();
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getDeviceTypeSpec(op)));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", "Display Name"));
        VideoHxUtil.addVideoDeviceIdToQuery(query, newType);
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status", secUtilLex.getText("status")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    public String[] getDeviceFields(HxOp op) {
        Type newType = this.getQueryType(op);
        return VideoHxUtil.getDeviceFields(newType);
    }

    public String[] getLearnFields(HxOp op) {
        Type newType = this.getQueryType(op);
        Property[] props = VideoHxUtil.getVideoDeviceIdComponent(newType).getPropertiesArray();
        String[] fields = new String[props.length + 1];
        for (int i = 0; i < props.length; ++i) {
            fields[i] = "" + props[i].getName();
        }
        return fields;
    }

    public BJob submitDiscoveryJob(HxOp op) {
        BComponent deviceSys = this.getContainer(op);
        return VideoHxUtil.submitDiscoveryJob(deviceSys);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (VideoHxUtil.isDiscoveryHost(this.getContainer(op))) {
            return new SmartCommand[]{this.discover, this.addDevice, this.editDevice, this.delete, this.pingDevices, this.preferencesCommand, this.filterCommand, this.refresh, this.hyperlinkCommand, this.exportCommand, this.learnMode};
        }
        return new SmartCommand[]{this.addDevice, this.editDevice, this.delete, this.pingDevices, this.hyperlinkCommand, this.filterCommand, this.refresh, this.exportCommand};
    }

    public boolean showDiscovered(HxOp op) {
        if (!VideoHxUtil.isDiscoveryHost(this.getContainer(op))) {
            return false;
        }
        boolean cookiePresent = false;
        boolean cookie = false;
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        boolean hasDiscovery = jobOrdStr != null;
        String learnModeCookie = SmartCommand.scopeWithOrd((String)"learnMode", (HxOp)op);
        learnModeCookie = learnModeCookie.replaceAll(":", "");
        String c = op.getCookie(learnModeCookie = learnModeCookie.replaceAll("/", ""));
        if (c != null) {
            cookiePresent = true;
            cookie = c.equals("true");
        }
        return hasDiscovery && !cookiePresent || cookiePresent && cookie;
    }

    public String getPageTitle(HxOp op) {
        return "";
    }

    public boolean showDiscoveryDialog(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        if (!(preferences instanceof BNDiscoveryPreferences)) {
            return false;
        }
        return !((BNDiscoveryPreferences)preferences).getDoNotAskAgain();
    }

    public Tab getDiscoveryPreferencesTab(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        HxOp tabOp = op.make("additionalFields", (BObject)preferences, null);
        SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, tabOp);
    }

    public BComponent getContainer(HxOp op) {
        return (BComponent)op.get();
    }

    public BComponent[] getAllDevices(Type deviceType, HxOp op) {
        ArrayList<BComponent> list = new ArrayList<BComponent>();
        this.getAllDevices(this.getContainer(op), deviceType, list);
        if (list.size() > 0) {
            return list.toArray(new BComponent[list.size()]);
        }
        return new BComponent[0];
    }

    private void getAllDevices(BComponent comp, Type deviceType, ArrayList<BComponent> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(deviceType)) {
                list.add(kid);
                continue;
            }
            this.getAllDevices(kid, deviceType, list);
        }
    }

    void updateExistenceFacets(BJob job, HxOp op) {
        BComponent[] deviceArr = this.getAllDevices(this.getQueryType(op), op);
        SlotCursor c = job.getProperties();
        while (c.next(BINDiscoveryLeaf.class)) {
            Property prop = c.property();
            BFacets facets = job.getSlotFacets((Slot)prop);
            BINDiscoveryLeaf device = (BINDiscoveryLeaf)job.get(prop);
            BBoolean exists = BBoolean.FALSE;
            for (int i = 0; i < deviceArr.length; ++i) {
                if (!device.isExisting(deviceArr[i])) continue;
                exists = BBoolean.TRUE;
                break;
            }
            job.setFacets((Slot)prop, BFacets.make((BFacets)facets, (String)"dbExistence", (BIDataValue)exists));
        }
    }

    static BComponent[] getSelectedDevices(HxOp op) {
        Object[] selectionList = BHxVideoDeviceTableView.getSubjects((HxOp)op);
        if (selectionList != null && selectionList.length > 0) {
            int len = selectionList.length;
            BComponent[] stations = new BComponent[len];
            for (int i = 0; i < len; ++i) {
                stations[i] = (BComponent)selectionList[i];
            }
            return stations;
        }
        return null;
    }

    static BObject readProperty(String name, HxOp op, Property prop) {
        return BHxVideoDeviceTableView.readProperty(name, op, (BObject)prop.getDefaultValue());
    }

    static BObject readProperty(String name, HxOp op, BObject defaultVal) {
        try {
            BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
            try {
                editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return editor.save(op.make(name, new OrdTarget((OrdTarget)op, defaultVal)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void writeProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex) throws Exception {
        if (lex == null) {
            lex = Lexicon.make(obj.getClass());
        }
        BHxVideoDeviceTableView.writeProperty(name, op, (BObject)obj.get(prop), lex.get(prop.getName(), TextUtil.toFriendly((String)prop.getName())), obj.getSlotFacets((Slot)prop), false);
    }

    static void writeProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
        try {
            editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        }
        catch (Exception exception) {
            // empty catch block
        }
        OrdTarget target = new OrdTarget((OrdTarget)op, defaultVal);
        HxOp fieldOp = op.make(name, defaultVal, facets);
        fieldOp.setReadonly(readonly);
        out.w((Object)"<tr ");
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)displayName);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        editor.write(fieldOp);
        out.w((Object)"</td></tr>");
    }

    public class PingDevices
    extends SmartCommand {
        public PingDevices(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "pingDevices";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            Object[] devices = BHxQueryTableView.getSubjects((HxOp)op);
            for (int i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BDevice)) continue;
                BDevice device = (BDevice)devices[i];
                device.ping();
            }
            BHxVideoDeviceTableView.this.reloadTables(op);
        }
    }

    static class ErrorDialog
    extends Dialog {
        String msg;
        String details;

        public ErrorDialog(String title, Command handler, String msg, String details) {
            super(title, handler);
            this.msg = msg;
            this.details = details;
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this)};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"errorDialog", (HxOp)op);
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            out.w((Object)"<td>");
            if (this.details != null) {
                StringWriter w = new StringWriter();
                HtmlWriter h = new HtmlWriter((Writer)w);
                h.w((Object)"<pre><code>");
                h.safe((Object)this.details);
                h.w((Object)"</code></pre>");
                String ex = TextUtil.replace((String)w.toString(), (String)"\n", (String)"<br/>");
                ex = TextUtil.replace((String)ex, (String)"\r", (String)"");
                out.w((Object)ex);
            }
            out.w((Object)"");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    static class ConfirmDialog
    extends Dialog {
        String msg;

        public ConfirmDialog(String title, Command handler, String msg) {
            super(title, handler);
            this.msg = msg;
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"confirmDialog", (HxOp)op);
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            out.w((Object)"<b>").safe((Object)this.msg).w((Object)"&nbsp;</b>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    class EditDevice
    extends SmartCommand {
        EditDeviceDialog addDeviceDlg;

        public EditDevice(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxVideoDeviceTableView.secUtilLex.module));
            this.addDeviceDlg = new EditDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public BComponent getSelectedComponent(HxOp op) {
            String[] sel = EditDevice.getSelectionList((HxOp)op);
            String slotPath = sel[0];
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            return (BComponent)ord.get(op.get());
        }

        public void handle(HxOp op) throws Exception {
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent newC = this.getSelectedComponent(op);
            MgrColumn[] cols = VideoHxUtil.getMgrColumns(newC);
            String name = BHxVideoDeviceTableView.readProperty("name", op, (BObject)BString.DEFAULT).toString();
            for (int i = 0; i < cols.length; ++i) {
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxVideoDeviceTableView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, (Context)op);
            }
            if (!name.equals(newC.getName())) {
                BHxVideoDeviceTableView.this.getContainer(op).rename(newC.getPropertyInParent(), SlotPath.escape((String)name));
            }
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        class EditDeviceDialog
        extends Dialog {
            public EditDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Lexicon lex = Lexicon.make(BHxVideoDeviceTableView.class);
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = EditDevice.this.getSelectedComponent(op);
                MgrColumn[] cols = VideoHxUtil.getMgrColumns(newC);
                BHxVideoDeviceTableView.writeProperty("name", op, (BObject)BString.make((String)SlotPath.unescape((String)newC.getName())), "Name", BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    op.setReadonly(cols[i].isReadonly());
                    BHxVideoDeviceTableView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, cols[i].getDisplayName(), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), false);
                }
                out.w((Object)"</table>");
            }
        }
    }

    class AddDevice
    extends SmartCommand {
        AddDeviceDialog addDeviceDlg;

        public AddDevice(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxVideoDeviceTableView.secUtilLex.module));
            this.addDeviceDlg = new AddDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "new";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public String getDefaultDisplayName(HxOp op) {
            return this.getNewComponent(op).getType().getDisplayName((Context)op);
        }

        public BComponent getNewComponent(HxOp op) {
            Type newType = BHxVideoDeviceTableView.this.getQueryType(op);
            return (BComponent)newType.getInstance();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            SmartCommand[] cmds = (SmartCommand[])this.addDeviceDlg.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                if (!cmds[i].process(op)) continue;
                return true;
            }
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent newC = this.getNewComponent(op);
            MgrColumn[] cols = VideoHxUtil.getMgrColumns(newC);
            String name = SlotPath.escape((String)BHxVideoDeviceTableView.readProperty("name", op, (BObject)BString.DEFAULT).toString());
            for (int i = 0; i < cols.length; ++i) {
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxVideoDeviceTableView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, null);
            }
            BHxVideoDeviceTableView.this.getContainer(op).add(name, (BValue)newC);
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        class AddDeviceDialog
        extends Dialog {
            public AddDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Lexicon lex = Lexicon.make(BHxVideoDeviceTableView.class);
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = AddDevice.this.getNewComponent(op);
                MgrColumn[] cols = VideoHxUtil.getMgrColumns(newC);
                BHxVideoDeviceTableView.writeProperty("name", op, (BObject)BString.make((String)AddDevice.this.getDefaultDisplayName(op)), lex.getText("displayName"), BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    op.setReadonly(cols[i].isReadonly());
                    BHxVideoDeviceTableView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, cols[i].getDisplayName(), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), false);
                }
                out.w((Object)"</table>");
            }
        }
    }

    class AddDiscovered
    extends AddDevice {
        public AddDiscovered(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "add";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        @Override
        public String getDefaultDisplayName(HxOp op) {
            Object[] selectionList = BHxQueryTableView.getSubjects((HxOp)op.make("discover", (OrdTarget)op));
            return SlotPath.unescape((String)VideoHxUtil.getComponentNameFromLeaf(BHxVideoDeviceTableView.this.getContainer(op), (BComplex)selectionList[0], (Context)op));
        }

        @Override
        public BComponent getNewComponent(HxOp op) {
            Object[] selectionList = BHxQueryTableView.getSubjects((HxOp)op.make("discover", (OrdTarget)op));
            return VideoHxUtil.getComponentFromLeaf(BHxVideoDeviceTableView.this.getContainer(op), (BComplex)selectionList[0], (Context)op);
        }
    }
}

