/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ux.BWebLiveVideo;
import com.tridium.videoDriver.ux.BWebVideoPlayback;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import com.tridiumx.videoHx.BLiveVideoViewer;
import com.tridiumx.videoHx.BVideoPlaybackViewer;
import com.tridiumx.videoHx.VideoHxUtil;
import com.tridiumx.videoHx.discover.BHxVideoEventTableView;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"naxisVideo:AxisVideoCamera", "nmilestone:MilestoneCamera", "xprotect:XProtectCamera", "videoDriver:IVideoCamera", "maxpro:MaxproCamera"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxVideoCamera
extends BHxManageDevicesView {
    public static final BHxVideoCamera INSTANCE = new BHxVideoCamera();
    public static final Type TYPE = Sys.loadType(BHxVideoCamera.class);
    Command liveView = new LiveViewCommand((BHxView)this);
    Command videoPlaybackView;

    public Type getType() {
        return TYPE;
    }

    protected BHxVideoCamera() {
        this.registerEvent((Event)this.liveView);
        this.videoPlaybackView = new VideoPlaybackCommand((BHxView)this);
        this.registerEvent((Event)this.videoPlaybackView);
    }

    public BTypeSpec getTypeSpec(HxOp op) {
        return BTypeSpec.make((String)"videoDriver", (String)"IVideoCamera");
    }

    public BComponent getContainer(OrdTarget target) {
        BComponent c = super.getContainer(target);
        return (BComponent)c.get("events");
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array((Object[])super.getButtonCommands(op));
        for (int i = 0; i < arr.size(); ++i) {
            if (!(arr.get(i) instanceof ManageDevicesCommand)) continue;
            arr.remove(i);
        }
        if (BEnterpriseSecurityService.isVideoDriverAvailable()) {
            BIVideoCamera camera = (BIVideoCamera)op.get();
            BDeviceNetwork videoNetwork = this.getNetworkForCamera(camera);
            try {
                Feature licenseFeature = videoNetwork.getLicenseFeature();
                if (licenseFeature != null) {
                    licenseFeature.check();
                    arr.add((Object)this.liveView);
                    AgentList agents = op.getComponent().getAgents((Context)op).filter(AgentFilter.is((Type)BVideoPlayback.TYPE));
                    if (agents.size() > 0) {
                        arr.add((Object)this.videoPlaybackView);
                    }
                }
            }
            catch (FeatureNotLicensedException featureNotLicensedException) {
                // empty catch block
            }
        }
        return (SmartCommand[])arr.trim();
    }

    private BDeviceNetwork getNetworkForCamera(BIVideoCamera camera) {
        BComplex temp = camera.asObject().asComplex();
        while (!temp.getType().is(BDeviceNetwork.TYPE)) {
            temp = temp.getParent();
        }
        return (BDeviceNetwork)temp;
    }

    public String[] getProperties(HxOp op) {
        BComponent c = (BComponent)op.get();
        Property[] props = c.getPropertiesArray();
        Array returnedProps = new Array(String.class);
        for (int i = 0; i < props.length; ++i) {
            Type propType = props[i].getType();
            if (propType.is(BDeviceExt.TYPE)) continue;
            returnedProps.add((Object)props[i].getName());
        }
        return (String[])returnedProps.trim();
    }

    public Tab[] getTabs(HxOp op) throws Exception {
        Object[] defaultTabs = super.getTabs(op);
        VideoHxUtil.registerOptionalFieldEditors(defaultTabs[0], op);
        Array a = new Array(defaultTabs);
        BComponent ext = (BComponent)((BComponent)op.get()).get("events");
        if (ext != null && !Flags.isHidden((BComplex)((BComponent)op.get()), (Slot)ext.getPropertyInParent())) {
            HxOp tabOp = op.make("events", (BObject)ext, null);
            SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
            Tab dvrs = new Tab((BHxView)BHxVideoEventTableView.INSTANCE, "Events", tabOp);
            a.add((Object)dvrs);
        }
        return (Tab[])a.trim();
    }

    public static class VideoPlaybackCommand
    extends SmartCommand {
        public VideoPlaybackCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "videoPlaybackView";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = null;
            boolean isNiagaraWebLauncher = op.getUserAgent() != null && op.getUserAgent().isNiagaraWebLauncher();
            ord = isNiagaraWebLauncher ? BOrd.make((String)("local:|station:|" + ((BComponent)op.get()).getSlotPath() + "|view:" + BVideoPlaybackViewer.TYPE)) : BOrd.make((String)("local:|station:|" + ((BComponent)op.get()).getSlotPath() + "|view:" + BWebVideoPlayback.TYPE));
            this.redirect(op, op.toUri(ord));
        }
    }

    public static class LiveViewCommand
    extends SmartCommand {
        public LiveViewCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "liveCameraView";
        }

        public boolean isDefaultAction() {
            return true;
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = null;
            boolean isNiagaraWebLauncher = op.getUserAgent() != null && op.getUserAgent().isNiagaraWebLauncher();
            ord = isNiagaraWebLauncher ? BOrd.make((String)("local:|station:|" + ((BComponent)op.get()).getSlotPath() + "|view:" + BLiveVideoViewer.TYPE)) : BOrd.make((String)("local:|station:|" + ((BComponent)op.get()).getSlotPath() + "|view:" + BWebLiveVideo.TYPE));
            this.redirect(op, op.toUri(ord));
        }
    }
}

