/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridiumX.knxnetIp.comms.BDiscoveryKnxInstallations;
import com.tridiumX.knxnetIp.comms.BLocalInterfaces;
import com.tridiumX.knxnetIp.wb.BDiscoverDevicesOptions;
import com.tridiumX.knxnetIp.wb.BDiscoverDevicesPane;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.IImportEtsProjectFilesManager;
import com.tridiumX.knxnetIp.wb.IKnxDeviceManager;
import com.tridiumX.knxnetIp.wb.ImportEtsProjectFilesController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;

public final class DiscoverDevicesController {
    private static final Logger log = Logger.getLogger("knxnetIp.deviceDiscovery");

    public CommandArtifact doImport(BDeviceManager manager, String dialogTitle, BLocalInterfaces localInterfaces, Context cx) throws Exception {
        boolean importOnly = false;
        int lastUsedDiscoveryKnxInstallation = BKnxWbService.getImportSettings().getLastUsedDiscoveryKnxInstallation();
        BDynamicEnum knxInstallationsEnum = localInterfaces.fetchKnxInstallations(BInteger.make((int)lastUsedDiscoveryKnxInstallation));
        if (knxInstallationsEnum == null) {
            importOnly = true;
        }
        BDiscoverDevicesPane importPane = new BDiscoverDevicesPane(knxInstallationsEnum, importOnly);
        boolean bFinished = false;
        while (!bFinished) {
            int dialogResult = BDialog.open((BWidget)manager, (String)dialogTitle, (Object)((Object)importPane), (int)3);
            if (dialogResult == 2) {
                bFinished = true;
                continue;
            }
            if (dialogResult == 1) {
                try {
                    BDiscoverDevicesOptions importOptions = importPane.getImportOptions();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("User clicked OK with options : " + importOptions.toDebugString());
                    }
                    bFinished = this.processImportOptions(manager, importOptions, cx);
                }
                catch (Exception ex) {
                    BDialog.error((BWidget)manager, (Object)("Could not import the selected file.\n\r" + ex.getMessage()));
                }
                continue;
            }
            throw new Exception("The \"" + dialogTitle + "\" dialog returned a value (" + dialogResult + ") other than \"BDialog.OK\" (" + 1 + ") or \"BDialog.CANCEL\" (" + 2 + ").");
        }
        return null;
    }

    boolean processImportOptions(BDeviceManager manager, BDiscoverDevicesOptions importOptions, Context cx) throws Exception {
        boolean bFinished;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Processing Import Options : " + importOptions.toString(cx));
        }
        BDynamicEnum knxInstallation = importOptions.getKnxInstallation();
        BKnxWbService.getImportSettings().setLastDevicesDiscoveryFromNetwork(importOptions.getDiscoverDevices());
        if (!importOptions.getDiscoverDevices()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Importing from ETS project file/cache.");
            }
            bFinished = new ImportEtsProjectFilesController().processImportOptions((BAbstractManager)manager, importOptions.getImportOptions(), cx);
        } else {
            int[] ordinals;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Searching network for Devices.");
            }
            BKnxWbService.getImportSettings().setLastUsedDiscoveryKnxInstallation(knxInstallation.getOrdinal());
            BDiscoveryKnxInstallations discoveryKnxInstallations = new BDiscoveryKnxInstallations();
            BEnumRange er = knxInstallation.getRange();
            for (int ordinal : ordinals = er.getOrdinals()) {
                discoveryKnxInstallations.add(er.getTag(ordinal), (BValue)BInteger.make((int)ordinal));
            }
            discoveryKnxInstallations.setKnxInstallationToSearch(knxInstallation.getOrdinal());
            bFinished = this.processImportRequest((IImportEtsProjectFilesManager)manager, discoveryKnxInstallations, cx);
            BKnxWbService.doSaveSettings();
        }
        return bFinished;
    }

    private boolean processImportRequest(IImportEtsProjectFilesManager manager, BDiscoveryKnxInstallations discoveryKnxInstallations, Context cx) throws Exception {
        try {
            if (manager instanceof IKnxDeviceManager) {
                IKnxDeviceManager devManager = (IKnxDeviceManager)manager;
                return devManager.processDiscoveryRequest(discoveryKnxInstallations, cx);
            }
            return false;
        }
        catch (Exception ex) {
            throw new Exception("An Exception occurred in " + this.getClass().getName() + ":processImportRequest(...).", ex);
        }
    }
}

