/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.ui.BCheckDataDefsDialog;
import com.tridiumX.knxnetIp.ui.ICheckDataDefsDialogClient;
import com.tridiumX.knxnetIp.util.CatchAll;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import com.tridiumX.knxnetIp.wb.IImportEtsProjectFilesManager;
import com.tridiumX.knxnetIp.wb.ImportEtsProjectFilesController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:ImportedEtsProjectFiles"})})
public final class BEtsProjectFileImportManager
extends BAbstractManager
implements IImportEtsProjectFilesManager,
ICheckDataDefsDialogClient {
    public static final Type TYPE = Sys.loadType(BEtsProjectFileImportManager.class);
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName() + ".etsProjectFileImportManager");
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());

    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        BJob job;
        super.deactivated();
        EtsProjectFileImportLearn learn = (EtsProjectFileImportLearn)this.getLearn();
        if (learn != null && (job = learn.getJob()) != null) {
            if (job.getJobState().isRunning()) {
                job.cancel();
            }
            job.dispose();
        }
    }

    protected MgrController makeController() {
        return new EtsProjectFileImportController(this);
    }

    protected MgrLearn makeLearn() {
        return new EtsProjectFileImportLearn(this);
    }

    protected MgrModel makeModel() {
        return new EtsProjectFileImportModel(this);
    }

    public void doLoadValue(BObject obj, Context cx) {
        try {
            long start = System.currentTimeMillis();
            BCheckDataDefsDialog.doCheckDataDefs(this, obj, cx);
            if (log.isLoggable(Level.FINE)) {
                System.out.println("BEtsProjectFileImportManager.doLoadValue(...) Total: " + (System.currentTimeMillis() - start));
            }
            this.getController().updateCommands();
        }
        catch (Throwable t) {
            CatchAll.throwable((Throwable)t);
        }
    }

    @Override
    public BKnxNetwork getNetwork() {
        return null;
    }

    @Override
    public void doLoadValueAsync(BObject obj, Context cx) {
        long start = System.currentTimeMillis();
        super.doLoadValue(obj, cx);
        if (log.isLoggable(Level.FINE)) {
            System.out.println("BEtsProjectFileImportManager.doLoadValueAsync: " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    public void clearDiscoveredRows() {
    }

    class EtsProjectFileImportModel
    extends MgrModel {
        public EtsProjectFileImportModel(BEtsProjectFileImportManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BImportedEtsProjectFile.checkForSourceFileChanges, 2), new MgrColumn.Prop(BImportedEtsProjectFile.lastVerifiedTime, 2), new MgrColumn.Prop(BImportedEtsProjectFile.lastVerificationResult), new MgrColumn.Prop(BImportedEtsProjectFile.importState), new MgrColumn.Prop(BImportedEtsProjectFile.lastImportedFileModificationTime), new MgrColumn.Prop(BImportedEtsProjectFile.etsNamespace), new MgrColumn.Prop(BImportedEtsProjectFile.groupAddressStyle), new MgrColumn.Prop(BImportedEtsProjectFile.groupAddressCount), new MgrColumn.Prop(BImportedEtsProjectFile.maxGroupDepth)};
        }
    }

    class EtsProjectFileImportLearn
    extends MgrLearn {
        public EtsProjectFileImportLearn(BEtsProjectFileImportManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[0];
        }

        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            return null;
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
        }
    }

    final class EtsProjectFileImportController
    extends MgrController {
        public final MgrController.MgrCommand importCommand;

        public EtsProjectFileImportController(BEtsProjectFileImportManager manager) {
            super((BAbstractManager)manager);
            this.importCommand = new ImportCommand((BWidget)manager);
            this.importCommand.setFlags(7);
        }

        public CommandArtifact doImport(Context cx) throws Exception {
            BWidget centre;
            BWidget jobBar = ((BEdgePane)this.getManager().getContent()).getTop();
            if ((jobBar == null || jobBar instanceof BNullWidget) && (centre = ((BEdgePane)this.getManager().getContent()).getCenter()) instanceof BSplitPane) {
                BEdgePane pane = (BEdgePane)((BSplitPane)centre).getWidget1();
                BBorderPane borderPane = (BBorderPane)pane.getTop();
                pane.setTop((BWidget)new BNullWidget());
                ((BEdgePane)this.getManager().getContent()).setTop((BWidget)borderPane);
            }
            return new ImportEtsProjectFilesController().doImport(this.getManager(), "Import an ETS project file", true, cx);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.importCommand, this.cancel};
        }

        public void updateCommands() {
            super.updateCommands();
            this.importCommand.setEnabled(this.discover.isEnabled() && BKnxWbService.getService().getKnxDataDefs().isDataIntegrityGood(false));
        }

        final class ImportCommand
        extends MgrController.MgrCommand {
            ImportCommand(BWidget owner) {
                super(owner, lex, "import");
            }

            public CommandArtifact doInvoke() throws Exception {
                return EtsProjectFileImportController.this.doImport(null);
            }
        }
    }
}

