/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui.editors;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BGroupAddresses;
import com.tridiumX.knxnetIp.ui.editors.BGroupAddressFE;
import java.text.MessageFormat;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"knxnetIp:GroupAddresses"})})
@NiagaraAction(name="propagateSelectionModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public final class BGroupAddressesFE
extends BWbFieldEditor {
    public static final Action propagateSelectionModified = BGroupAddressesFE.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BGroupAddressesFE.class);
    BGroupAddresses groupAddresses;
    final BList displayList;
    final BButton addButton;
    final BButton delButton;
    final BButton modButton;
    final BScrollPane scrollPane;
    final BConstrainedPane constrainedPane;
    public static final UiLexicon lex = UiLexicon.makeUiLexicon((BModule)TYPE.getModule());
    static final BImage addIcon = BImage.make((String)"module://icons/x16/add.png");
    static final BImage removeIcon = BImage.make((String)"module://icons/x16/subtract.png");
    static final BImage modifyIcon = BImage.make((String)"module://icons/x16/badges/edit.png");
    private static final String GROUP_ADDRESSES_DIALOG_BASE_LEX_KEY = "groupAddressesDialog.";
    private static final String GROUP_ADDRESSES_DIALOG_ADD_COMMAND_LEX_KEY = "groupAddressesDialog.add";
    private static final String GROUP_ADDRESSES_DIALOG_ADD_COMMAND_DEFAULT = "add";
    private static final String GROUP_ADDRESSES_DIALOG_ADD_DESCRIPTION_LEX_KEY = "groupAddressesDialog.add.desc";
    private static final String GROUP_ADDRESSES_DIALOG_ADD_DESCRIPTION_DEFAULT = "Add a new 'GroupAddress'.";
    private static final String GROUP_ADDRESSES_DIALOG_DELETE_COMMAND_LEX_KEY = "groupAddressesDialog.delete";
    private static final String GROUP_ADDRESSES_DIALOG_DELETE_COMMAND_DEFAULT = "delete";
    private static final String GROUP_ADDRESSES_DIALOG_DELETE_DESCRIPTION_LEX_KEY = "groupAddressesDialog.delete.desc";
    private static final String GROUP_ADDRESSES_DIALOG_DELETE_DESCRIPTION_DEFAULT = "Remove one or more 'GroupAddresses'.";
    private static final String GROUP_ADDRESSES_DIALOG_EDIT_COMMAND_LEX_KEY = "groupAddressesDialog.edit";
    private static final String GROUP_ADDRESSES_DIALOG_EDIT_COMMAND_DEFAULT = "edit";
    private static final String GROUP_ADDRESSES_DIALOG_EDIT_DESCRIPTION_LEX_KEY = "groupAddressesDialog.edit.desc";
    private static final String GROUP_ADDRESSES_DIALOG_EDIT_DESCRIPTION_DEFAULT = "Modify an existing 'GroupAddress'.";
    private static final String NEW_GROUP_ADDRESS_SLOT_NAME = "groupAddress?";
    private static final String ADD_NEW_GROUP_ADDRESS_DIALOG_BASE_LEX_KEY = "addGroupAddressDialog.";
    private static final String ADD_NEW_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY = "addGroupAddressDialog.title";
    private static final String ADD_NEW_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT = "Add a new 'GroupAddress'";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_BASE_LEX_KEY = "cannotAddGroupAddressDialog.";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY = "cannotAddGroupAddressDialog.title";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT = "Cannot Add 'GroupAddress'";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_ADDRESS_RESERVED_LEX_KEY = "cannotAddGroupAddressDialog.addressReserved";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_ADDRESS_RESERVED_DEFAULT = "Group Address {0} is reserved.";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_LEX_KEY = "cannotAddGroupAddressDialog.alreadyInList";
    private static final String CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_DEFAULT = "This 'GroupAddress' ({0}) is already in the list of addresses.";
    private static final String ADDING_GROUP_ADDRESSES_DIALOG_BASE_LEX_KEY = "addingGroupAddressesDialog.";
    private static final String ADDING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY = "addingGroupAddressesDialog.title";
    private static final String ADDING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT = "Adding 'GroupAddresses'";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_BASE_LEX_KEY = "deletingGroupAddressesDialog.";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY = "deletingGroupAddressesDialog.title";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT = "Deleting 'GroupAddresses'";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_CANT_DELETE_PRIMARY_MESSAGE_LEX_KEY = "deletingGroupAddressesDialog.cantDeletePrimary";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_CANT_DELETE_PRIMARY_MESSAGE_DEFAULT = "The primary (first) 'GroupAddresses' cannot be deleted.";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_NOTHING_TO_DELETE_MESSAGE_LEX_KEY = "deletingGroupAddressesDialog.nothingToDelete";
    private static final String DELETING_GROUP_ADDRESSES_DIALOG_NOTHING_TO_DELETE_MESSAGE_DEFAULT = "There are no 'GroupAddresses' selected for deletion.";
    private static final String EDITING_GROUP_ADDRESSES_DIALOG_BASE_LEX_KEY = "editingGroupAddressesDialog.";
    private static final String EDITING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY = "editingGroupAddressesDialog.title";
    private static final String EDITING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT = "Editing 'GroupAddresses'";
    private static final String CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_BASE_LEX_KEY = "confirmGroupAddressDelete.";
    private static final String CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_TITLE_LEX_KEY = "confirmGroupAddressDelete.title";
    private static final String CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_TITLE_DEFAULT = "Confirm 'GroupAddress' deletion";
    private static final String CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_MESSAGE_LEX_KEY = "confirmGroupAddressDelete.message";
    private static final String CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_MESSAGE_DEFAULT = "Delete the selected addresses?";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_BASE_LEX_KEY = "editGroupAddressDialog.";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY = "editGroupAddressDialog.title";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT = "Edit 'GroupAddress'";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_ONE_AT_A_TIME_MESSAGE_LEX_KEY = "editGroupAddressDialog.oneAtATime";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_ONE_AT_A_TIME_MESSAGE_DEFAULT = "'GroupAddresses' can only be edited one at a time.";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_NOTHING_TO_EDIT_MESSAGE_LEX_KEY = "editGroupAddressDialog.nothingToEdit";
    private static final String EDIT_GROUP_ADDRESS_DIALOG_NOTHING_TO_EDIT_MESSAGE_DEFAULT = "There are no 'GroupAddresses' selected for editing.";

    public void propagateSelectionModified(BWidgetEvent parameter) {
        this.invoke(propagateSelectionModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BGroupAddressesFE() {
        Command addCmd = new Command((BWidget)this, lex.get(GROUP_ADDRESSES_DIALOG_ADD_COMMAND_LEX_KEY, GROUP_ADDRESSES_DIALOG_ADD_COMMAND_DEFAULT), addIcon, null, lex.get(GROUP_ADDRESSES_DIALOG_ADD_DESCRIPTION_LEX_KEY, GROUP_ADDRESSES_DIALOG_ADD_DESCRIPTION_DEFAULT)){

            public CommandArtifact doInvoke() {
                BGroupAddressesFE.this.doAddDialog();
                return null;
            }
        };
        Command delCmd = new Command((BWidget)this, lex.get(GROUP_ADDRESSES_DIALOG_DELETE_COMMAND_LEX_KEY, GROUP_ADDRESSES_DIALOG_DELETE_COMMAND_DEFAULT), removeIcon, null, lex.get(GROUP_ADDRESSES_DIALOG_DELETE_DESCRIPTION_LEX_KEY, GROUP_ADDRESSES_DIALOG_DELETE_DESCRIPTION_DEFAULT)){

            public CommandArtifact doInvoke() {
                BGroupAddressesFE.this.doDelDialog();
                return null;
            }
        };
        Command modCmd = new Command((BWidget)this, lex.get(GROUP_ADDRESSES_DIALOG_EDIT_COMMAND_LEX_KEY, GROUP_ADDRESSES_DIALOG_EDIT_COMMAND_DEFAULT), modifyIcon, null, lex.get(GROUP_ADDRESSES_DIALOG_EDIT_DESCRIPTION_LEX_KEY, GROUP_ADDRESSES_DIALOG_EDIT_DESCRIPTION_DEFAULT)){

            public CommandArtifact doInvoke() {
                BGroupAddressesFE.this.doModifyDialog();
                return null;
            }
        };
        this.addButton = new BButton(addCmd);
        this.delButton = new BButton(delCmd);
        this.delButton.setEnabled(false);
        this.modButton = new BButton(modCmd);
        this.modButton.setEnabled(false);
        this.displayList = new BList();
        this.linkTo("lk0", (BComponent)this.displayList, (Slot)BList.selectionModified, (Slot)propagateSelectionModified);
        this.scrollPane = new BScrollPane((BWidget)this.displayList);
        this.scrollPane.setHpolicy(BScrollBarPolicy.never);
        this.scrollPane.setVpolicy(BScrollBarPolicy.always);
        this.constrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
        this.constrainedPane.setMinWidth(75.0);
        this.constrainedPane.setMaxHeight(100.0);
        BGridPane grid = new BGridPane(4);
        grid.setStretchColumn(0);
        grid.add("field1", (BValue)this.constrainedPane);
        BToolBar addPane = new BToolBar();
        addPane.add("b", (BValue)this.addButton);
        grid.add("addButton", (BValue)addPane);
        BToolBar delPane = new BToolBar();
        delPane.add("c", (BValue)this.delButton);
        grid.add("delButton", (BValue)delPane);
        BToolBar modifyPane = new BToolBar();
        delPane.add("d", (BValue)this.modButton);
        grid.add("modButton", (BValue)modifyPane);
        this.setContent((BWidget)grid);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.groupAddresses = (BGroupAddresses)value;
        this.updateDisplayList();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return value;
    }

    public void doPropagateSelectionModified(BWidgetEvent evt) {
        int[] selIdxs = this.displayList.getSelectedIndices();
        this.modButton.setEnabled(selIdxs.length == 1);
        boolean bDeleteEnabled = true;
        if (selIdxs.length == 0) {
            bDeleteEnabled = false;
        } else {
            for (int selIdx : selIdxs) {
                if (selIdx != 0) continue;
                bDeleteEnabled = false;
                break;
            }
        }
        this.delButton.setEnabled(bDeleteEnabled);
    }

    public void doAddDialog() {
        BGroupAddress ga = new BGroupAddress(this.groupAddresses.getPrimaryGroupAddress().getStyle());
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                ga = (BGroupAddress)BWbFieldEditor.dialog((BWidget)this, (String)lex.get(ADD_NEW_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY, ADD_NEW_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT), (BObject)ga, (Context)BFacets.make((String)"fieldEditor", (String)BGroupAddressFE.TYPE.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (ga != null) {
                if (ga.isZero()) {
                    MessageFormat mf = new MessageFormat(lex.get(CANNOT_ADD_GROUP_ADDRESS_DIALOG_ADDRESS_RESERVED_LEX_KEY, CANNOT_ADD_GROUP_ADDRESS_DIALOG_ADDRESS_RESERVED_DEFAULT));
                    BDialog.message((BWidget)this, (String)lex.get(CANNOT_ADD_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY, CANNOT_ADD_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT), (Object)mf.format(new Object[]{ga.getFriendlyAddress()}));
                    continue;
                }
                BGroupAddress[] oldAddrs = (BGroupAddress[])this.groupAddresses.getChildren(BGroupAddress.class);
                boolean alreadyInList = false;
                for (BGroupAddress oldAddr : oldAddrs) {
                    if (oldAddr.getAddress() != ga.getAddress()) continue;
                    MessageFormat mf = new MessageFormat(lex.get(CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_LEX_KEY, CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_DEFAULT));
                    BDialog.info((BWidget)this, (String)lex.get(ADDING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, ADDING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)mf.format(new Object[]{ga.getFriendlyAddress()}));
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                this.groupAddresses.add(NEW_GROUP_ADDRESS_SLOT_NAME, (BValue)ga);
                this.updateDisplayList();
                keepTrying = false;
                continue;
            }
            keepTrying = false;
        }
    }

    public void doDelDialog() {
        Object[] selection = this.displayList.getSelectedItems();
        if (selection.length == 0) {
            BDialog.info((BWidget)this, (String)lex.get(DELETING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, DELETING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)lex.get(DELETING_GROUP_ADDRESSES_DIALOG_NOTHING_TO_DELETE_MESSAGE_LEX_KEY, DELETING_GROUP_ADDRESSES_DIALOG_NOTHING_TO_DELETE_MESSAGE_DEFAULT));
            return;
        }
        for (Object o : selection) {
            if (!this.groupAddresses.getPrimaryGroupAddress().equals(o)) continue;
            BDialog.info((BWidget)this, (String)lex.get(DELETING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, DELETING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)lex.get(DELETING_GROUP_ADDRESSES_DIALOG_CANT_DELETE_PRIMARY_MESSAGE_LEX_KEY, DELETING_GROUP_ADDRESSES_DIALOG_CANT_DELETE_PRIMARY_MESSAGE_DEFAULT));
            return;
        }
        int answer = BDialog.confirm((BWidget)this, (String)lex.get(CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_TITLE_LEX_KEY, CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_TITLE_DEFAULT), (Object)lex.get(CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_MESSAGE_LEX_KEY, CONFIRM_GROUP_ADDRESS_DELETE_DIALOG_MESSAGE_DEFAULT));
        if (answer == 8) {
            return;
        }
        for (Object o : selection) {
            BGroupAddress comp = (BGroupAddress)o;
            this.groupAddresses.remove((BComplex)comp);
        }
        this.updateDisplayList();
        this.displayList.setSelectedItem(null);
    }

    public void doModifyDialog() {
        Object[] selection = this.displayList.getSelectedItems();
        if (selection.length == 0) {
            BDialog.info((BWidget)this, (String)lex.get(EDITING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, EDITING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)lex.get(EDIT_GROUP_ADDRESS_DIALOG_NOTHING_TO_EDIT_MESSAGE_LEX_KEY, EDIT_GROUP_ADDRESS_DIALOG_NOTHING_TO_EDIT_MESSAGE_DEFAULT));
            return;
        }
        if (selection.length != 1) {
            BDialog.info((BWidget)this, (String)lex.get(EDITING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, EDITING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)lex.get(EDIT_GROUP_ADDRESS_DIALOG_ONE_AT_A_TIME_MESSAGE_LEX_KEY, EDIT_GROUP_ADDRESS_DIALOG_ONE_AT_A_TIME_MESSAGE_DEFAULT));
            return;
        }
        BGroupAddress originalGroupAddress = (BGroupAddress)this.displayList.getSelectedItem();
        BGroupAddress ga = new BGroupAddress(originalGroupAddress.getAddress(), originalGroupAddress.getStyle());
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                ga = (BGroupAddress)BWbFieldEditor.dialog((BWidget)this, (String)lex.get(EDIT_GROUP_ADDRESS_DIALOG_TITLE_LEX_KEY, EDIT_GROUP_ADDRESS_DIALOG_TITLE_DEFAULT), (BObject)ga, (Context)BFacets.make((String)"fieldEditor", (String)BGroupAddressFE.TYPE.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (ga != null) {
                BGroupAddress[] oldAddrs = (BGroupAddress[])this.groupAddresses.getChildren(BGroupAddress.class);
                boolean alreadyInList = false;
                for (BGroupAddress oldAddr : oldAddrs) {
                    if (oldAddr.equals((Object)originalGroupAddress) || oldAddr.getAddress() != ga.getAddress()) continue;
                    MessageFormat mf = new MessageFormat(lex.get(CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_LEX_KEY, CANNOT_ADD_GROUP_ADDRESS_DIALOG_ALREADY_IN_LIST_DEFAULT));
                    BDialog.info((BWidget)this, (String)lex.get(EDITING_GROUP_ADDRESSES_DIALOG_TITLE_LEX_KEY, EDITING_GROUP_ADDRESSES_DIALOG_TITLE_DEFAULT), (Object)mf.format(new Object[]{ga.getFriendlyAddress()}));
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                originalGroupAddress.setAddress(ga.getAddress());
                originalGroupAddress.setStyle(ga.getStyle());
                this.updateDisplayList();
                keepTrying = false;
                continue;
            }
            keepTrying = false;
        }
    }

    private void updateDisplayList() {
        this.displayList.removeAllItems();
        Property[] props = this.groupAddresses.getDynamicPropertiesArray();
        TreeMap<Integer, BGroupAddress> dynamicGroups = new TreeMap<Integer, BGroupAddress>();
        for (Property property : props) {
            if (!property.getType().is(BGroupAddress.TYPE)) continue;
            BGroupAddress groupAddress = (BGroupAddress)this.get(property).as(BGroupAddress.class);
            dynamicGroups.put(groupAddress.getAddress(), groupAddress);
        }
        this.displayList.addItem((Object)this.groupAddresses.getPrimaryGroupAddress());
        dynamicGroups.values().forEach(group -> this.displayList.addItem(group));
        this.relayout();
    }
}

