/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ui;

import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxStationDataDefs;
import com.tridiumX.knxnetIp.ui.BKnxExtraImportDialog;
import com.tridiumX.knxnetIp.xml.IXmlImporterHelper;
import com.tridiumX.knxnetIp.xml.ImportProblemReports;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BKnxDataDefsImportDialog
extends BProgressDialog {
    public static final Type TYPE = Sys.loadType(BKnxDataDefsImportDialog.class);
    private static final Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String IMPORT_DATA_DEFS_DIALOG_BASE_LEX_KEY = "importDataDefsDialog.";
    private static final String IMPORT_DATA_DEFS_DIALOG_TITLE_LEX_KEY = "importDataDefsDialog.title";
    private static final String IMPORT_DATA_DEFS_DIALOG_TITLE_DEFAULT = "Importing 'KNX Data Defs'";
    public static final String DEFAULT_DATA_DEFS_FILE_ORD = "local:|module://knxnetIp/knx/knx_extra.xml";
    public static final FilePath DATA_DEFS_FILE_PATH = new FilePath("!knx/knx_extra.xml");
    private static final Logger LOGGER = Logger.getLogger("knxnetIp.BKnxDataDefsImportDialog");

    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget owner, BKnxStationDataDefs knxDataDefs) {
        BIcon icon = BIcon.make((String)"module://icons/x32/clock.png");
        BKnxDataDefsImportDialog.open((BWidget)owner, (String)lex.get(IMPORT_DATA_DEFS_DIALOG_TITLE_LEX_KEY, IMPORT_DATA_DEFS_DIALOG_TITLE_DEFAULT), (BProgressDialog.Worker)new KNXDataDefsImportWorker(knxDataDefs), (BImage)BImage.make((BIcon)icon));
    }

    public static BKnxStationDataDefs findLatestDefs(BWidget owner) {
        int newVersion;
        ImportProblemReports newImportProblems;
        boolean goodDefaultDefs;
        BKnxStationDataDefs defaultDefs;
        BIFile defaultDefsFile = (BIFile)BOrd.make((String)DEFAULT_DATA_DEFS_FILE_ORD).get();
        ImportProblemReports defaultImportProblems = BKnxExtraImportDialog.doLoadKnxExtraFile(owner, defaultDefsFile, (defaultDefs = new BKnxStationDataDefs()).getKnxDefs());
        if (defaultImportProblems != null && !defaultImportProblems.isEmpty() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Problem importing 'KNX Data Defs' from - local:|module://knxnetIp/knx/knx_extra.xml\n" + defaultImportProblems.getImportProblemReportString());
        }
        int defaultVersion = (goodDefaultDefs = defaultDefs.isDataIntegrityGood(true)) ? Integer.parseInt(defaultDefs.getVersion()) : -1;
        BFileSystem localFs = BFileSystem.INSTANCE;
        BIFile newDefsFile = localFs.findFile(DATA_DEFS_FILE_PATH);
        BKnxStationDataDefs newDefs = new BKnxStationDataDefs();
        ImportProblemReports importProblemReports = newImportProblems = newDefsFile == null ? null : BKnxExtraImportDialog.doLoadKnxExtraFile(owner, newDefsFile, newDefs.getKnxDefs());
        if (newImportProblems != null && !newImportProblems.isEmpty() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Problem importing 'KNX Data Defs' from - " + DATA_DEFS_FILE_PATH + "\n" + newImportProblems.getImportProblemReportString());
        }
        boolean goodNewDefs = newDefs.isDataIntegrityGood(true);
        int n = newVersion = newDefsFile != null && goodNewDefs ? Integer.parseInt(newDefs.getVersion()) : -1;
        return goodNewDefs && newVersion > defaultVersion ? newDefs : (goodDefaultDefs ? defaultDefs : null);
    }

    private static class KNXDataDefsImportWorker
    extends BProgressDialog.Worker
    implements IXmlImporterHelper {
        private static final String IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_BASE_LEX_KEY = "importDataDefsOlderVersionDialog.";
        private static final String IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_TITLE_LEX_KEY = "importDataDefsOlderVersionDialog.title";
        private static final String IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_TITLE_DEFAULT = "Import Older Version";
        private static final String IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_MESSAGE_LEX_KEY = "importDataDefsOlderVersionDialog.message";
        private static final String IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_MESSAGE_DEFAULT = "The version of the ''KNX Data Defs'' you are importing (''{0}'') is older than the currently loaded version (''{1}'').\nAre you sure you want to continue?";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_BASE_LEX_KEY = "importDataDefsProblemDialog.";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_LEX_KEY = "importDataDefsProblemDialog.title";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_DEFAULT = "Problems during 'Load Data Defs'";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_NO_FILE_LEX_KEY = "importDataDefsProblemDialog.missing";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_NO_FILE_DEFAULT = "No 'knx_extra.xml' file was found to load the 'KNX Data Defs' from.";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_DIFFERENT_SIGNATURES_MESSAGE_LEX_KEY = "importDataDefsProblemDialog.differentSignatures";
        private static final String IMPORT_DATA_DEFS_PROBLEM_DIALOG_DIFFERENT_SIGNATURES_MESSAGE_DEFAULT = "The version of the 'KNX Data Defs' you are importing is the same version as the currently loaded version but it has a different signature.";
        private static final String IMPORT_DATA_DEFS_FINISHED_DIALOG_BASE_LEX_KEY = "importDataDefsFinishedDialog.";
        private static final String IMPORT_DATA_DEFS_FINISHED_DIALOG_TITLE_LEX_KEY = "importDataDefsFinishedDialog.title";
        private static final String IMPORT_DATA_DEFS_FINISHED_DIALOG_TITLE_DEFAULT = "Import Finished";
        private static final String IMPORT_DATA_DEFS_FINISHED_DIALOG_MESSAGE_LEX_KEY = "importDataDefsFinishedDialog.message";
        private static final String IMPORT_DATA_DEFS_FINISHED_DIALOG_MESSAGE_DEFAULT = "The 'KNX Data Defs' have been imported successfully.";
        private final BKnxStationDataDefs knxDataDefs;
        private ImportProblemReports importProblemReports;

        public KNXDataDefsImportWorker(BKnxStationDataDefs knxDataDefs) {
            this.knxDataDefs = knxDataDefs;
        }

        public void doRun() throws Exception {
            BKnxStationDataDefs latestDefs = BKnxDataDefsImportDialog.findLatestDefs((BWidget)this.getDialog());
            if (latestDefs != null) {
                int latestVersion = Integer.parseInt(latestDefs.getVersion());
                boolean useNewDefs = true;
                if (this.knxDataDefs.isDataIntegrityGood(true)) {
                    try {
                        int oldVersion = Integer.parseInt(this.knxDataDefs.getVersion());
                        if (latestVersion == oldVersion) {
                            if (!latestDefs.getKnxDefs().getSignature().equals(this.knxDataDefs.getKnxDefs().getSignature())) {
                                BDialog.error((BWidget)this.getDialog(), (String)lex.get(IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_LEX_KEY, IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_DEFAULT), (Object)lex.get(IMPORT_DATA_DEFS_PROBLEM_DIALOG_DIFFERENT_SIGNATURES_MESSAGE_LEX_KEY, IMPORT_DATA_DEFS_PROBLEM_DIALOG_DIFFERENT_SIGNATURES_MESSAGE_DEFAULT));
                            }
                            useNewDefs = false;
                        } else if (latestVersion < oldVersion) {
                            String message = MessageFormat.format(lex.get(IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_MESSAGE_LEX_KEY, IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_MESSAGE_DEFAULT), latestDefs.getVersion(), this.knxDataDefs.getVersion());
                            int dialogResult = BDialog.confirm((BWidget)this.getDialog(), (String)lex.get(IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_TITLE_LEX_KEY, IMPORT_DATA_DEFS_OLDER_VERSION_DIALOG_TITLE_DEFAULT), (Object)message);
                            if (dialogResult != 4) {
                                useNewDefs = false;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (useNewDefs) {
                    this.knxDataDefs.setKnxDefs((BKnxDataDefs)latestDefs.getKnxDefs().newCopy(true));
                    BDialog.info((BWidget)this.getDialog(), (String)lex.get(IMPORT_DATA_DEFS_FINISHED_DIALOG_TITLE_LEX_KEY, IMPORT_DATA_DEFS_FINISHED_DIALOG_TITLE_DEFAULT), (Object)lex.get(IMPORT_DATA_DEFS_FINISHED_DIALOG_MESSAGE_LEX_KEY, IMPORT_DATA_DEFS_FINISHED_DIALOG_MESSAGE_DEFAULT));
                }
            } else {
                BDialog.error((BWidget)this.getDialog(), (String)lex.get(IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_LEX_KEY, IMPORT_DATA_DEFS_PROBLEM_DIALOG_TITLE_DEFAULT), (Object)lex.get(IMPORT_DATA_DEFS_PROBLEM_DIALOG_NO_FILE_LEX_KEY, IMPORT_DATA_DEFS_PROBLEM_DIALOG_NO_FILE_DEFAULT));
            }
        }

        public void doCancel() throws Exception {
        }

        @Override
        public boolean isCancelled() {
            return !this.isAlive();
        }

        @Override
        public ImportProblemReports getImportProblemReports() {
            if (this.importProblemReports == null) {
                this.importProblemReports = new ImportProblemReports();
            }
            return this.importProblemReports;
        }

        @Override
        public String preProcessEnumImport(XmlPropertyImportSpec propertySpec, String sNewVal) {
            return sNewVal;
        }
    }
}

